/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.navigation;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.YAMLUtil;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLSequence;
import org.jetbrains.yaml.psi.YamlRecursivePsiElementVisitor;

public final class YAMLKeysIndex
extends FileBasedIndexExtension<String, Integer> {
    @NonNls
    public static final ID<String, Integer> KEY = ID.create((String)"yaml.keys.name");

    public int getVersion() {
        return 1;
    }

    @NotNull
    public DataIndexer<String, Integer, FileContent> getIndexer() {
        return new DataIndexer<String, Integer, FileContent>(){

            @NotNull
            public Map<String, Integer> map(@NotNull FileContent inputData) {
                Object2IntOpenHashMap map = new Object2IntOpenHashMap();
                inputData.getPsiFile().accept((PsiElementVisitor)new YamlRecursivePsiElementVisitor((Object2IntMap)map){
                    final /* synthetic */ Object2IntMap val$map;
                    {
                        this.val$map = object2IntMap;
                    }

                    @Override
                    public void visitKeyValue(@NotNull YAMLKeyValue keyValue) {
                        PsiElement key = keyValue.getKey();
                        if (key != null) {
                            this.val$map.put((Object)YAMLUtil.getConfigFullName(keyValue), key.getTextOffset());
                        }
                        super.visitKeyValue(keyValue);
                    }

                    @Override
                    public void visitSequence(@NotNull YAMLSequence sequence) {
                    }
                });
                return map;
            }
        };
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        return EnumeratorStringDescriptor.INSTANCE;
    }

    @NotNull
    public DataExternalizer<Integer> getValueExternalizer() {
        return new DataExternalizer<Integer>(){

            public void save(@NotNull DataOutput out, Integer value) throws IOException {
                out.writeInt(value);
            }

            public Integer read(@NotNull DataInput in) throws IOException {
                return in.readInt();
            }
        };
    }

    @NotNull
    public ID<String, Integer> getName() {
        return KEY;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        return YAMLUtil.YAML_INPUT_FILTER;
    }

    public boolean dependsOnFileContent() {
        return true;
    }
}

