/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.meta.model;

import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.meta.model.TypeFieldPair;
import org.jetbrains.yaml.meta.model.YamlMetaType;
import org.jetbrains.yaml.meta.model.YamlScalarType;
import org.jetbrains.yaml.psi.YAMLKeyValue;

@ApiStatus.Internal
public class Field {
    private final String myName;
    private final MetaTypeSupplier myMetaTypeSupplier;
    private YamlMetaType myMainType;
    private boolean myIsRequired;
    private boolean myEditable = true;
    private boolean myDeprecated = false;
    private boolean myAnyNameAllowed;
    private boolean myEmptyValueAllowed;
    private boolean myIsMany;
    private Relation myOverriddenDefaultRelation;
    private final Map<Relation, YamlMetaType> myPerRelationTypes = new HashMap<Relation, YamlMetaType>();

    public Field(@NonNls @NotNull String name, @NotNull YamlMetaType mainType) {
        this(name, () -> mainType);
    }

    public Field(@NonNls @NotNull String name, @NotNull MetaTypeSupplier supplier) {
        this.myName = name;
        this.myMetaTypeSupplier = supplier;
    }

    @NotNull
    public Field withDefaultRelation(@NotNull Relation relation) {
        this.myOverriddenDefaultRelation = relation;
        return this;
    }

    public Field withRelationSpecificType(@NotNull Relation relation, @NotNull YamlMetaType specificType) {
        this.myPerRelationTypes.put(relation, specificType);
        return this;
    }

    @NotNull
    public Field withMultiplicityMany() {
        return this.withMultiplicityManyNotOne(true);
    }

    @NotNull
    public Field withMultiplicityManyNotOne(boolean manyNotOne) {
        this.myIsMany = manyNotOne;
        return this;
    }

    @Contract(pure=true)
    public boolean isMany() {
        return this.myIsMany;
    }

    @NotNull
    public Field setRequired() {
        this.myIsRequired = true;
        return this;
    }

    @NotNull
    public Field setDeprecated() {
        this.myDeprecated = true;
        return this;
    }

    @NotNull
    public Field setNonEditable() {
        this.myEditable = false;
        return this;
    }

    @Contract(pure=true)
    public final boolean isRequired() {
        return this.myIsRequired;
    }

    @Contract(pure=true)
    public final boolean isEditable() {
        return this.myEditable;
    }

    @Contract(pure=true)
    public boolean isDeprecated() {
        return this.myDeprecated;
    }

    @Contract(pure=true)
    public final String getName() {
        return this.myName;
    }

    @Contract(pure=true)
    @NotNull
    public YamlMetaType getType(@NotNull Relation relation) {
        return this.myPerRelationTypes.getOrDefault((Object)relation, this.getMainType());
    }

    @Contract(pure=true)
    @NotNull
    public YamlMetaType getDefaultType() {
        return this.getType(this.getDefaultRelation());
    }

    @NotNull
    public Relation getDefaultRelation() {
        if (this.myOverriddenDefaultRelation != null) {
            return this.myOverriddenDefaultRelation;
        }
        if (this.myIsMany) {
            return Relation.SEQUENCE_ITEM;
        }
        return this.getMainType() instanceof YamlScalarType ? Relation.SCALAR_VALUE : Relation.OBJECT_CONTENTS;
    }

    @NotNull
    public Field withEmptyValueAllowed(boolean allow) {
        this.myEmptyValueAllowed = allow;
        return this;
    }

    @NotNull
    public final Field withAnyName() {
        return this.withAnyName(true);
    }

    @NotNull
    public Field withAnyName(boolean allowAnyName) {
        this.myAnyNameAllowed = allowAnyName;
        return this;
    }

    public final boolean isAnyNameAllowed() {
        return this.myAnyNameAllowed;
    }

    public final boolean isEmptyValueAllowed() {
        return this.myEmptyValueAllowed;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("[").append(this.getName()).append("]@");
        result.append(Integer.toHexString(this.hashCode()));
        result.append(" : ");
        result.append(this.getMainType().getTypeName());
        List nonDefaultTypes = this.myPerRelationTypes.entrySet().stream().filter(e -> e.getValue() == this.getMainType()).map(e -> e.getKey() + ":" + e.getValue()).collect(Collectors.toList());
        if (!nonDefaultTypes.isEmpty()) {
            result.append(nonDefaultTypes);
        }
        return result.toString();
    }

    @NotNull
    public List<LookupElementBuilder> getKeyLookups(@NotNull YamlMetaType ownerClass, @NotNull PsiElement insertedScalar) {
        if (this.isAnyNameAllowed()) {
            return Collections.emptyList();
        }
        LookupElementBuilder lookup = LookupElementBuilder.create((Object)new TypeFieldPair(ownerClass, this), (String)this.getName()).withTypeText(this.getMainType().getDisplayName(), true).withIcon(this.getLookupIcon()).withStrikeoutness(this.isDeprecated());
        if (this.isRequired()) {
            lookup = lookup.bold();
        }
        return Collections.singletonList(lookup);
    }

    @Nullable
    public PsiReference getReferenceFromKey(@NotNull YAMLKeyValue keyValue) {
        return null;
    }

    public boolean hasRelationSpecificType(@NotNull Relation relation) {
        return relation == this.getDefaultRelation() || this.myPerRelationTypes.containsKey((Object)relation);
    }

    @Nullable
    public Icon getLookupIcon() {
        return this.myIsMany ? AllIcons.Json.Array : this.getMainType().getIcon();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private YamlMetaType getMainType() {
        if (this.myMainType != null) {
            return this.myMainType;
        }
        MetaTypeSupplier metaTypeSupplier = this.myMetaTypeSupplier;
        synchronized (metaTypeSupplier) {
            if (this.myMainType == null) {
                try {
                    this.myMainType = this.myMetaTypeSupplier.getMainType();
                }
                catch (Exception e) {
                    throw new RuntimeException("Supplier failed to return a metatype for field: " + this, e);
                }
            }
            return this.myMainType;
        }
    }

    public static interface MetaTypeSupplier {
        @NotNull
        public YamlMetaType getMainType();
    }

    public static enum Relation {
        SCALAR_VALUE,
        SEQUENCE_ITEM,
        OBJECT_CONTENTS;

    }
}

