/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.annotator;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.YAMLBundle;
import org.jetbrains.yaml.YAMLTokenTypes;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLSequenceItem;
import org.jetbrains.yaml.psi.YAMLValue;
import org.jetbrains.yaml.psi.impl.YAMLBlockMappingImpl;
import org.jetbrains.yaml.psi.impl.YAMLBlockSequenceImpl;

public class YAMLSameLineCompositeValueErrorAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        YAMLKeyValue firstSubValue;
        if (!(element instanceof YAMLKeyValue)) {
            return;
        }
        YAMLKeyValue keyValue = (YAMLKeyValue)element;
        if (YAMLSameLineCompositeValueErrorAnnotator.hasOuterElements((PsiElement)keyValue)) {
            return;
        }
        PsiFile file = keyValue.getContainingFile();
        if (file == null) {
            return;
        }
        PsiElement key = keyValue.getKey();
        if (key == null) {
            return;
        }
        Document document = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file);
        if (document == null) {
            return;
        }
        CharSequence documentContent = document.getCharsSequence();
        YAMLValue value = keyValue.getValue();
        if (value instanceof YAMLBlockMappingImpl && YAMLSameLineCompositeValueErrorAnnotator.psiAreAtTheSameLine(key, (PsiElement)(firstSubValue = ((YAMLBlockMappingImpl)value).getFirstKeyValue()), documentContent)) {
            YAMLSameLineCompositeValueErrorAnnotator.reportAboutSameLine(holder, value);
        }
        if (value instanceof YAMLBlockSequenceImpl) {
            List<YAMLSequenceItem> items = ((YAMLBlockSequenceImpl)value).getItems();
            if (items.isEmpty()) {
                return;
            }
            YAMLSequenceItem firstItem = items.get(0);
            if (YAMLSameLineCompositeValueErrorAnnotator.psiAreAtTheSameLine(key, (PsiElement)firstItem, documentContent)) {
                YAMLSameLineCompositeValueErrorAnnotator.reportAboutSameLine(holder, value);
            }
        }
    }

    private static void reportAboutSameLine(@NotNull AnnotationHolder holder, @NotNull YAMLValue value) {
        holder.newAnnotation(HighlightSeverity.ERROR, YAMLBundle.message("annotator.same.line.composed.value.message", new Object[0])).range((PsiElement)value).create();
    }

    private static boolean psiAreAtTheSameLine(@NotNull PsiElement psi1, @NotNull PsiElement psi2, @NotNull CharSequence documentContent) {
        PsiElement leaf = PsiTreeUtil.nextLeaf((PsiElement)psi1);
        PsiElement lastLeaf = PsiTreeUtil.prevLeaf((PsiElement)psi2);
        while (leaf != null) {
            if (PsiUtilCore.getElementType((PsiElement)leaf) == YAMLTokenTypes.EOL) {
                return false;
            }
            if (leaf == lastLeaf) {
                return true;
            }
            leaf = PsiTreeUtil.nextLeaf((PsiElement)leaf);
        }
        return false;
    }

    private static boolean hasOuterElements(PsiElement element) {
        Collection outerElements = PsiTreeUtil.findChildrenOfType((PsiElement)element, OuterLanguageElement.class);
        return !outerElements.isEmpty();
    }
}

