/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.util.Disposer;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.impl.JavaPsiFacadeEx;
import com.intellij.testFramework.IdeaTestUtil;
import com.intellij.testFramework.LightPlatformCodeInsightTestCase;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public abstract class LightJavaCodeInsightTestCase
extends LightPlatformCodeInsightTestCase {
    private static final Pattern JDK_SELECT_PATTERN = Pattern.compile("Java([\\d.]+)(Preview)?(\\.java)?$");
    private final Disposable myBeforeParentDisposeDisposable = Disposer.newDisposable();

    public JavaPsiFacadeEx getJavaFacade() {
        return JavaPsiFacadeEx.getInstanceEx((Project)this.getProject());
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.setLanguageLevel(this.getLanguageLevel());
    }

    protected void tearDown() throws Exception {
        try {
            Disposer.dispose((Disposable)this.myBeforeParentDisposeDisposable);
        }
        catch (Throwable e) {
            this.addSuppressedException(e);
        }
        finally {
            super.tearDown();
        }
    }

    protected LanguageLevel getLanguageLevel() {
        LanguageLevel level;
        Matcher matcher = JDK_SELECT_PATTERN.matcher(this.getTestName(false));
        if (matcher.find() && (level = LanguageLevel.parse((String)matcher.group(1))) != null) {
            String group = matcher.group(2);
            if (group != null) {
                level = LanguageLevel.valueOf((String)(level + "_PREVIEW"));
            }
            return level;
        }
        return this.getDefaultLanguageLevel();
    }

    protected LanguageLevel getDefaultLanguageLevel() {
        return LanguageLevel.HIGHEST;
    }

    protected void setLanguageLevel(@NotNull LanguageLevel level) {
        LanguageLevelProjectExtension extension = LanguageLevelProjectExtension.getInstance((Project)this.getProject());
        LanguageLevel prev = extension.getLanguageLevel();
        extension.setLanguageLevel(level);
        Disposer.register((Disposable)this.myBeforeParentDisposeDisposable, () -> extension.setLanguageLevel(prev));
    }

    protected Sdk getProjectJDK() {
        return IdeaTestUtil.getMockJdk18();
    }

    @NotNull
    protected String getModuleTypeId() {
        return "JAVA_MODULE";
    }
}

