/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.nj2k.inference.mutability;

import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacade;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.nj2k.inference.common.BoundType;
import org.jetbrains.kotlin.nj2k.inference.common.BoundTypeCalculatorImpl;
import org.jetbrains.kotlin.nj2k.inference.common.BoundTypeEnhancer;
import org.jetbrains.kotlin.nj2k.inference.common.InferenceContext;
import org.jetbrains.kotlin.nj2k.inference.mutability.CallResolver;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/nj2k/inference/mutability/MutabilityBoundTypeCalculator;", "Lorg/jetbrains/kotlin/nj2k/inference/common/BoundTypeCalculatorImpl;", "resolutionFacade", "Lorg/jetbrains/kotlin/idea/resolve/ResolutionFacade;", "enhancer", "Lorg/jetbrains/kotlin/nj2k/inference/common/BoundTypeEnhancer;", "(Lorg/jetbrains/kotlin/idea/resolve/ResolutionFacade;Lorg/jetbrains/kotlin/nj2k/inference/common/BoundTypeEnhancer;)V", "callResolver", "Lorg/jetbrains/kotlin/nj2k/inference/mutability/CallResolver;", "interceptCalculateBoundType", "Lorg/jetbrains/kotlin/nj2k/inference/common/BoundType;", "inferenceContext", "Lorg/jetbrains/kotlin/nj2k/inference/common/InferenceContext;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "Companion", "kotlin.j2k.services"})
public final class MutabilityBoundTypeCalculator
extends BoundTypeCalculatorImpl {
    private final CallResolver callResolver;
    private final ResolutionFacade resolutionFacade;
    private static final Set<FqName> PRESERVING_MUTABILITY_FQ_NAMES;
    @NotNull
    public static final Companion Companion;

    @Override
    @Nullable
    public BoundType interceptCalculateBoundType(@NotNull InferenceContext inferenceContext2, @NotNull KtExpression expression) {
        BoundType boundType;
        Intrinsics.checkNotNullParameter((Object)inferenceContext2, (String)"inferenceContext");
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        KtExpression ktExpression = expression;
        if (ktExpression instanceof KtQualifiedExpression) {
            KtExpression ktExpression2 = ((KtQualifiedExpression)expression).getSelectorExpression();
            if (ktExpression2 == null) {
                return null;
            }
            KtExpression selector = ktExpression2;
            boundType = this.callResolver.isNeededCall(selector, this.resolutionFacade) ? this.boundType(((KtQualifiedExpression)expression).getReceiverExpression(), inferenceContext2) : null;
        } else {
            boundType = null;
        }
        return boundType;
    }

    public MutabilityBoundTypeCalculator(@NotNull ResolutionFacade resolutionFacade2, @NotNull BoundTypeEnhancer enhancer) {
        Intrinsics.checkNotNullParameter((Object)resolutionFacade2, (String)"resolutionFacade");
        Intrinsics.checkNotNullParameter((Object)enhancer, (String)"enhancer");
        super(resolutionFacade2, enhancer);
        this.resolutionFacade = resolutionFacade2;
        this.callResolver = new CallResolver(PRESERVING_MUTABILITY_FQ_NAMES);
    }

    static {
        Companion = new Companion(null);
        PRESERVING_MUTABILITY_FQ_NAMES = SetsKt.setOf((Object[])new FqName[]{StandardNames.FqNames.collection.child(Name.identifier((String)"iterator")), StandardNames.FqNames.list.child(Name.identifier((String)"listIterator")), StandardNames.FqNames.map.child(Name.identifier((String)"entries")), StandardNames.FqNames.map.child(Name.identifier((String)"values"))});
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/nj2k/inference/mutability/MutabilityBoundTypeCalculator$Companion;", "", "()V", "PRESERVING_MUTABILITY_FQ_NAMES", "", "Lorg/jetbrains/kotlin/name/FqName;", "kotlin.j2k.services"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

