/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.storage;

import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;

final class MurmurHashingService {
    static final int HASH_SIZE = 16;

    MurmurHashingService() {
    }

    static byte[] getStringHash(@NotNull String hashableString) {
        Hasher hasher = Hashing.murmur3_128().newHasher();
        hasher.putString((CharSequence)hashableString, StandardCharsets.UTF_8);
        return hasher.hash().asBytes();
    }

    static byte[] getFileHash(@NotNull File file) throws IOException {
        Hasher hasher = Hashing.murmur3_128().newHasher();
        try (FileInputStream fis = new FileInputStream(file);
             FileChannel fileChannel = fis.getChannel();){
            ByteBuffer buffer = ByteBuffer.allocate(0x100000);
            while (fileChannel.read(buffer) > 0) {
                buffer.flip();
                hasher.putBytes(buffer);
                buffer.clear();
            }
        }
        return hasher.hash().asBytes();
    }
}

