/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.storage;

import com.intellij.util.ArrayUtil;
import com.intellij.util.io.DataExternalizer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.incremental.relativizer.PathRelativizerService;
import org.jetbrains.jps.incremental.storage.AbstractStateStorage;
import org.jetbrains.jps.incremental.storage.BuildTargetsState;
import org.jetbrains.jps.incremental.storage.FileTimestampStorage;
import org.jetbrains.jps.incremental.storage.MurmurHashingService;
import org.jetbrains.jps.incremental.storage.PathStringDescriptor;
import org.jetbrains.jps.incremental.storage.StampsStorage;

public class FileStampStorage
extends AbstractStateStorage<String, HashStampPerTarget[]>
implements StampsStorage<FileStamp> {
    private final FileTimestampStorage myTimestampStorage;
    private final PathRelativizerService myRelativizer;
    private final BuildTargetsState myTargetsState;
    private final File myFileStampRoot;

    public FileStampStorage(File dataStorageRoot, PathRelativizerService relativizer, BuildTargetsState targetsState) throws IOException {
        super(new File(FileStampStorage.calcStorageRoot(dataStorageRoot), "data"), PathStringDescriptor.INSTANCE, new StateExternalizer());
        this.myTimestampStorage = new FileTimestampStorage(dataStorageRoot, targetsState);
        this.myFileStampRoot = FileStampStorage.calcStorageRoot(dataStorageRoot);
        this.myRelativizer = relativizer;
        this.myTargetsState = targetsState;
    }

    @NotNull
    private String relativePath(@NotNull File file) {
        return this.myRelativizer.toRelative(file.getAbsolutePath());
    }

    @NotNull
    private static File calcStorageRoot(File dataStorageRoot) {
        return new File(dataStorageRoot, "hashes");
    }

    @Override
    public File getStorageRoot() {
        return this.myFileStampRoot;
    }

    @Override
    public void saveStamp(File file, BuildTarget<?> buildTarget, FileStamp stamp) throws IOException {
        this.myTimestampStorage.saveStamp(file, buildTarget, FileTimestampStorage.Timestamp.fromLong(stamp.myTimestamp));
        int targetId = this.myTargetsState.getBuildTargetId(buildTarget);
        String path = this.relativePath(file);
        this.update(path, FileStampStorage.updateFilesStamp((HashStampPerTarget[])this.getState(path), targetId, stamp));
    }

    private static HashStampPerTarget @NotNull [] updateFilesStamp(HashStampPerTarget[] oldState, int targetId, FileStamp stamp) {
        HashStampPerTarget newItem = new HashStampPerTarget(targetId, stamp.myBytes);
        if (oldState == null) {
            return new HashStampPerTarget[]{newItem};
        }
        int length = oldState.length;
        for (int i = 0; i < length; ++i) {
            if (oldState[i].targetId != targetId) continue;
            oldState[i] = newItem;
            return oldState;
        }
        return (HashStampPerTarget[])ArrayUtil.append((Object[])oldState, (Object)newItem);
    }

    @Override
    public void removeStamp(File file, BuildTarget<?> buildTarget) throws IOException {
        this.myTimestampStorage.removeStamp(file, buildTarget);
        String path = this.relativePath(file);
        Object[] state = (HashStampPerTarget[])this.getState(path);
        if (state != null) {
            int targetId = this.myTargetsState.getBuildTargetId(buildTarget);
            for (int i = 0; i < state.length; ++i) {
                if (state[i].targetId != targetId) continue;
                if (state.length == 1) {
                    this.remove(path);
                    continue;
                }
                HashStampPerTarget[] newState = (HashStampPerTarget[])ArrayUtil.remove((Object[])state, (int)i);
                this.update(path, newState);
                break;
            }
        }
    }

    @Override
    public FileStamp getPreviousStamp(File file, BuildTarget<?> target) throws IOException {
        StampsStorage.Stamp previousTimestamp = this.myTimestampStorage.getPreviousStamp(file, (BuildTarget)target);
        HashStampPerTarget[] state = (HashStampPerTarget[])this.getState(this.relativePath(file));
        if (state != null) {
            int targetId = this.myTargetsState.getBuildTargetId(target);
            for (HashStampPerTarget filesStampPerTarget : state) {
                if (filesStampPerTarget.targetId != targetId) continue;
                return new FileStamp(filesStampPerTarget.hash, ((FileTimestampStorage.Timestamp)previousTimestamp).asLong());
            }
        }
        return FileStamp.EMPTY;
    }

    public byte @Nullable [] getStoredFileHash(File file, BuildTarget<?> target) throws IOException {
        HashStampPerTarget[] state = (HashStampPerTarget[])this.getState(this.relativePath(file));
        if (state == null) {
            return null;
        }
        int targetId = this.myTargetsState.getBuildTargetId(target);
        for (HashStampPerTarget filesStampPerTarget : state) {
            if (filesStampPerTarget.targetId != targetId) continue;
            return filesStampPerTarget.hash;
        }
        return null;
    }

    @Override
    public FileStamp getCurrentStamp(File file) throws IOException {
        FileTimestampStorage.Timestamp currentTimestamp = this.myTimestampStorage.getCurrentStamp(file);
        return new FileStamp(MurmurHashingService.getFileHash(file), currentTimestamp.asLong());
    }

    @Override
    public boolean isDirtyStamp(@NotNull StampsStorage.Stamp stamp, File file) throws IOException {
        if (!(stamp instanceof FileStamp)) {
            return true;
        }
        FileStamp filesStamp = (FileStamp)stamp;
        if (!this.myTimestampStorage.isDirtyStamp(FileTimestampStorage.Timestamp.fromLong(filesStamp.myTimestamp), file)) {
            return false;
        }
        return !Arrays.equals(filesStamp.myBytes, MurmurHashingService.getFileHash(file));
    }

    @Override
    public boolean isDirtyStamp(StampsStorage.Stamp stamp, File file, @NotNull BasicFileAttributes attrs) throws IOException {
        if (!(stamp instanceof FileStamp)) {
            return true;
        }
        FileStamp filesStamp = (FileStamp)stamp;
        if (!this.myTimestampStorage.isDirtyStamp(FileTimestampStorage.Timestamp.fromLong(filesStamp.myTimestamp), file, attrs)) {
            return false;
        }
        return !Arrays.equals(filesStamp.myBytes, MurmurHashingService.getFileHash(file));
    }

    @Override
    public void force() {
        super.force();
        this.myTimestampStorage.force();
    }

    @Override
    public void clean() throws IOException {
        super.clean();
        this.myTimestampStorage.clean();
    }

    @Override
    public boolean wipe() {
        return super.wipe() && this.myTimestampStorage.wipe();
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.myTimestampStorage.close();
    }

    private static class StateExternalizer
    implements DataExternalizer<HashStampPerTarget[]> {
        private StateExternalizer() {
        }

        public void save(@NotNull DataOutput out, HashStampPerTarget[] value) throws IOException {
            out.writeInt(value.length);
            for (HashStampPerTarget target : value) {
                out.writeInt(target.targetId);
                out.write(target.hash);
            }
        }

        public HashStampPerTarget[] read(@NotNull DataInput in) throws IOException {
            int size = in.readInt();
            HashStampPerTarget[] targets = new HashStampPerTarget[size];
            for (int i = 0; i < size; ++i) {
                int id = in.readInt();
                byte[] bytes = new byte[16];
                in.readFully(bytes);
                targets[i] = new HashStampPerTarget(id, bytes);
            }
            return targets;
        }
    }

    static class FileStamp
    implements StampsStorage.Stamp {
        static FileStamp EMPTY = new FileStamp(new byte[0], -1L);
        private final byte[] myBytes;
        private final long myTimestamp;

        private FileStamp(byte[] bytes, long timestamp) {
            this.myBytes = bytes;
            this.myTimestamp = timestamp;
        }

        public String toString() {
            return "FileStamp{myBytes=" + Arrays.toString(this.myBytes) + ", myTimestamp=" + this.myTimestamp + '}';
        }
    }

    static class HashStampPerTarget {
        public final int targetId;
        public final byte[] hash;

        private HashStampPerTarget(int targetId, byte[] hash) {
            this.targetId = targetId;
            this.hash = hash;
        }
    }
}

