/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental;

import gnu.trove.THashMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.impl.BuildOutputConsumerImpl;
import org.jetbrains.jps.incremental.BinaryContent;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.CompiledClass;
import org.jetbrains.jps.incremental.ModuleLevelBuilder;

class ChunkBuildOutputConsumerImpl
implements ModuleLevelBuilder.OutputConsumer {
    private final CompileContext myContext;
    private final Map<BuildTarget<?>, BuildOutputConsumerImpl> myTarget2Consumer = new THashMap();
    private final Map<String, CompiledClass> myClasses = new THashMap();
    private final Map<BuildTarget<?>, Collection<CompiledClass>> myTargetToClassesMap = new THashMap();

    ChunkBuildOutputConsumerImpl(CompileContext context) {
        this.myContext = context;
    }

    @Override
    public Collection<CompiledClass> getTargetCompiledClasses(@NotNull BuildTarget<?> target) {
        Collection<CompiledClass> classes = this.myTargetToClassesMap.get(target);
        if (classes != null) {
            return Collections.unmodifiableCollection(classes);
        }
        return Collections.emptyList();
    }

    @Override
    @NotNull
    public Map<String, CompiledClass> getCompiledClasses() {
        return Collections.unmodifiableMap(this.myClasses);
    }

    @Override
    @Nullable
    public BinaryContent lookupClassBytes(String className) {
        CompiledClass object = this.myClasses.get(className);
        return object != null ? object.getContent() : null;
    }

    @Override
    public void registerCompiledClass(@Nullable BuildTarget<?> target, CompiledClass compiled) throws IOException {
        if (compiled.getClassName() != null) {
            this.myClasses.put(compiled.getClassName(), compiled);
            if (target != null) {
                Collection<CompiledClass> classes = this.myTargetToClassesMap.get(target);
                if (classes == null) {
                    classes = new ArrayList<CompiledClass>();
                    this.myTargetToClassesMap.put(target, classes);
                }
                classes.add(compiled);
            }
        }
        if (target != null) {
            this.registerOutputFile(target, compiled.getOutputFile(), compiled.getSourceFilesPaths());
        }
    }

    @Override
    public void registerOutputFile(@NotNull BuildTarget<?> target, File outputFile, Collection<String> sourcePaths) throws IOException {
        BuildOutputConsumerImpl consumer = this.myTarget2Consumer.get(target);
        if (consumer == null) {
            consumer = new BuildOutputConsumerImpl(target, this.myContext);
            this.myTarget2Consumer.put(target, consumer);
        }
        consumer.registerOutputFile(outputFile, sourcePaths);
    }

    public void fireFileGeneratedEvents() {
        for (BuildOutputConsumerImpl consumer : this.myTarget2Consumer.values()) {
            consumer.fireFileGeneratedEvent();
        }
    }

    public int getNumberOfProcessedSources() {
        int total = 0;
        for (BuildOutputConsumerImpl consumer : this.myTarget2Consumer.values()) {
            total += consumer.getNumberOfProcessedSources();
        }
        return total;
    }

    public void clear() {
        this.myTarget2Consumer.clear();
        this.myClasses.clear();
        this.myTargetToClassesMap.clear();
    }
}

