/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.cmdline;

import com.intellij.openapi.diagnostic.Log4jBasedLogger;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.jetbrains.annotations.NotNull;

public final class LogSetup {
    public static final String LOG_CONFIG_FILE_NAME = "build-log.properties";
    private static final String LOG_FILE_NAME = "build.log";
    private static final String LOG_FILE_MACRO = "$LOG_FILE_PATH$";

    public static void initLoggers() {
        if (!Boolean.parseBoolean(System.getProperty("jps.use.default.file.logging", "true"))) {
            return;
        }
        try {
            String logDir = System.getProperty("jps.log.dir", null);
            Path configFile = logDir == null ? Paths.get(LOG_CONFIG_FILE_NAME, new String[0]) : Paths.get(logDir, LOG_CONFIG_FILE_NAME);
            LogSetup.ensureLogConfigExists(configFile);
            String logFile = logDir == null ? LOG_FILE_NAME : Paths.get(logDir, LOG_FILE_NAME).toAbsolutePath().toString();
            String text = new String(Files.readAllBytes(configFile), StandardCharsets.UTF_8).replace(LOG_FILE_MACRO, logFile.replace("\\", "\\\\"));
            PropertyConfigurator.configure((InputStream)new ByteArrayInputStream(text.getBytes(StandardCharsets.UTF_8)));
        }
        catch (IOException e) {
            System.err.println("Failed to configure logging: ");
            e.printStackTrace(System.err);
        }
        com.intellij.openapi.diagnostic.Logger.setFactory(category -> new Log4jBasedLogger(Logger.getLogger((String)category)));
    }

    private static void ensureLogConfigExists(@NotNull Path logConfig) throws IOException {
        if (!Files.exists(logConfig, new LinkOption[0])) {
            Files.createDirectories(logConfig.getParent(), new FileAttribute[0]);
            try (InputStream in = LogSetup.readDefaultLogConfig();){
                if (in != null) {
                    Files.copy(in, logConfig, new CopyOption[0]);
                }
            }
        }
    }

    public static InputStream readDefaultLogConfig() {
        return LogSetup.class.getResourceAsStream("/defaultLogConfig.properties");
    }
}

