/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.backwardRefs;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.backwardRefs.JavaBackwardReferenceIndexWriter;
import org.jetbrains.jps.builders.BuildTargetIndex;
import org.jetbrains.jps.builders.BuildTargetRegistry;
import org.jetbrains.jps.builders.DirtyFilesHolder;
import org.jetbrains.jps.builders.ModuleBasedTarget;
import org.jetbrains.jps.builders.java.JavaSourceRootDescriptor;
import org.jetbrains.jps.incremental.BuilderCategory;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.ModuleLevelBuilder;
import org.jetbrains.jps.incremental.ProjectBuildException;
import org.jetbrains.jps.incremental.messages.CustomBuilderMessage;
import org.jetbrains.jps.model.module.JpsModule;

public class JavaBackwardReferenceIndexBuilder
extends ModuleLevelBuilder {
    private static final Logger LOG = Logger.getInstance(JavaBackwardReferenceIndexBuilder.class);
    public static final String BUILDER_ID = "compiler.ref.index";
    private static final String MESSAGE_TYPE = "processed module";
    private final Set<ModuleBuildTarget> myCompiledTargets = ContainerUtil.newConcurrentSet();

    public JavaBackwardReferenceIndexBuilder() {
        super(BuilderCategory.CLASS_POST_PROCESSOR);
    }

    @Override
    @NotNull
    public String getPresentableName() {
        return "backward-references indexer";
    }

    @Override
    public void buildStarted(CompileContext context) {
        JavaBackwardReferenceIndexWriter.initialize(context);
    }

    @Override
    public void buildFinished(CompileContext context) {
        if (JavaBackwardReferenceIndexWriter.getInstance() != null) {
            BuildTargetIndex targetIndex = context.getProjectDescriptor().getBuildTargetIndex();
            for (JpsModule module : context.getProjectDescriptor().getProject().getModules()) {
                boolean allAreDummyOrCompiled = true;
                for (ModuleBasedTarget<?> target : targetIndex.getModuleBasedTargets(module, BuildTargetRegistry.ModuleTargetSelector.ALL)) {
                    if (!(target instanceof ModuleBuildTarget) || this.myCompiledTargets.contains(target) || targetIndex.isDummy(target)) continue;
                    allAreDummyOrCompiled = false;
                }
                if (!allAreDummyOrCompiled) continue;
                context.processMessage(new CustomBuilderMessage(BUILDER_ID, MESSAGE_TYPE, module.getName()));
            }
            this.myCompiledTargets.clear();
        }
        JavaBackwardReferenceIndexWriter.closeIfNeeded(false);
    }

    @Override
    @NotNull
    public List<String> getCompilableFileExtensions() {
        return Collections.emptyList();
    }

    @Override
    public ModuleLevelBuilder.ExitCode build(CompileContext context, ModuleChunk chunk, DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> dirtyFilesHolder, ModuleLevelBuilder.OutputConsumer outputConsumer) throws ProjectBuildException, IOException {
        JavaBackwardReferenceIndexWriter writer = JavaBackwardReferenceIndexWriter.getInstance();
        if (writer != null) {
            Throwable cause = writer.getRebuildRequestCause();
            if (cause != null) {
                LOG.error("compiler reference index will be deleted", cause);
                JavaBackwardReferenceIndexWriter.closeIfNeeded(true);
            }
            if (dirtyFilesHolder.hasRemovedFiles()) {
                for (ModuleBuildTarget target : chunk.getTargets()) {
                    Collection<String> files = dirtyFilesHolder.getRemovedFiles(target);
                    writer.processDeletedFiles(files);
                }
            }
            for (ModuleBuildTarget target : chunk.getTargets()) {
                if (!context.getScope().isWholeTargetAffected(target)) continue;
                this.myCompiledTargets.add(target);
            }
        }
        return null;
    }
}

