/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.tooling.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReflectionUtil {
    @Nullable
    public static Object callByReflection(@NotNull Object receiver, @NotNull String methodName) {
        Logger logger = Logging.getLogger(ReflectionUtil.class);
        Object result = null;
        try {
            Method getMethod = receiver.getClass().getMethod(methodName, new Class[0]);
            result = getMethod.invoke(receiver, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            logger.warn("Can not find `" + methodName + "` for receiver [" + receiver + "], gradle version " + GradleVersion.current(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.warn("Can not call `" + methodName + "` for receiver [" + receiver + "], gradle version " + GradleVersion.current(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            logger.warn("Can not call `" + methodName + "` for receiver [" + receiver + "], gradle version " + GradleVersion.current(), (Throwable)e);
        }
        return result;
    }
}

