/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.tooling.tasks;

import com.google.gson.GsonBuilder;
import com.intellij.openapi.externalSystem.model.project.dependencies.ArtifactDependencyNodeImpl;
import com.intellij.openapi.externalSystem.model.project.dependencies.DependencyNode;
import com.intellij.openapi.externalSystem.model.project.dependencies.DependencyScopeNode;
import com.intellij.openapi.externalSystem.model.project.dependencies.FileCollectionDependencyNodeImpl;
import com.intellij.openapi.externalSystem.model.project.dependencies.ProjectDependencyNodeImpl;
import com.intellij.openapi.externalSystem.model.project.dependencies.ReferenceNode;
import com.intellij.openapi.externalSystem.model.project.dependencies.UnknownDependencyNode;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.gradle.api.DefaultTask;
import org.gradle.api.Describable;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.FileCollectionDependency;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.result.ResolutionResult;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.diagnostics.internal.graph.nodes.RenderableDependency;
import org.gradle.api.tasks.diagnostics.internal.graph.nodes.RenderableModuleResult;
import org.gradle.util.GradleVersion;

public class DependenciesReport
extends DefaultTask
implements GroovyObject {
    @Input
    private List<String> configurations;
    @OutputFile
    private File outputFile;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public DependenciesReport() {
        MetaClass metaClass;
        List list;
        this.configurations = list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @TaskAction
    public void generate() {
        ConfigurationContainer configurationList = null;
        if (this.configurations.isEmpty()) {
            ConfigurationContainer configurationContainer;
            configurationList = configurationContainer = ((ProjectInternal)this.getProject()).getConfigurations();
        } else {
            ConfigurationContainer configurationContainer;
            configurationList = configurationContainer = new ArrayList();
            String configurationName = null;
            Iterator<String> iterator = this.configurations.iterator();
            while (iterator.hasNext()) {
                configurationName = ShortTypeHandling.castToString((Object)iterator.next());
                Configuration configuration = (Configuration)ScriptBytecodeAdapter.castToType((Object)((ProjectInternal)this.getProject()).getConfigurations().findByName(configurationName), Configuration.class);
                if (!(configuration != null)) continue;
                ((ArrayList)configurationList).add(configuration);
            }
        }
        ProjectNameFunction projectNameFunction = new ProjectNameFunction();
        List graph = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        Configuration configuration = null;
        Iterator iterator = configurationList.iterator();
        while (iterator.hasNext()) {
            configuration = (Configuration)ScriptBytecodeAdapter.castToType(iterator.next(), Configuration.class);
            if (!configuration.isCanBeResolved()) continue;
            graph.add(DependenciesReport.doBuildDependenciesGraph(configuration, this.getProject(), projectNameFunction));
        }
        this.outputFile.getParentFile().mkdirs();
        String string = new GsonBuilder().create().toJson((Object)graph);
        ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)this.outputFile, (String)"text");
    }

    public static DependencyScopeNode buildDependenciesGraph(Configuration configuration, Project project) {
        return DependenciesReport.doBuildDependenciesGraph(configuration, project, new ProjectNameFunction());
    }

    private static DependencyScopeNode doBuildDependenciesGraph(Configuration configuration, Project project, ProjectNameFunction projectNameFunction) {
        if (!project.getConfigurations().contains(configuration)) {
            throw (Throwable)new IllegalArgumentException("configurations of the project should be used");
        }
        ResolutionResult resolutionResult = configuration.getIncoming().getResolutionResult();
        RenderableModuleResult root = new RenderableModuleResult(resolutionResult.getRoot());
        String configurationName = configuration.getName();
        IdGenerator idGenerator = new IdGenerator();
        long id = idGenerator.getId((RenderableDependency)root, configurationName);
        String scopeDisplayName = StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)"project ", (CharSequence)project.getPath()), (CharSequence)" ("), (CharSequence)configurationName), (CharSequence)")");
        DependencyScopeNode node = new DependencyScopeNode(id, configurationName, scopeDisplayName, configuration.getDescription());
        node.setResolutionState(root.getResolutionState().name());
        Dependency dependency = null;
        Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethod0(DependenciesReport.class, (Object)configuration.getAllDependencies(), (String)"iterator"), Iterator.class);
        while (iterator.hasNext()) {
            dependency = (Dependency)ScriptBytecodeAdapter.castToType(iterator.next(), Dependency.class);
            if (!(dependency instanceof FileCollectionDependency)) continue;
            FileCollection fileCollection = ((FileCollectionDependency)ScriptBytecodeAdapter.castToType((Object)dependency, FileCollectionDependency.class)).getFiles();
            if (fileCollection instanceof Configuration) continue;
            Set files = fileCollection.getFiles();
            if (files.isEmpty()) continue;
            String displayName = null;
            if (fileCollection instanceof Describable) {
                String string;
                displayName = string = ((Describable)ScriptBytecodeAdapter.castToType((Object)fileCollection, Describable.class)).getDisplayName();
            } else {
                String string = fileCollection.toString();
                if (ScriptBytecodeAdapter.compareNotEqual((Object)"file collection", (Object)string)) {
                    String string2;
                    displayName = string2 = string;
                }
            }
            if (displayName != null) {
                long fileDepId = idGenerator.getId(displayName, configurationName);
                node.getDependencies().add(new FileCollectionDependencyNodeImpl(fileDepId, displayName, fileCollection.getAsPath()));
                continue;
            }
            File file = null;
            Iterator iterator2 = files.iterator();
            while (iterator2.hasNext()) {
                file = (File)ScriptBytecodeAdapter.castToType(iterator2.next(), File.class);
                long fileDepId = idGenerator.getId(file.getPath(), configurationName);
                node.getDependencies().add(new FileCollectionDependencyNodeImpl(fileDepId, file.getName(), file.getPath()));
            }
        }
        LinkedHashMap added = (LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]), LinkedHashMap.class);
        RenderableDependency child = null;
        Iterator iterator3 = root.getChildren().iterator();
        while (iterator3.hasNext()) {
            child = (RenderableDependency)ScriptBytecodeAdapter.castToType(iterator3.next(), RenderableDependency.class);
            node.getDependencies().add(DependenciesReport.toNode(child, configurationName, added, idGenerator, projectNameFunction));
        }
        return node;
    }

    private static DependencyNode toNode(RenderableDependency dependency, String configurationName, Map<Object, DependencyNode> added, IdGenerator idGenerator, ProjectNameFunction projectNameFunction) {
        long id = idGenerator.getId(dependency, configurationName);
        DependencyNode alreadySeenNode = (DependencyNode)ScriptBytecodeAdapter.castToType((Object)added.get(id), DependencyNode.class);
        if (alreadySeenNode != null) {
            return new ReferenceNode(id);
        }
        UnknownDependencyNode node = null;
        if (dependency.getId() instanceof ProjectComponentIdentifier) {
            ProjectComponentIdentifier projectId = (ProjectComponentIdentifier)ScriptBytecodeAdapter.asType((Object)dependency.getId(), ProjectComponentIdentifier.class);
            ProjectDependencyNodeImpl projectDependencyNodeImpl = new ProjectDependencyNodeImpl(id, projectNameFunction.fun(projectId));
            node = projectDependencyNodeImpl;
        } else if (dependency.getId() instanceof ModuleComponentIdentifier) {
            ModuleComponentIdentifier moduleId = (ModuleComponentIdentifier)ScriptBytecodeAdapter.asType((Object)dependency.getId(), ModuleComponentIdentifier.class);
            ArtifactDependencyNodeImpl artifactDependencyNodeImpl = new ArtifactDependencyNodeImpl(id, moduleId.getGroup(), moduleId.getModule(), moduleId.getVersion());
            node = artifactDependencyNodeImpl;
        } else {
            UnknownDependencyNode unknownDependencyNode;
            node = unknownDependencyNode = new UnknownDependencyNode(id, dependency.getName());
        }
        node.setResolutionState(dependency.getResolutionState().name());
        added.put(id, (DependencyNode)node);
        Iterator iterator = dependency.getChildren().iterator();
        while (iterator.hasNext()) {
            RenderableDependency child = (RenderableDependency)ScriptBytecodeAdapter.castToType(iterator.next(), RenderableDependency.class);
            node.getDependencies().add(DependenciesReport.toNode(child, configurationName, added, idGenerator, projectNameFunction));
        }
        return node;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != DependenciesReport.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ Object this$dist$invoke$3(String name, Object args) {
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(DependenciesReport.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$3(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, DependenciesReport.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$3(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(DependenciesReport.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public List<String> getConfigurations() {
        return this.configurations;
    }

    public void setConfigurations(List<String> list) {
        this.configurations = list;
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    public void setOutputFile(File file) {
        this.outputFile = file;
    }

    public static class ProjectNameFunction
    implements GroovyObject {
        private Object is45OrNewer;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        public ProjectNameFunction() {
            MetaClass metaClass;
            boolean bl = ScriptBytecodeAdapter.compareGreaterThanEqual((Object)GradleVersion.current(), (Object)GradleVersion.version((String)"4.5"));
            this.is45OrNewer = bl;
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        public String fun(ProjectComponentIdentifier identifier) {
            return DefaultTypeTransformation.booleanUnbox((Object)this.is45OrNewer) ? identifier.getProjectName() : identifier.getProjectPath();
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != ProjectNameFunction.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(ProjectNameFunction.class, DependenciesReport.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(ProjectNameFunction.class, DependenciesReport.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, DependenciesReport.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, DependenciesReport.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(ProjectNameFunction.class, DependenciesReport.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(ProjectNameFunction.class, DependenciesReport.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        public Object getIs45OrNewer() {
            return this.is45OrNewer;
        }

        public void setIs45OrNewer(Object object) {
            this.is45OrNewer = object;
        }
    }

    static class IdGenerator
    implements GroovyObject {
        private Map<String, Long> idMap;
        private long value;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        public IdGenerator() {
            MetaClass metaClass;
            HashMap<String, Long> hashMap = new HashMap<String, Long>();
            this.idMap = hashMap;
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        private long getId(String prefix, String configurationName) {
            String key = StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)prefix, (CharSequence)"_"), (CharSequence)configurationName);
            Long id = (Long)ScriptBytecodeAdapter.castToType((Object)this.idMap.get(key), Long.class);
            if (id == null) {
                long l = ++this.value;
                DefaultGroovyMethods.putAt(this.idMap, (Object)key, (Object)l);
                long l2 = this.value;
                id = l2;
            }
            return id;
        }

        private long getId(RenderableDependency dependency, String configurationName) {
            return this.getId(DefaultGroovyMethods.toString((Object)dependency.getId()), configurationName);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != IdGenerator.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(IdGenerator.class, DependenciesReport.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(IdGenerator.class, DependenciesReport.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, DependenciesReport.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, DependenciesReport.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(IdGenerator.class, DependenciesReport.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(IdGenerator.class, DependenciesReport.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }
    }
}

