/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.tooling.internal.ear;

import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.model.ear.EarConfiguration;

public class EarResourceImpl
implements EarConfiguration.EarResource {
    @NotNull
    private final String myEarDirectory;
    @NotNull
    private final String myRelativePath;
    @NotNull
    private final File file;

    public EarResourceImpl(@NotNull String earDirectory, @NotNull String relativePath, @NotNull File file) {
        this.myEarDirectory = earDirectory;
        this.myRelativePath = relativePath;
        this.file = file;
    }

    @NotNull
    public String getEarDirectory() {
        return this.myEarDirectory;
    }

    @NotNull
    public String getRelativePath() {
        return this.myRelativePath;
    }

    @NotNull
    public File getFile() {
        return this.file;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EarResourceImpl)) {
            return false;
        }
        EarResourceImpl resource = (EarResourceImpl)o;
        if (!this.file.getPath().equals(resource.file.getPath())) {
            return false;
        }
        if (this.myEarDirectory != resource.myEarDirectory) {
            return false;
        }
        return this.myRelativePath.equals(resource.myRelativePath);
    }

    public int hashCode() {
        int result = this.myEarDirectory.hashCode();
        result = 31 * result + this.myRelativePath.hashCode();
        result = 31 * result + this.file.getPath().hashCode();
        return result;
    }

    public String toString() {
        return "EarResource{earDirectory=" + this.myEarDirectory + ", warRelativePath='" + this.myRelativePath + '\'' + ", file=" + this.file + '}';
    }
}

