/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.tooling.builder;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.plugins.ide.idea.IdeaPlugin;
import org.gradle.plugins.ide.idea.model.IdeaModule;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.BuildScriptClasspathModel;
import org.jetbrains.plugins.gradle.model.ClasspathEntryModel;
import org.jetbrains.plugins.gradle.model.ExternalDependency;
import org.jetbrains.plugins.gradle.model.ExternalLibraryDependency;
import org.jetbrains.plugins.gradle.model.ExternalMultiLibraryDependency;
import org.jetbrains.plugins.gradle.model.ExternalProjectDependency;
import org.jetbrains.plugins.gradle.model.FileCollectionDependency;
import org.jetbrains.plugins.gradle.tooling.AbstractModelBuilderService;
import org.jetbrains.plugins.gradle.tooling.ErrorMessageBuilder;
import org.jetbrains.plugins.gradle.tooling.ModelBuilderContext;
import org.jetbrains.plugins.gradle.tooling.internal.BuildScriptClasspathModelImpl;
import org.jetbrains.plugins.gradle.tooling.internal.ClasspathEntryModelImpl;
import org.jetbrains.plugins.gradle.tooling.util.DependencyTraverser;
import org.jetbrains.plugins.gradle.tooling.util.SourceSetCachedFinder;
import org.jetbrains.plugins.gradle.tooling.util.resolve.DependencyResolverImpl;

public class ModelBuildScriptClasspathBuilderImpl
extends AbstractModelBuilderService {
    private static final String CLASSPATH_CONFIGURATION_NAME = "classpath";
    private final Map<String, BuildScriptClasspathModelImpl> cache = new ConcurrentHashMap<String, BuildScriptClasspathModelImpl>();
    private SourceSetCachedFinder mySourceSetFinder = null;

    public boolean canBuild(String modelName) {
        return BuildScriptClasspathModel.class.getName().equals(modelName);
    }

    @Nullable
    public Object buildAll(@NotNull String modelName, @NotNull Project project, @NotNull ModelBuilderContext context) {
        Configuration classpathConfiguration;
        BuildScriptClasspathModelImpl parentBuildScriptClasspath;
        Project parent;
        BuildScriptClasspathModelImpl buildScriptClasspath = this.cache.get(project.getPath());
        if (buildScriptClasspath != null) {
            return buildScriptClasspath;
        }
        if (this.mySourceSetFinder == null) {
            this.mySourceSetFinder = new SourceSetCachedFinder(context);
        }
        buildScriptClasspath = new BuildScriptClasspathModelImpl();
        File gradleHomeDir = project.getGradle().getGradleHomeDir();
        buildScriptClasspath.setGradleHomeDir(gradleHomeDir);
        buildScriptClasspath.setGradleVersion(GradleVersion.current().getVersion());
        boolean downloadJavadoc = false;
        boolean downloadSources = true;
        IdeaPlugin ideaPlugin = (IdeaPlugin)project.getPlugins().findPlugin(IdeaPlugin.class);
        if (ideaPlugin != null) {
            IdeaModule ideaModule = ideaPlugin.getModel().getModule();
            downloadJavadoc = ideaModule.isDownloadJavadoc();
            downloadSources = ideaModule.isDownloadSources();
        }
        if ((parent = project.getParent()) != null && (parentBuildScriptClasspath = (BuildScriptClasspathModelImpl)this.buildAll(modelName, parent, context)) != null) {
            for (ClasspathEntryModel classpathEntryModel : parentBuildScriptClasspath.getClasspath()) {
                buildScriptClasspath.add(classpathEntryModel);
            }
        }
        if ((classpathConfiguration = (Configuration)project.getBuildscript().getConfigurations().findByName(CLASSPATH_CONFIGURATION_NAME)) == null) {
            return null;
        }
        Collection<ExternalDependency> dependencies = new DependencyResolverImpl(project, downloadJavadoc, downloadSources, this.mySourceSetFinder).resolveDependencies(classpathConfiguration);
        for (ExternalDependency dependency : new DependencyTraverser(dependencies)) {
            if (dependency instanceof ExternalProjectDependency) {
                ExternalProjectDependency projectDependency = (ExternalProjectDependency)dependency;
                Collection projectDependencyArtifacts = projectDependency.getProjectDependencyArtifacts();
                Collection projectDependencyArtifactsSources = projectDependency.getProjectDependencyArtifactsSources();
                buildScriptClasspath.add(new ClasspathEntryModelImpl(ModelBuildScriptClasspathBuilderImpl.pathSet(projectDependencyArtifacts), ModelBuildScriptClasspathBuilderImpl.pathSet(projectDependencyArtifactsSources), Collections.<String>emptySet()));
                continue;
            }
            if (dependency instanceof ExternalLibraryDependency) {
                ExternalLibraryDependency libraryDep = (ExternalLibraryDependency)dependency;
                buildScriptClasspath.add(new ClasspathEntryModelImpl(ModelBuildScriptClasspathBuilderImpl.pathSet(libraryDep.getFile()), ModelBuildScriptClasspathBuilderImpl.pathSet(libraryDep.getSource()), ModelBuildScriptClasspathBuilderImpl.pathSet(libraryDep.getJavadoc())));
                continue;
            }
            if (dependency instanceof ExternalMultiLibraryDependency) {
                ExternalMultiLibraryDependency multiLibraryDependency = (ExternalMultiLibraryDependency)dependency;
                buildScriptClasspath.add(new ClasspathEntryModelImpl(ModelBuildScriptClasspathBuilderImpl.pathSet(multiLibraryDependency.getFiles()), ModelBuildScriptClasspathBuilderImpl.pathSet(multiLibraryDependency.getSources()), ModelBuildScriptClasspathBuilderImpl.pathSet(multiLibraryDependency.getJavadoc())));
                continue;
            }
            if (!(dependency instanceof FileCollectionDependency)) continue;
            FileCollectionDependency fileCollectionDependency = (FileCollectionDependency)dependency;
            buildScriptClasspath.add(new ClasspathEntryModelImpl(ModelBuildScriptClasspathBuilderImpl.pathSet(fileCollectionDependency.getFiles()), Collections.<String>emptySet(), Collections.<String>emptySet()));
        }
        this.cache.put(project.getPath(), buildScriptClasspath);
        return buildScriptClasspath;
    }

    @NotNull
    public ErrorMessageBuilder getErrorMessageBuilder(@NotNull Project project, @NotNull Exception e) {
        return ErrorMessageBuilder.create((Project)project, (Exception)e, (String)"Project build classpath resolve errors").withDescription("Unable to resolve additional buildscript classpath dependencies");
    }

    private static Set<String> pathSet(Collection<File> files) {
        if (files.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> set = new HashSet<String>(files.size());
        for (File file : files) {
            if (file == null) continue;
            set.add(file.getPath());
        }
        if (set.isEmpty()) {
            return Collections.emptySet();
        }
        if (set.size() == 1) {
            return Collections.singleton(set.iterator().next());
        }
        return set;
    }

    private static Set<String> pathSet(File ... files) {
        return ModelBuildScriptClasspathBuilderImpl.pathSet(Arrays.asList(files));
    }
}

