/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.model;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.DefaultExternalSourceSet;
import org.jetbrains.plugins.gradle.model.DefaultExternalTask;
import org.jetbrains.plugins.gradle.model.ExternalProject;
import org.jetbrains.plugins.gradle.model.ExternalProjectPreview;
import org.jetbrains.plugins.gradle.model.ExternalSourceSet;
import org.jetbrains.plugins.gradle.model.ExternalTask;

public final class DefaultExternalProject
implements ExternalProject,
ExternalProjectPreview {
    @NotNull
    private String id;
    @NotNull
    private String name;
    @NotNull
    private String qName;
    @Nullable
    private String description;
    @NotNull
    private String group;
    @NotNull
    private String version;
    @Nullable
    private String sourceCompatibility;
    @Nullable
    private String targetCompatibility;
    @NotNull
    private TreeMap<String, DefaultExternalProject> childProjects;
    @NotNull
    private File projectDir;
    @NotNull
    private File buildDir;
    @Nullable
    private File buildFile;
    @NotNull
    private Map<String, DefaultExternalTask> tasks;
    @NotNull
    private Map<String, DefaultExternalSourceSet> sourceSets;
    @NotNull
    private String externalSystemId;
    @NotNull
    private List<File> artifacts;
    @NotNull
    private Map<String, Set<File>> artifactsByConfiguration;

    public DefaultExternalProject() {
        this.childProjects = new TreeMap();
        this.tasks = new HashMap<String, DefaultExternalTask>(0);
        this.sourceSets = new HashMap<String, DefaultExternalSourceSet>(0);
        this.artifacts = new ArrayList<File>(0);
        this.artifactsByConfiguration = new HashMap<String, Set<File>>(0);
    }

    public DefaultExternalProject(@NotNull ExternalProject externalProject) {
        this.id = externalProject.getId();
        this.name = externalProject.getName();
        this.qName = externalProject.getQName();
        this.version = externalProject.getVersion();
        this.group = externalProject.getGroup();
        this.sourceCompatibility = externalProject.getSourceCompatibility();
        this.targetCompatibility = externalProject.getTargetCompatibility();
        this.description = externalProject.getDescription();
        this.projectDir = externalProject.getProjectDir();
        this.buildDir = externalProject.getBuildDir();
        this.buildFile = externalProject.getBuildFile();
        this.externalSystemId = externalProject.getExternalSystemId();
        Map externalProjectChildProjects = externalProject.getChildProjects();
        this.childProjects = new TreeMap();
        for (Map.Entry entry : externalProjectChildProjects.entrySet()) {
            this.childProjects.put((String)entry.getKey(), new DefaultExternalProject((ExternalProject)entry.getValue()));
        }
        Map externalProjectTasks = externalProject.getTasks();
        this.tasks = new HashMap<String, DefaultExternalTask>(externalProjectTasks.size());
        for (Map.Entry entry : externalProjectTasks.entrySet()) {
            this.tasks.put((String)entry.getKey(), new DefaultExternalTask((ExternalTask)entry.getValue()));
        }
        Map map = externalProject.getSourceSets();
        this.sourceSets = new HashMap<String, DefaultExternalSourceSet>(map.size());
        for (Map.Entry entry : map.entrySet()) {
            this.sourceSets.put((String)entry.getKey(), new DefaultExternalSourceSet((ExternalSourceSet)entry.getValue()));
        }
        this.artifacts = new ArrayList<File>(externalProject.getArtifacts());
        this.artifactsByConfiguration = new HashMap<String, Set<File>>(externalProject.getArtifactsByConfiguration());
    }

    @NotNull
    public String getExternalSystemId() {
        return this.externalSystemId;
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    public void setId(@NotNull String id) {
        this.id = id;
    }

    public void setExternalSystemId(@NotNull String externalSystemId) {
        this.externalSystemId = externalSystemId;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(@NotNull String name) {
        this.name = name;
    }

    @NotNull
    public String getQName() {
        return this.qName;
    }

    public void setQName(@NotNull String QName) {
        this.qName = QName;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(@Nullable String description) {
        this.description = description;
    }

    @NotNull
    public String getGroup() {
        return this.group;
    }

    public void setGroup(@NotNull String group) {
        this.group = group;
    }

    @NotNull
    public String getVersion() {
        return this.version;
    }

    public void setVersion(@NotNull String version) {
        this.version = version;
    }

    @Nullable
    public String getSourceCompatibility() {
        return this.sourceCompatibility;
    }

    public void setSourceCompatibility(@Nullable String sourceCompatibility) {
        this.sourceCompatibility = sourceCompatibility;
    }

    @Nullable
    public String getTargetCompatibility() {
        return this.targetCompatibility;
    }

    public void setTargetCompatibility(@Nullable String targetCompatibility) {
        this.targetCompatibility = targetCompatibility;
    }

    @NotNull
    public Map<String, DefaultExternalProject> getChildProjects() {
        return this.childProjects;
    }

    public void setChildProjects(@NotNull Map<String, DefaultExternalProject> childProjects) {
        this.childProjects = childProjects instanceof TreeMap ? (TreeMap<Object, Object>)childProjects : new TreeMap<String, DefaultExternalProject>(childProjects);
    }

    @NotNull
    public File getProjectDir() {
        return this.projectDir;
    }

    public void setProjectDir(@NotNull File projectDir) {
        this.projectDir = projectDir;
    }

    @NotNull
    public File getBuildDir() {
        return this.buildDir;
    }

    public void setBuildDir(@NotNull File buildDir) {
        this.buildDir = buildDir;
    }

    @Nullable
    public File getBuildFile() {
        return this.buildFile;
    }

    public void setBuildFile(@Nullable File buildFile) {
        this.buildFile = buildFile;
    }

    @NotNull
    public Map<String, ? extends ExternalTask> getTasks() {
        return this.tasks;
    }

    public void setTasks(@NotNull Map<String, DefaultExternalTask> tasks) {
        this.tasks = tasks;
    }

    @NotNull
    public Map<String, DefaultExternalSourceSet> getSourceSets() {
        return this.sourceSets;
    }

    public void setSourceSets(@NotNull Map<String, DefaultExternalSourceSet> sourceSets) {
        this.sourceSets = sourceSets;
    }

    @NotNull
    public List<File> getArtifacts() {
        return this.artifacts;
    }

    public void setArtifacts(@NotNull List<File> artifacts) {
        this.artifacts = artifacts;
    }

    public void setArtifactsByConfiguration(@NotNull Map<String, Set<File>> artifactsByConfiguration) {
        this.artifactsByConfiguration = artifactsByConfiguration;
    }

    @NotNull
    public Map<String, Set<File>> getArtifactsByConfiguration() {
        return this.artifactsByConfiguration;
    }

    public String toString() {
        return "project '" + this.id + "'";
    }
}

