/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.inline;

import com.intellij.java.i18n.JavaI18nBundle;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.references.PropertyReference;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.inline.JavaInlineActionHandler;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.refactoring.listeners.RefactoringEventListener;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.RefactoringMessageDialog;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class InlinePropertyHandler
extends JavaInlineActionHandler {
    public static final String REFACTORING_ID = "refactoring.inline.property";

    public boolean canInlineElement(PsiElement element) {
        if (PsiUtil.isJavaToken((PsiElement)element, (IElementType)JavaTokenType.STRING_LITERAL)) {
            Object[] references = element.getParent().getReferences();
            return ContainerUtil.findInstance((Object[])references, PropertyReference.class) != null;
        }
        return element instanceof IProperty;
    }

    public void inlineElement(Project project, Editor editor, PsiElement psiElement) {
        if (!(psiElement instanceof IProperty)) {
            return;
        }
        IProperty property = (IProperty)psiElement;
        String propertyValue = property.getValue();
        if (propertyValue == null) {
            return;
        }
        List occurrences = Collections.synchronizedList(new ArrayList());
        Set<PsiFile> containingFiles = Collections.synchronizedSet(new HashSet());
        containingFiles.add(psiElement.getContainingFile());
        boolean result = ReferencesSearch.search((PsiElement)psiElement).forEach(psiReference -> {
            PsiElement element = psiReference.getElement();
            PsiElement parent = element.getParent();
            if (parent instanceof PsiExpressionList && parent.getParent() instanceof PsiMethodCallExpression && ((PsiExpressionList)parent).getExpressionCount() == 1) {
                occurrences.add(parent.getParent());
                containingFiles.add(element.getContainingFile());
                return true;
            }
            return false;
        });
        if (!result) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)JavaI18nBundle.message("error.hint.property.has.non.method.usages", new Object[0]), (String)InlinePropertyHandler.getRefactoringName(), null);
        }
        if (occurrences.isEmpty()) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)JavaI18nBundle.message("error.hint.property.has.no.usages", new Object[0]), (String)InlinePropertyHandler.getRefactoringName(), null);
            return;
        }
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            String occurrencesString = RefactoringBundle.message((String)"occurrences.string", (Object[])new Object[]{occurrences.size()});
            String question = JavaI18nBundle.message("inline.property.confirmation", property.getName(), propertyValue) + " " + occurrencesString;
            RefactoringMessageDialog dialog = new RefactoringMessageDialog(InlinePropertyHandler.getRefactoringName(), question, "refactoring.inlineVariable", "OptionPane.questionIcon", true, project);
            if (!dialog.showAndGet()) {
                return;
            }
        }
        RefactoringEventData data = new RefactoringEventData();
        data.addElement(psiElement.copy());
        WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])containingFiles.toArray(PsiFile.EMPTY_ARRAY)).withName(InlinePropertyHandler.getRefactoringName()).run(() -> {
            ((RefactoringEventListener)project.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringStarted(REFACTORING_ID, data);
            PsiLiteral stringLiteral = (PsiLiteral)JavaPsiFacade.getInstance((Project)project).getElementFactory().createExpressionFromText("\"" + StringUtil.escapeStringCharacters((String)propertyValue) + "\"", null);
            for (PsiElement occurrence : occurrences) {
                occurrence.replace(stringLiteral.copy());
            }
            ((RefactoringEventListener)project.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringDone(REFACTORING_ID, null);
        });
    }

    @Nullable
    public String getActionName(PsiElement element) {
        return InlinePropertyHandler.getRefactoringName();
    }

    public static String getRefactoringName() {
        return JavaI18nBundle.message("inline.property.refactoring", new Object[0]);
    }
}

