/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.i18n.inconsistentResourceBundle;

import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.i18n.inconsistentResourceBundle.InconsistentResourceBundleInspectionProvider;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.java.i18n.JavaI18nBundle;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.BidirectionalMap;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class PropertiesKeysConsistencyInspectionProvider
implements InconsistentResourceBundleInspectionProvider {
    @Override
    @NotNull
    public String getName() {
        return "REPORT_INCONSISTENT_PROPERTIES";
    }

    @Override
    @NotNull
    public String getPresentableName() {
        return JavaI18nBundle.message("inconsistent.bundle.report.inconsistent.properties", new Object[0]);
    }

    @Override
    public void check(BidirectionalMap<PropertiesFile, PropertiesFile> parents, List<? extends PropertiesFile> files, Map<PropertiesFile, Set<String>> keysUpToParent, Map<PropertiesFile, Map<String, String>> propertiesFilesNamesMaps, InspectionManager manager, RefManager refManager, ProblemDescriptionsProcessor processor) {
        for (PropertiesFile propertiesFile : files) {
            PropertiesFile parent = (PropertiesFile)parents.get((Object)propertiesFile);
            THashSet parentKeys = keysUpToParent.get(parent);
            if (parent == null) {
                parentKeys = new THashSet();
                for (PropertiesFile propertiesFile2 : files) {
                    if (propertiesFile2 == propertiesFile || parents.get((Object)propertiesFile2) != null) continue;
                    parent = propertiesFile2;
                    parentKeys.addAll(propertiesFilesNamesMaps.get(propertiesFile2).keySet());
                }
                if (parent == null) continue;
            }
            THashSet keys = new THashSet(propertiesFilesNamesMaps.get(propertiesFile).keySet());
            keys.removeAll((Collection<?>)parentKeys);
            for (String inconsistentKey : keys) {
                IProperty property = propertiesFile.findPropertyByKey(inconsistentKey);
                if (property == null) continue;
                String message = JavaI18nBundle.message("inconsistent.bundle.property.error", inconsistentKey, parent.getName());
                ProblemDescriptor descriptor = manager.createProblemDescriptor(property.getPsiElement(), message, false, LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
                processor.addProblemElement((RefEntity)refManager.getReference((PsiElement)propertiesFile.getContainingFile()), new CommonProblemDescriptor[]{descriptor});
            }
        }
    }
}

