/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactoryRegistrar;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.DuplicateJvmSignatureUtilKt;
import org.jetbrains.kotlin.idea.caches.project.GetModuleInfoKt;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.highlighter.AbstractBindingContextAwareHighlightingPassBase;
import org.jetbrains.kotlin.idea.highlighter.AbstractKotlinHighlightingPass;
import org.jetbrains.kotlin.idea.project.TargetPlatformDetector;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacade;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtil;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.jvm.JvmPlatformKt;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationContainer;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0003\u000b\f\rB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/DuplicateJvmSignatureHighlightPass;", "Lorg/jetbrains/kotlin/idea/highlighter/AbstractBindingContextAwareHighlightingPassBase;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "document", "Lcom/intellij/openapi/editor/Document;", "(Lorg/jetbrains/kotlin/psi/KtFile;Lcom/intellij/openapi/editor/Document;)V", "annotator", "Lcom/intellij/lang/annotation/Annotator;", "getAnnotator", "()Lcom/intellij/lang/annotation/Annotator;", "DuplicateJvmSignatureAnnotator", "Factory", "Registrar", "kotlin.core"})
public final class DuplicateJvmSignatureHighlightPass
extends AbstractBindingContextAwareHighlightingPassBase {
    @Override
    @NotNull
    protected Annotator getAnnotator() {
        return new DuplicateJvmSignatureAnnotator();
    }

    public DuplicateJvmSignatureHighlightPass(@NotNull KtFile file, @NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        super(file, document);
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/DuplicateJvmSignatureHighlightPass$DuplicateJvmSignatureAnnotator;", "Lcom/intellij/lang/annotation/Annotator;", "(Lorg/jetbrains/kotlin/idea/highlighter/DuplicateJvmSignatureHighlightPass;)V", "annotate", "", "element", "Lcom/intellij/psi/PsiElement;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "kotlin.core"})
    public final class DuplicateJvmSignatureAnnotator
    implements Annotator {
        /*
         * WARNING - void declaration
         */
        public void annotate(@NotNull PsiElement element2, @NotNull AnnotationHolder holder) {
            BindingContext bindingContext;
            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            if (!(element2 instanceof KtFile) && !(element2 instanceof KtDeclaration)) {
                return;
            }
            PsiElement psiElement = element2;
            if (psiElement instanceof KtDeclaration) {
                bindingContext = ResolutionUtils.analyzeWithContent((KtDeclaration)((KtDeclaration)element2));
            } else if (psiElement instanceof KtFile) {
                void $this$analyzeWithContent$iv$iv;
                KtDeclarationContainer $this$analyzeWithContent$iv = (KtDeclarationContainer)element2;
                boolean $i$f$analyzeWithContent = false;
                KtDeclarationContainer ktDeclarationContainer = $this$analyzeWithContent$iv;
                ResolutionFacade resolutionFacade$iv$iv = ResolutionUtils.getResolutionFacade((KtElement)((KtElement)$this$analyzeWithContent$iv));
                boolean $i$f$analyzeWithContent2 = false;
                bindingContext = ResolutionFacade.DefaultImpls.analyzeWithAllCompilerChecks$default((ResolutionFacade)resolutionFacade$iv$iv, (Collection)CollectionsKt.listOf((Object)$this$analyzeWithContent$iv$iv), null, (int)2, null).getBindingContext();
            } else {
                throw (Throwable)((Object)new AssertionError((Object)("DuplicateJvmSignatureAnnotator: should not get here! Element: " + element2.getText())));
            }
            Diagnostics diagnostics2 = bindingContext.getDiagnostics();
            Intrinsics.checkNotNullExpressionValue((Object)diagnostics2, (String)"when (element) {\n       \u2026            }.diagnostics");
            Diagnostics otherDiagnostics = diagnostics2;
            GlobalSearchScope moduleScope = GetModuleInfoKt.getModuleInfo(element2).contentScope();
            Diagnostics diagnostics3 = DuplicateJvmSignatureUtilKt.getJvmSignatureDiagnostics((PsiElement)element2, (Diagnostics)otherDiagnostics, (GlobalSearchScope)moduleScope);
            if (diagnostics3 == null) {
                return;
            }
            Diagnostics diagnostics4 = diagnostics3;
            Set diagnosticsForElement = CollectionsKt.toSet((Iterable)diagnostics4.forElement(element2));
            AbstractKotlinHighlightingPass.Companion.annotateDiagnostics$default(AbstractKotlinHighlightingPass.Companion, DuplicateJvmSignatureHighlightPass.this.getFile(), element2, holder, diagnosticsForElement, null, null, null, false, false, 496, null);
        }
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/DuplicateJvmSignatureHighlightPass$Factory;", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPassFactory;", "()V", "createHighlightingPass", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPass;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "kotlin.core"})
    public static final class Factory
    implements TextEditorHighlightingPassFactory {
        @Nullable
        public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file, @NotNull Editor editor) {
            TextEditorHighlightingPass textEditorHighlightingPass;
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            if (file instanceof KtFile && ProjectRootsUtil.isInProjectSource$default((PsiElement)file, false, 2, null) && JvmPlatformKt.isJvm((TargetPlatform)TargetPlatformDetector.getPlatform((KtFile)file))) {
                KtFile ktFile = (KtFile)file;
                Document document = editor.getDocument();
                Intrinsics.checkNotNullExpressionValue((Object)document, (String)"editor.document");
                textEditorHighlightingPass = (TextEditorHighlightingPass)new DuplicateJvmSignatureHighlightPass(ktFile, document);
            } else {
                textEditorHighlightingPass = null;
            }
            return textEditorHighlightingPass;
        }
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/DuplicateJvmSignatureHighlightPass$Registrar;", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPassFactoryRegistrar;", "()V", "registerHighlightingPassFactory", "", "registrar", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPassRegistrar;", "project", "Lcom/intellij/openapi/project/Project;", "kotlin.core"})
    public static final class Registrar
    implements TextEditorHighlightingPassFactoryRegistrar {
        public void registerHighlightingPassFactory(@NotNull TextEditorHighlightingPassRegistrar registrar, @NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)registrar, (String)"registrar");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            registrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)new Factory(), new int[]{4}, null, false, -1);
        }
    }
}

