/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.codeInsight.intention.EmptyIntentionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationBuilder;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.annotation.ProblemGroup;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.containers.MultiMap;
import com.intellij.xml.util.XmlStringUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.jetbrains.kotlin.diagnostics.UnboundDiagnostic;
import org.jetbrains.kotlin.diagnostics.rendering.DefaultErrorMessages;
import org.jetbrains.kotlin.idea.highlighter.AnnotationPresentationInfo$WhenMappings;
import org.jetbrains.kotlin.idea.highlighter.CalculatingIntentionAction;
import org.jetbrains.kotlin.idea.highlighter.IdeErrorMessages;
import org.jetbrains.kotlin.idea.highlighter.KotlinSuppressableWarningProblemGroup;
import org.jetbrains.kotlin.idea.inspections.KotlinUniversalQuickFix;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B7\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ1\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u00172\u0006\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\b\u001dJ4\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020\u00042\u0006\u0010 \u001a\u00020!2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u00150#H\u0002J\u0010\u0010$\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u0018H\u0002J\u0010\u0010%\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u0018H\u0002Jh\u0010&\u001a\u00020\u00152\u0006\u0010 \u001a\u00020!2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00180(2\u0016\b\u0002\u0010)\u001a\u0010\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u001c\u0018\u00010*2\u0014\u0010+\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u001c\u0018\u00010*2\u0014\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u00172\u0006\u0010,\u001a\u00020-R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006."}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/AnnotationPresentationInfo;", "", "ranges", "", "Lcom/intellij/openapi/util/TextRange;", "nonDefaultMessage", "", "highlightType", "Lcom/intellij/codeInspection/ProblemHighlightType;", "textAttributes", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "(Ljava/util/List;Ljava/lang/String;Lcom/intellij/codeInspection/ProblemHighlightType;Lcom/intellij/openapi/editor/colors/TextAttributesKey;)V", "getHighlightType", "()Lcom/intellij/codeInspection/ProblemHighlightType;", "getNonDefaultMessage", "()Ljava/lang/String;", "getRanges", "()Ljava/util/List;", "getTextAttributes", "()Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "applyFixes", "", "fixesMap", "Lcom/intellij/util/containers/MultiMap;", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "annotation", "Lcom/intellij/lang/annotation/Annotation;", "applyFixes$kotlin_core", "create", "range", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "consumer", "Lkotlin/Function1;", "getDefaultMessage", "getMessage", "processDiagnostics", "diagnostics", "", "annotationBuilderByDiagnostic", "", "annotationByTextRange", "calculatingInProgress", "", "kotlin.core"})
public final class AnnotationPresentationInfo {
    @NotNull
    private final List<TextRange> ranges;
    @Nullable
    private final String nonDefaultMessage;
    @Nullable
    private final ProblemHighlightType highlightType;
    @Nullable
    private final TextAttributesKey textAttributes;

    public final void processDiagnostics(@NotNull AnnotationHolder holder, @NotNull Collection<? extends Diagnostic> diagnostics2, @Nullable Map<Diagnostic, Annotation> annotationBuilderByDiagnostic, @Nullable Map<TextRange, Annotation> annotationByTextRange, @Nullable MultiMap<Diagnostic, IntentionAction> fixesMap, boolean calculatingInProgress) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter(diagnostics2, (String)"diagnostics");
        for (TextRange range : this.ranges) {
            for (Diagnostic diagnostic : diagnostics2) {
                this.create(diagnostic, range, holder, (Function1<? super Annotation, Unit>)((Function1)new Function1<Annotation, Unit>(this, annotationBuilderByDiagnostic, diagnostic, fixesMap, calculatingInProgress, annotationByTextRange, range){
                    final /* synthetic */ AnnotationPresentationInfo this$0;
                    final /* synthetic */ Map $annotationBuilderByDiagnostic;
                    final /* synthetic */ Diagnostic $diagnostic;
                    final /* synthetic */ MultiMap $fixesMap;
                    final /* synthetic */ boolean $calculatingInProgress;
                    final /* synthetic */ Map $annotationByTextRange;
                    final /* synthetic */ TextRange $range;

                    public final void invoke(@NotNull Annotation annotation) {
                        Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
                        Map map2 = this.$annotationBuilderByDiagnostic;
                        if (map2 != null) {
                            map2.put(this.$diagnostic, annotation);
                        }
                        if (this.$fixesMap != null) {
                            this.this$0.applyFixes$kotlin_core((MultiMap<Diagnostic, IntentionAction>)this.$fixesMap, this.$diagnostic, annotation);
                        }
                        if (this.$calculatingInProgress) {
                            Map map3 = this.$annotationByTextRange;
                            if (map3 != null) {
                                if (!map3.containsKey(this.$range)) {
                                    this.$annotationByTextRange.put(this.$range, annotation);
                                    annotation.registerFix((IntentionAction)new CalculatingIntentionAction(), this.$range);
                                }
                            }
                        }
                    }
                    {
                        this.this$0 = annotationPresentationInfo;
                        this.$annotationBuilderByDiagnostic = map2;
                        this.$diagnostic = diagnostic;
                        this.$fixesMap = multiMap;
                        this.$calculatingInProgress = bl;
                        this.$annotationByTextRange = map3;
                        this.$range = textRange;
                        super(1);
                    }
                }));
            }
        }
    }

    public static /* synthetic */ void processDiagnostics$default(AnnotationPresentationInfo annotationPresentationInfo, AnnotationHolder annotationHolder, Collection collection, Map map2, Map map3, MultiMap multiMap, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            map2 = null;
        }
        annotationPresentationInfo.processDiagnostics(annotationHolder, collection, map2, map3, (MultiMap<Diagnostic, IntentionAction>)multiMap, bl);
    }

    public final void applyFixes$kotlin_core(@NotNull MultiMap<Diagnostic, IntentionAction> fixesMap, @NotNull Diagnostic diagnostic, @NotNull Annotation annotation) {
        Intrinsics.checkNotNullParameter(fixesMap, (String)"fixesMap");
        Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
        Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
        Collection collection = fixesMap.get((Object)diagnostic);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"fixesMap[diagnostic]");
        Collection fixes = collection;
        TextRange textRange = new TextRange(annotation.getStartOffset(), annotation.getEndOffset());
        Iterable $this$forEach$iv = fixes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IntentionAction it = (IntentionAction)element$iv;
            boolean bl = false;
            IntentionAction intentionAction = it;
            if (intentionAction instanceof KotlinUniversalQuickFix) {
                annotation.registerBatchFix(it, textRange, null);
                annotation.registerFix(it, textRange);
                continue;
            }
            if (!(intentionAction instanceof IntentionAction)) continue;
            annotation.registerFix(it, textRange);
        }
        if (diagnostic.getSeverity() == Severity.WARNING && fixes.isEmpty()) {
            annotation.registerFix((IntentionAction)new EmptyIntentionAction(diagnostic.getFactory().getName()), textRange);
        }
    }

    private final void create(Diagnostic diagnostic, TextRange range, AnnotationHolder holder, Function1<? super Annotation, Unit> consumer) {
        block11: {
            List list;
            ProblemHighlightType it;
            boolean bl;
            boolean bl2;
            ProblemHighlightType problemHighlightType;
            HighlightSeverity highlightSeverity;
            switch (AnnotationPresentationInfo$WhenMappings.$EnumSwitchMapping$0[diagnostic.getSeverity().ordinal()]) {
                case 1: {
                    highlightSeverity = HighlightSeverity.ERROR;
                    break;
                }
                case 2: {
                    if (this.highlightType == ProblemHighlightType.WEAK_WARNING) {
                        highlightSeverity = HighlightSeverity.WEAK_WARNING;
                        break;
                    }
                    highlightSeverity = HighlightSeverity.WARNING;
                    break;
                }
                case 3: {
                    highlightSeverity = HighlightSeverity.WEAK_WARNING;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            HighlightSeverity severity = highlightSeverity;
            String string = this.nonDefaultMessage;
            if (string == null) {
                string = this.getDefaultMessage(diagnostic);
            }
            String message = string;
            Object object = holder.newAnnotation(severity, message).range(range).tooltip(this.getMessage(diagnostic));
            boolean bl3 = false;
            boolean bl4 = false;
            AnnotationBuilder builder = object;
            boolean bl5 = false;
            ProblemHighlightType problemHighlightType2 = this.highlightType;
            if (problemHighlightType2 != null) {
                problemHighlightType = problemHighlightType2;
                bl2 = false;
                bl = false;
                it = problemHighlightType;
                boolean bl6 = false;
                builder.highlightType(it);
            }
            bl3 = false;
            bl4 = false;
            builder = object;
            boolean bl7 = false;
            TextAttributesKey textAttributesKey = this.textAttributes;
            if (textAttributesKey != null) {
                problemHighlightType = textAttributesKey;
                bl2 = false;
                bl = false;
                it = problemHighlightType;
                boolean bl8 = false;
                builder.textAttributes((TextAttributesKey)it);
            }
            bl3 = false;
            bl4 = false;
            AnnotationBuilder it2 = object;
            boolean bl9 = false;
            if (diagnostic.getSeverity() == Severity.WARNING) {
                it2.problemGroup((ProblemGroup)new KotlinSuppressableWarningProblemGroup(diagnostic.getFactory()));
            }
            object.create();
            AnnotationHolder annotationHolder = holder;
            if (!(annotationHolder instanceof List)) {
                annotationHolder = null;
            }
            if ((list = (List)annotationHolder) == null || (list = (Annotation)CollectionsKt.last((List)list)) == null) break block11;
            object = list;
            bl3 = false;
            bl4 = false;
            Object p1 = object;
            boolean bl10 = false;
            consumer.invoke(p1);
        }
    }

    private final String getMessage(Diagnostic diagnostic) {
        String message;
        block8: {
            String string;
            block7: {
                String string2 = IdeErrorMessages.render((UnboundDiagnostic)diagnostic);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"IdeErrorMessages.render(diagnostic)");
                message = string2;
                boolean $i$f$isApplicationInternalMode = false;
                Application application = ApplicationManager.getApplication();
                Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
                if (application.isInternal()) break block7;
                boolean $i$f$isUnitTestMode = false;
                Application application2 = ApplicationManager.getApplication();
                Intrinsics.checkNotNullExpressionValue((Object)application2, (String)"ApplicationManager.getApplication()");
                if (!application2.isUnitTestMode()) break block8;
            }
            String factoryName = diagnostic.getFactory().getName();
            if (StringsKt.startsWith$default((String)message, (String)"<html>", (boolean)false, (int)2, null)) {
                StringBuilder stringBuilder = new StringBuilder().append("<html>[").append(factoryName).append("] ");
                String string3 = message;
                int n = "<html>".length();
                boolean bl = false;
                String string4 = string3;
                if (string4 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string5 = string4.substring(n);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
                string = stringBuilder.append(string5).toString();
            } else {
                string = message = '[' + factoryName + "] " + message;
            }
        }
        if (!StringsKt.startsWith$default((String)message, (String)"<html>", (boolean)false, (int)2, null)) {
            message = "<html><body>" + XmlStringUtil.escapeString((String)message) + "</body></html>";
        }
        return message;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final String getDefaultMessage(Diagnostic diagnostic) {
        String string;
        String string2 = DefaultErrorMessages.render((UnboundDiagnostic)((UnboundDiagnostic)diagnostic));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"DefaultErrorMessages.render(diagnostic)");
        String message = string2;
        boolean $i$f$isApplicationInternalMode = false;
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        if (!application.isInternal()) {
            boolean $i$f$isUnitTestMode = false;
            Application application2 = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application2, (String)"ApplicationManager.getApplication()");
            if (!application2.isUnitTestMode()) {
                string = message;
                return string;
            }
        }
        string = '[' + diagnostic.getFactory().getName() + "] " + message;
        return string;
    }

    @NotNull
    public final List<TextRange> getRanges() {
        return this.ranges;
    }

    @Nullable
    public final String getNonDefaultMessage() {
        return this.nonDefaultMessage;
    }

    @Nullable
    public final ProblemHighlightType getHighlightType() {
        return this.highlightType;
    }

    @Nullable
    public final TextAttributesKey getTextAttributes() {
        return this.textAttributes;
    }

    public AnnotationPresentationInfo(@NotNull List<? extends TextRange> ranges, @Nullable String nonDefaultMessage, @Nullable ProblemHighlightType highlightType, @Nullable TextAttributesKey textAttributes) {
        Intrinsics.checkNotNullParameter(ranges, (String)"ranges");
        this.ranges = ranges;
        this.nonDefaultMessage = nonDefaultMessage;
        this.highlightType = highlightType;
        this.textAttributes = textAttributes;
    }

    public /* synthetic */ AnnotationPresentationInfo(List list, String string, ProblemHighlightType problemHighlightType, TextAttributesKey textAttributesKey, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            problemHighlightType = null;
        }
        if ((n & 8) != 0) {
            textAttributesKey = null;
        }
        this(list, string, problemHighlightType, textAttributesKey);
    }
}

