/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.util;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kotlin.collections.ArraysKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtLabelReferenceExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtScriptInitializer;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.scopes.receivers.ClassQualifier;
import org.jetbrains.kotlin.resolve.scopes.receivers.Qualifier;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

public class CodeInsightUtils {
    @Nullable
    public static PsiElement findElement(@NotNull PsiFile file, int startOffset, int endOffset, @NotNull ElementKind elementKind) {
        KtExpression statement;
        List statements;
        Class<KtExpression> elementClass;
        if (file == null) {
            CodeInsightUtils.$$$reportNull$$$0(0);
        }
        if (elementKind == null) {
            CodeInsightUtils.$$$reportNull$$$0(1);
        }
        switch (elementKind) {
            case EXPRESSION: {
                elementClass = KtExpression.class;
                break;
            }
            case TYPE_ELEMENT: {
                elementClass = KtTypeElement.class;
                break;
            }
            case TYPE_CONSTRUCTOR: {
                elementClass = KtSimpleNameExpression.class;
                break;
            }
            default: {
                throw new IllegalArgumentException(elementKind.name());
            }
        }
        KtExpression element2 = CodeInsightUtils.findElementOfClassAtRange(file, startOffset, endOffset, elementClass);
        if (elementKind == ElementKind.TYPE_ELEMENT) {
            return element2;
        }
        if (elementKind == ElementKind.TYPE_CONSTRUCTOR) {
            return element2 != null && KtPsiUtilKt.isTypeConstructorReference((PsiElement)element2) ? element2 : null;
        }
        if (element2 instanceof KtScriptInitializer) {
            element2 = ((KtScriptInitializer)element2).getBody();
        }
        if (element2 == null) {
            return null;
        }
        if (element2 instanceof KtOperationReferenceExpression && ((KtOperationReferenceExpression)element2).getReferencedNameElementType() != KtTokens.IDENTIFIER && element2.getParent() instanceof KtBinaryExpression) {
            return null;
        }
        if (KtPsiUtil.isLabelIdentifierExpression((PsiElement)element2)) {
            element2 = PsiTreeUtil.getParentOfType((PsiElement)element2, KtExpression.class);
        }
        if (element2 instanceof KtBlockExpression && (statements = ((KtBlockExpression)element2).getStatements()).size() == 1 && (statement = (KtExpression)statements.get(0)).getText().equals(element2.getText())) {
            return statement;
        }
        KtExpression expression = element2;
        BindingContext context = ResolutionUtils.analyze((KtElement)expression);
        Qualifier qualifier = (Qualifier)context.get((ReadOnlySlice)BindingContext.QUALIFIER, (Object)expression);
        if (qualifier != null) {
            if (!(qualifier instanceof ClassQualifier)) {
                return null;
            }
            if (((ClassQualifier)qualifier).getDescriptor().getKind() != ClassKind.OBJECT) {
                return null;
            }
        }
        return expression;
    }

    @NotNull
    public static PsiElement[] findElements(@NotNull PsiFile file, int startOffset, int endOffset, @NotNull ElementKind kind) {
        if (file == null) {
            CodeInsightUtils.$$$reportNull$$$0(2);
        }
        if (kind == null) {
            CodeInsightUtils.$$$reportNull$$$0(3);
        }
        PsiElement element1 = CodeInsightUtils.getElementAtOffsetIgnoreWhitespaceBefore(file, startOffset);
        PsiElement element2 = CodeInsightUtils.getElementAtOffsetIgnoreWhitespaceAfter(file, endOffset);
        if (element1 == null || element2 == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                CodeInsightUtils.$$$reportNull$$$0(4);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        startOffset = element1.getTextRange().getStartOffset();
        if (startOffset >= (endOffset = element2.getTextRange().getEndOffset())) {
            if (PsiElement.EMPTY_ARRAY == null) {
                CodeInsightUtils.$$$reportNull$$$0(5);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        PsiElement parent = PsiTreeUtil.findCommonParent((PsiElement)element1, (PsiElement)element2);
        if (parent == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                CodeInsightUtils.$$$reportNull$$$0(6);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        while (!(parent instanceof KtBlockExpression)) {
            if (parent == null || parent instanceof KtFile) {
                if (PsiElement.EMPTY_ARRAY == null) {
                    CodeInsightUtils.$$$reportNull$$$0(7);
                }
                return PsiElement.EMPTY_ARRAY;
            }
            parent = parent.getParent();
        }
        if (startOffset != (element1 = CodeInsightUtils.getTopmostParentInside(element1, parent)).getTextRange().getStartOffset()) {
            if (PsiElement.EMPTY_ARRAY == null) {
                CodeInsightUtils.$$$reportNull$$$0(8);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        if (endOffset != (element2 = CodeInsightUtils.getTopmostParentInside(element2, parent)).getTextRange().getEndOffset()) {
            if (PsiElement.EMPTY_ARRAY == null) {
                CodeInsightUtils.$$$reportNull$$$0(9);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        ArrayList<PsiElement> array = new ArrayList<PsiElement>();
        PsiElement stopElement = element2.getNextSibling();
        for (PsiElement currentElement = element1; currentElement != stopElement; currentElement = currentElement.getNextSibling()) {
            if (currentElement instanceof PsiWhiteSpace) continue;
            array.add(currentElement);
        }
        for (PsiElement element3 : array) {
            boolean correctType = kind == ElementKind.EXPRESSION && element3 instanceof KtExpression || kind == ElementKind.TYPE_ELEMENT && element3 instanceof KtTypeElement || kind == ElementKind.TYPE_CONSTRUCTOR && KtPsiUtilKt.isTypeConstructorReference((PsiElement)element3);
            if (correctType || element3.getNode().getElementType() == KtTokens.SEMICOLON || element3 instanceof PsiWhiteSpace || element3 instanceof PsiComment) continue;
            if (PsiElement.EMPTY_ARRAY == null) {
                CodeInsightUtils.$$$reportNull$$$0(10);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(array);
        if (psiElementArray == null) {
            CodeInsightUtils.$$$reportNull$$$0(11);
        }
        return psiElementArray;
    }

    @Nullable
    public static <T extends PsiElement> T findElementOfClassAtRange(@NotNull PsiFile file, int startOffset, int endOffset, Class<T> aClass) {
        if (file == null) {
            CodeInsightUtils.$$$reportNull$$$0(12);
        }
        PsiElement element1 = CodeInsightUtils.getParentLabelOrElement(CodeInsightUtils.getElementAtOffsetIgnoreWhitespaceBefore(file, startOffset));
        PsiElement element2 = CodeInsightUtils.getParentLabelOrElement(CodeInsightUtils.getElementAtOffsetIgnoreWhitespaceAfter(file, endOffset));
        if (element1 == null || element2 == null) {
            return null;
        }
        startOffset = element1.getTextRange().getStartOffset();
        PsiElement newElement2 = PsiTreeUtil.findElementOfClassAtRange((PsiFile)file, (int)startOffset, (int)(endOffset = element2.getTextRange().getEndOffset()), aClass);
        if (newElement2 == null || newElement2.getTextRange().getStartOffset() != startOffset || newElement2.getTextRange().getEndOffset() != endOffset) {
            return null;
        }
        return (T)newElement2;
    }

    private static PsiElement getParentLabelOrElement(@Nullable PsiElement element2) {
        if (element2 != null && element2.getParent() instanceof KtLabelReferenceExpression) {
            return element2.getParent();
        }
        return element2;
    }

    @NotNull
    public static List<PsiElement> findElementsOfClassInRange(@NotNull PsiFile file, int startOffset, int endOffset, Class<? extends PsiElement> ... classes) {
        if (file == null) {
            CodeInsightUtils.$$$reportNull$$$0(13);
        }
        PsiElement element1 = CodeInsightUtils.getElementAtOffsetIgnoreWhitespaceBefore(file, startOffset);
        PsiElement element2 = CodeInsightUtils.getElementAtOffsetIgnoreWhitespaceAfter(file, endOffset);
        if (element1 == null || element2 == null) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                CodeInsightUtils.$$$reportNull$$$0(14);
            }
            return list;
        }
        startOffset = element1.getTextRange().getStartOffset();
        endOffset = element2.getTextRange().getEndOffset();
        PsiElement parent = PsiTreeUtil.findCommonParent((PsiElement)element1, (PsiElement)element2);
        if (parent == null) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                CodeInsightUtils.$$$reportNull$$$0(15);
            }
            return list;
        }
        if (startOffset != (element1 = CodeInsightUtils.getTopmostParentInside(element1, parent)).getTextRange().getStartOffset()) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                CodeInsightUtils.$$$reportNull$$$0(16);
            }
            return list;
        }
        if (endOffset != (element2 = CodeInsightUtils.getTopmostParentInside(element2, parent)).getTextRange().getEndOffset()) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                CodeInsightUtils.$$$reportNull$$$0(17);
            }
            return list;
        }
        PsiElement stopElement = element2.getNextSibling();
        ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        for (PsiElement currentElement = element1; currentElement != stopElement && currentElement != null; currentElement = currentElement.getNextSibling()) {
            for (Class<? extends PsiElement> aClass : classes) {
                if (aClass.isInstance(currentElement)) {
                    result.add(currentElement);
                }
                result.addAll(PsiTreeUtil.findChildrenOfType((PsiElement)currentElement, aClass));
            }
        }
        ArrayList<PsiElement> arrayList = result;
        if (arrayList == null) {
            CodeInsightUtils.$$$reportNull$$$0(18);
        }
        return arrayList;
    }

    @NotNull
    private static PsiElement getTopmostParentInside(@NotNull PsiElement element2, @NotNull PsiElement parent) {
        if (element2 == null) {
            CodeInsightUtils.$$$reportNull$$$0(19);
        }
        if (parent == null) {
            CodeInsightUtils.$$$reportNull$$$0(20);
        }
        if (!parent.equals(element2)) {
            while (!parent.equals(element2.getParent())) {
                element2 = element2.getParent();
            }
        }
        PsiElement psiElement = element2;
        if (psiElement == null) {
            CodeInsightUtils.$$$reportNull$$$0(21);
        }
        return psiElement;
    }

    @Nullable
    public static PsiElement getElementAtOffsetIgnoreWhitespaceBefore(@NotNull PsiFile file, int offset) {
        PsiElement element2;
        if (file == null) {
            CodeInsightUtils.$$$reportNull$$$0(22);
        }
        if ((element2 = file.findElementAt(offset)) instanceof PsiWhiteSpace) {
            return file.findElementAt(element2.getTextRange().getEndOffset());
        }
        return element2;
    }

    @Nullable
    public static PsiElement getElementAtOffsetIgnoreWhitespaceAfter(@NotNull PsiFile file, int offset) {
        PsiElement element2;
        if (file == null) {
            CodeInsightUtils.$$$reportNull$$$0(23);
        }
        if ((element2 = file.findElementAt(offset - 1)) instanceof PsiWhiteSpace) {
            return file.findElementAt(element2.getTextRange().getStartOffset() - 1);
        }
        return element2;
    }

    @Nullable
    public static String defaultInitializer(KotlinType type) {
        if (type.isMarkedNullable()) {
            return "null";
        }
        if (KotlinBuiltIns.isInt((KotlinType)type) || KotlinBuiltIns.isLong((KotlinType)type) || KotlinBuiltIns.isShort((KotlinType)type) || KotlinBuiltIns.isByte((KotlinType)type)) {
            return "0";
        }
        if (KotlinBuiltIns.isFloat((KotlinType)type)) {
            return "0.0f";
        }
        if (KotlinBuiltIns.isDouble((KotlinType)type)) {
            return "0.0";
        }
        if (KotlinBuiltIns.isChar((KotlinType)type)) {
            return "'\\u0000'";
        }
        if (KotlinBuiltIns.isBoolean((KotlinType)type)) {
            return "false";
        }
        if (KotlinBuiltIns.isUnit((KotlinType)type)) {
            return "Unit";
        }
        if (KotlinBuiltIns.isString((KotlinType)type)) {
            return "\"\"";
        }
        return null;
    }

    public static void showErrorHint(@NotNull Project project, @NotNull Editor editor, @NotNull String message, @NotNull String title, @Nullable String helpId) {
        if (project == null) {
            CodeInsightUtils.$$$reportNull$$$0(24);
        }
        if (editor == null) {
            CodeInsightUtils.$$$reportNull$$$0(25);
        }
        if (message == null) {
            CodeInsightUtils.$$$reportNull$$$0(26);
        }
        if (title == null) {
            CodeInsightUtils.$$$reportNull$$$0(27);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            throw new CommonRefactoringUtil.RefactoringErrorHintException(message);
        }
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)title, (String)helpId);
    }

    private CodeInsightUtils() {
    }

    @Nullable
    public static Integer getStartLineOffset(@NotNull PsiFile file, int line) {
        Document document;
        if (file == null) {
            CodeInsightUtils.$$$reportNull$$$0(28);
        }
        if ((document = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file)) == null) {
            return null;
        }
        if (line >= document.getLineCount()) {
            return null;
        }
        int lineStartOffset = document.getLineStartOffset(line);
        return CharArrayUtil.shiftForward((CharSequence)document.getCharsSequence(), (int)lineStartOffset, (String)" \t");
    }

    @Nullable
    public static Integer getEndLineOffset(@NotNull PsiFile file, int line) {
        Document document;
        if (file == null) {
            CodeInsightUtils.$$$reportNull$$$0(29);
        }
        if ((document = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file)) == null) {
            return null;
        }
        if (line >= document.getLineCount()) {
            return null;
        }
        int lineStartOffset = document.getLineEndOffset(line);
        return CharArrayUtil.shiftBackward((CharSequence)document.getCharsSequence(), (int)lineStartOffset, (String)" \t");
    }

    @NotNull
    public static PsiElement getTopmostElementAtOffset(@NotNull PsiElement element2, int offset) {
        PsiElement parent;
        if (element2 == null) {
            CodeInsightUtils.$$$reportNull$$$0(30);
        }
        while ((parent = element2.getParent()) != null && parent.getTextOffset() >= offset && !(parent instanceof KtBlockExpression) && !(parent instanceof PsiFile)) {
            element2 = parent;
        }
        PsiElement psiElement = element2;
        if (psiElement == null) {
            CodeInsightUtils.$$$reportNull$$$0(31);
        }
        return psiElement;
    }

    @NotNull
    public static PsiElement getTopParentWithEndOffset(@NotNull PsiElement element2, @NotNull Class<?> stopAt) {
        PsiElement parent;
        if (element2 == null) {
            CodeInsightUtils.$$$reportNull$$$0(32);
        }
        if (stopAt == null) {
            CodeInsightUtils.$$$reportNull$$$0(33);
        }
        int endOffset = element2.getTextOffset() + element2.getTextLength();
        while ((parent = element2.getParent()) != null && parent.getTextOffset() + parent.getTextLength() == endOffset && !stopAt.isInstance(element2 = parent)) {
        }
        PsiElement psiElement = element2;
        if (psiElement == null) {
            CodeInsightUtils.$$$reportNull$$$0(34);
        }
        return psiElement;
    }

    @Nullable
    public static <T> T getTopmostElementAtOffset(@NotNull PsiElement element2, int offset, Class<? extends T> ... classes) {
        PsiElement parent;
        if (element2 == null) {
            CodeInsightUtils.$$$reportNull$$$0(35);
        }
        if (classes == null) {
            CodeInsightUtils.$$$reportNull$$$0(36);
        }
        PsiElement lastElementOfType = null;
        if (CodeInsightUtils.anyIsInstance(element2, classes)) {
            lastElementOfType = element2;
        }
        while ((parent = element2.getParent()) != null && parent.getTextOffset() >= offset && !(parent instanceof KtBlockExpression)) {
            if (CodeInsightUtils.anyIsInstance(parent, classes)) {
                lastElementOfType = parent;
            }
            element2 = parent;
        }
        return (T)lastElementOfType;
    }

    private static <T> boolean anyIsInstance(PsiElement finalElement, @NotNull Class<? extends T>[] klass) {
        if (klass == null) {
            CodeInsightUtils.$$$reportNull$$$0(37);
        }
        return ArraysKt.any((Object[])klass, aClass -> aClass.isInstance(finalElement));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 31: 
            case 34: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 31: 
            case 34: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementKind";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 31: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/idea/core/util/CodeInsightUtils";
                break;
            }
            case 19: 
            case 30: 
            case 32: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stopAt";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classes";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "klass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/idea/core/util/CodeInsightUtils";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "findElements";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "findElementsOfClassInRange";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopmostParentInside";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopmostElementAtOffset";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopParentWithEndOffset";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findElement";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findElements";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 31: 
            case 34: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findElementOfClassAtRange";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findElementsOfClassInRange";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getTopmostParentInside";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getElementAtOffsetIgnoreWhitespaceBefore";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getElementAtOffsetIgnoreWhitespaceAfter";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "showErrorHint";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getStartLineOffset";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getEndLineOffset";
                break;
            }
            case 30: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getTopmostElementAtOffset";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getTopParentWithEndOffset";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "anyIsInstance";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 31: 
            case 34: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum ElementKind {
        EXPRESSION,
        TYPE_ELEMENT,
        TYPE_CONSTRUCTOR;

    }
}

