/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.script.ucache;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.script.ucache.ScriptClassRootsCache;
import org.jetbrains.kotlin.idea.core.script.ucache.ScriptClassRootsCacheKt;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B!\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0096\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u000e\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u0003J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptCacheDependencies;", "Ljava/io/Serializable;", "cache", "Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptClassRootsCache;", "(Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptClassRootsCache;)V", "classFiles", "", "", "sources", "(Ljava/util/Set;Ljava/util/Set;)V", "getClassFiles", "()Ljava/util/Set;", "getSources", "equals", "", "other", "", "hashCode", "", "sameAs", "save", "", "project", "Lcom/intellij/openapi/project/Project;", "Companion", "kotlin.core"})
public final class ScriptCacheDependencies
implements Serializable {
    @NotNull
    private final Set<String> classFiles;
    @NotNull
    private final Set<String> sources;
    @NotNull
    public static final Companion Companion = new Companion(null);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean sameAs(@NotNull ScriptClassRootsCache cache2) {
        Object v0;
        VirtualFile it;
        Object element$iv2;
        boolean $i$f$firstOrNull;
        Iterable $this$firstOrNull$iv;
        block3: {
            Intrinsics.checkNotNullParameter((Object)cache2, (String)"cache");
            if (cache2.getAllDependenciesClassFiles().size() != this.classFiles.size()) return false;
            if (cache2.getAllDependenciesSources().size() != this.sources.size()) {
                return false;
            }
            $this$firstOrNull$iv = cache2.getAllDependenciesClassFiles();
            $i$f$firstOrNull = false;
            for (Object element$iv2 : $this$firstOrNull$iv) {
                it = (VirtualFile)element$iv2;
                boolean bl = false;
                if (!(!this.classFiles.contains(it.getPath()))) continue;
                v0 = element$iv2;
                break block3;
            }
            v0 = null;
        }
        if (v0 != null) return false;
        $this$firstOrNull$iv = cache2.getAllDependenciesSources();
        $i$f$firstOrNull = false;
        Iterator iterator = $this$firstOrNull$iv.iterator();
        do {
            if (!iterator.hasNext()) return true;
            element$iv2 = iterator.next();
            it = (VirtualFile)element$iv2;
            boolean bl = false;
        } while (!(!this.sources.contains(it.getPath())));
        Object v1 = element$iv2;
        if (v1 != null) return false;
        return true;
    }

    public final void save(@NotNull Project project) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            VirtualFile virtualFile = ScriptCacheDependencies.Companion.scriptCacheDependenciesFile(project);
            if (virtualFile == null) break block0;
            ScriptClassRootsCacheKt.access$setScriptCacheDependencies$p(virtualFile, this);
        }
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null) ^ true) {
            return false;
        }
        Object object2 = other;
        if (object2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.idea.core.script.ucache.ScriptCacheDependencies");
        }
        ScriptCacheDependencies cfr_ignored_0 = (ScriptCacheDependencies)object2;
        return Intrinsics.areEqual(this.classFiles, ((ScriptCacheDependencies)other).classFiles) && Intrinsics.areEqual(this.sources, ((ScriptCacheDependencies)other).sources);
    }

    public int hashCode() {
        int result = ((Object)this.classFiles).hashCode();
        result = 31 * result + ((Object)this.sources).hashCode();
        return result;
    }

    @NotNull
    public final Set<String> getClassFiles() {
        return this.classFiles;
    }

    @NotNull
    public final Set<String> getSources() {
        return this.sources;
    }

    public ScriptCacheDependencies(@NotNull Set<String> classFiles, @NotNull Set<String> sources) {
        Intrinsics.checkNotNullParameter(classFiles, (String)"classFiles");
        Intrinsics.checkNotNullParameter(sources, (String)"sources");
        this.classFiles = classFiles;
        this.sources = sources;
    }

    public ScriptCacheDependencies(@NotNull ScriptClassRootsCache cache2) {
        Object object;
        VirtualFile p1;
        Set set;
        Collection destination$iv;
        Iterable $this$mapTo$iv;
        Intrinsics.checkNotNullParameter((Object)cache2, (String)"cache");
        Iterable iterable = cache2.getAllDependenciesClassFiles();
        Collection collection = new HashSet();
        ScriptCacheDependencies scriptCacheDependencies = this;
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            VirtualFile virtualFile = (VirtualFile)item$iv;
            set = destination$iv;
            boolean bl = false;
            object = p1.getPath();
            set.add(object);
        }
        set = destination$iv;
        $this$mapTo$iv = cache2.getAllDependenciesSources();
        destination$iv = new HashSet();
        set = set;
        $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            p1 = (VirtualFile)item$iv;
            object = destination$iv;
            boolean bl = false;
            String string = p1.getPath();
            object.add(string);
        }
        object = collection;
        scriptCacheDependencies(set, (Set)object);
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\f\u0010\u0003\u001a\u0004\u0018\u00010\u0004*\u00020\u0005J\u000e\u0010\u0006\u001a\u0004\u0018\u00010\u0007*\u00020\u0005H\u0002\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptCacheDependencies$Companion;", "", "()V", "scriptCacheDependencies", "Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptCacheDependencies;", "Lcom/intellij/openapi/project/Project;", "scriptCacheDependenciesFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "kotlin.core"})
    public static final class Companion {
        private final VirtualFile scriptCacheDependenciesFile(Project $this$scriptCacheDependenciesFile) {
            VirtualFile virtualFile = $this$scriptCacheDependenciesFile.getProjectFile();
            if (virtualFile == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"this.projectFile ?: return null");
            VirtualFile file = virtualFile;
            while (!file.isDirectory() || Intrinsics.areEqual((Object)file.getName(), (Object)".idea")) {
                Intrinsics.checkNotNullExpressionValue((Object)file.getParent(), (String)"file.parent");
            }
            return file;
        }

        @Nullable
        public final ScriptCacheDependencies scriptCacheDependencies(@NotNull Project $this$scriptCacheDependencies) {
            ScriptCacheDependencies scriptCacheDependencies;
            Intrinsics.checkNotNullParameter((Object)$this$scriptCacheDependencies, (String)"$this$scriptCacheDependencies");
            try {
                VirtualFile virtualFile = this.scriptCacheDependenciesFile($this$scriptCacheDependencies);
                scriptCacheDependencies = virtualFile != null ? ScriptClassRootsCacheKt.access$getScriptCacheDependencies$p(virtualFile) : null;
            }
            catch (Exception e) {
                scriptCacheDependencies = null;
            }
            return scriptCacheDependencies;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

