/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.compiler;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analyzer.LanguageSettingsProvider;
import org.jetbrains.kotlin.analyzer.ModuleInfo;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.JavaTypeEnhancementStateParser;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.config.KotlinFacetSettingsProvider;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.idea.caches.project.LibraryInfo;
import org.jetbrains.kotlin.idea.caches.project.ModuleSourceInfo;
import org.jetbrains.kotlin.idea.caches.project.PlatformModuleInfo;
import org.jetbrains.kotlin.idea.caches.project.ScriptDependenciesInfo;
import org.jetbrains.kotlin.idea.caches.project.ScriptModuleInfo;
import org.jetbrains.kotlin.idea.compiler.IDELanguageSettingsProviderKt;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.TargetPlatformVersion;
import org.jetbrains.kotlin.platform.jvm.JdkPlatform;
import org.jetbrains.kotlin.utils.JavaTypeEnhancementState;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/compiler/IDELanguageSettingsProvider;", "Lorg/jetbrains/kotlin/analyzer/LanguageSettingsProvider;", "()V", "computeJavaTypeEnhancementState", "Lorg/jetbrains/kotlin/utils/JavaTypeEnhancementState;", "project", "Lcom/intellij/openapi/project/Project;", "getLanguageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "moduleInfo", "Lorg/jetbrains/kotlin/analyzer/ModuleInfo;", "getTargetPlatform", "Lorg/jetbrains/kotlin/platform/TargetPlatformVersion;", "kotlin.core"})
public final class IDELanguageSettingsProvider
implements LanguageSettingsProvider {
    @NotNull
    public static final IDELanguageSettingsProvider INSTANCE;

    @NotNull
    public LanguageVersionSettings getLanguageVersionSettings(@NotNull ModuleInfo moduleInfo, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)moduleInfo, (String)"moduleInfo");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ModuleInfo moduleInfo2 = moduleInfo;
        return moduleInfo2 instanceof ModuleSourceInfo ? PlatformKt.getLanguageVersionSettings(((ModuleSourceInfo)moduleInfo).getModule()) : (moduleInfo2 instanceof LibraryInfo ? PlatformKt.getLanguageVersionSettings$default(project, null, this.computeJavaTypeEnhancementState(project), 1, null) : (moduleInfo2 instanceof ScriptModuleInfo ? IDELanguageSettingsProviderKt.access$getLanguageSettingsForScripts(project, ((ScriptModuleInfo)moduleInfo).getScriptFile(), ((ScriptModuleInfo)moduleInfo).getScriptDefinition()).getLanguageVersionSettings() : (moduleInfo2 instanceof ScriptDependenciesInfo.ForFile ? IDELanguageSettingsProviderKt.access$getLanguageSettingsForScripts(project, ((ScriptDependenciesInfo.ForFile)moduleInfo).getScriptFile(), ((ScriptDependenciesInfo.ForFile)moduleInfo).getScriptDefinition()).getLanguageVersionSettings() : (moduleInfo2 instanceof PlatformModuleInfo ? PlatformKt.getLanguageVersionSettings(((PlatformModuleInfo)moduleInfo).getPlatformModule().getModule()) : PlatformKt.getLanguageVersionSettings$default(project, null, null, 3, null)))));
    }

    private final JavaTypeEnhancementState computeJavaTypeEnhancementState(Project project) {
        JavaTypeEnhancementState result = null;
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)moduleManager, (String)"ModuleManager.getInstance(project)");
        for (Module module : moduleManager.getModules()) {
            K2JVMCompilerArguments compilerArguments;
            KotlinFacetSettingsProvider kotlinFacetSettingsProvider = KotlinFacetSettingsProvider.Companion.getInstance(project);
            if (kotlinFacetSettingsProvider == null) continue;
            Module module2 = module;
            Intrinsics.checkNotNullExpressionValue((Object)module2, (String)"module");
            if ((kotlinFacetSettingsProvider = kotlinFacetSettingsProvider.getSettings(module2)) == null) {
                continue;
            }
            KotlinFacetSettingsProvider settings2 = kotlinFacetSettingsProvider;
            CommonCompilerArguments commonCompilerArguments = settings2.getMergedCompilerArguments();
            if (!(commonCompilerArguments instanceof K2JVMCompilerArguments)) {
                commonCompilerArguments = null;
            }
            if ((K2JVMCompilerArguments)commonCompilerArguments == null) {
                continue;
            }
            result = new JavaTypeEnhancementStateParser(MessageCollector.Companion.getNONE()).parse(compilerArguments.getJsr305(), compilerArguments.getSupportCompatqualCheckerFrameworkAnnotations(), compilerArguments.getJspecifyAnnotations());
        }
        return result;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @NotNull
    public TargetPlatformVersion getTargetPlatform(@NotNull ModuleInfo moduleInfo, @NotNull Project project) {
        TargetPlatformVersion targetPlatformVersion;
        Intrinsics.checkNotNullParameter((Object)moduleInfo, (String)"moduleInfo");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ModuleInfo moduleInfo2 = moduleInfo;
        if (moduleInfo2 instanceof ModuleSourceInfo) {
            TargetPlatform targetPlatform = PlatformKt.getPlatform(((ModuleSourceInfo)moduleInfo).getModule());
            if (targetPlatform != null) {
                void $this$filterIsInstanceTo$iv$iv$iv;
                TargetPlatform $this$subplatformsOfType$iv = targetPlatform;
                boolean $i$f$subplatformsOfType = false;
                Iterable $this$filterIsInstance$iv$iv = $this$subplatformsOfType$iv.getComponentPlatforms();
                boolean $i$f$filterIsInstance = false;
                Iterable iterable = $this$filterIsInstance$iv$iv;
                Collection destination$iv$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv$iv : $this$filterIsInstanceTo$iv$iv$iv) {
                    if (!(element$iv$iv$iv instanceof JdkPlatform)) continue;
                    destination$iv$iv$iv.add(element$iv$iv$iv);
                }
                targetPlatform = (JdkPlatform)CollectionsKt.firstOrNull((List)((List)destination$iv$iv$iv));
                if (targetPlatform != null && (targetPlatform = targetPlatform.getTargetVersion()) != null) {
                    targetPlatformVersion = (TargetPlatformVersion)targetPlatform;
                    return targetPlatformVersion;
                }
            }
            targetPlatformVersion = (TargetPlatformVersion)TargetPlatformVersion.NoVersion.INSTANCE;
            return targetPlatformVersion;
        }
        if (!(moduleInfo2 instanceof ScriptModuleInfo) && !(moduleInfo2 instanceof ScriptDependenciesInfo.ForFile)) {
            targetPlatformVersion = (TargetPlatformVersion)TargetPlatformVersion.NoVersion.INSTANCE;
            return targetPlatformVersion;
        }
        targetPlatformVersion = IDELanguageSettingsProviderKt.access$detectDefaultTargetPlatformVersion(moduleInfo.getPlatform());
        return targetPlatformVersion;
    }

    private IDELanguageSettingsProvider() {
    }

    static {
        IDELanguageSettingsProvider iDELanguageSettingsProvider;
        INSTANCE = iDELanguageSettingsProvider = new IDELanguageSettingsProvider();
    }
}

