/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.caches.resolve;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Arrays;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.AnalysisResult;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.container.ComponentProvider;
import org.jetbrains.kotlin.container.DslKt;
import org.jetbrains.kotlin.context.ContextKt;
import org.jetbrains.kotlin.context.GlobalContext;
import org.jetbrains.kotlin.context.ModuleContext;
import org.jetbrains.kotlin.context.ProjectContext;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtils;
import org.jetbrains.kotlin.frontend.di.InjectionKt;
import org.jetbrains.kotlin.idea.MainFunctionDetector;
import org.jetbrains.kotlin.idea.caches.project.GetModuleInfoKt;
import org.jetbrains.kotlin.idea.caches.project.IdeaModuleInfo;
import org.jetbrains.kotlin.idea.caches.resolve.CodeFragmentAnalyzer;
import org.jetbrains.kotlin.idea.caches.resolve.KotlinCacheServiceImplKt;
import org.jetbrains.kotlin.idea.compiler.IdeMainFunctionDetectorFactory;
import org.jetbrains.kotlin.idea.compiler.IdeSealedClassInheritorsProvider;
import org.jetbrains.kotlin.idea.project.AnalyzerServicesKt;
import org.jetbrains.kotlin.idea.project.IdeaModuleStructureOracle;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClassInitializer;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtSuperTypeList;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.KtTypeConstraint;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.BodyResolveCache;
import org.jetbrains.kotlin.resolve.DelegatingBindingTrace;
import org.jetbrains.kotlin.resolve.LazyTopDownAnalyzer;
import org.jetbrains.kotlin.resolve.ModuleStructureOracle;
import org.jetbrains.kotlin.resolve.PlatformDependentAnalyzerServices;
import org.jetbrains.kotlin.resolve.SealedClassInheritorsProvider;
import org.jetbrains.kotlin.resolve.TopDownAnalysisMode;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.resolve.lazy.KotlinCodeAnalyzer;
import org.jetbrains.kotlin.resolve.lazy.ResolveSession;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JR\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bJ\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u001d\u001a\u00020\u0017R\"\u0010\u0003\u001a\u0014\u0012\u0010\u0012\u000e\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u0006\u0018\u00010\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/idea/caches/resolve/KotlinResolveDataProvider;", "", "()V", "topmostElementTypes", "", "Ljava/lang/Class;", "Lcom/intellij/psi/PsiElement;", "[Ljava/lang/Class;", "analyze", "Lorg/jetbrains/kotlin/analyzer/AnalysisResult;", "project", "Lcom/intellij/openapi/project/Project;", "globalContext", "Lorg/jetbrains/kotlin/context/GlobalContext;", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "resolveSession", "Lorg/jetbrains/kotlin/resolve/lazy/ResolveSession;", "codeFragmentAnalyzer", "Lorg/jetbrains/kotlin/idea/caches/resolve/CodeFragmentAnalyzer;", "bodyResolveCache", "Lorg/jetbrains/kotlin/resolve/BodyResolveCache;", "analyzableElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "bindingTrace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "callback", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink$DiagnosticsCallback;", "findAnalyzableParent", "element", "kotlin.core"})
final class KotlinResolveDataProvider {
    private static final Class<? extends PsiElement>[] topmostElementTypes;
    @NotNull
    public static final KotlinResolveDataProvider INSTANCE;

    @Nullable
    public final KtElement findAnalyzableParent(@NotNull KtElement element2) {
        KtElement ktElement;
        KtElement analyzableElement;
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        if (element2 instanceof KtFile) {
            return element2;
        }
        KtElement topmostElement = (KtElement)KtPsiUtil.getTopmostParentOfTypes((PsiElement)((PsiElement)element2), (Class[])Arrays.copyOf(topmostElementTypes, topmostElementTypes.length));
        KtElement ktElement2 = topmostElement;
        KtElement ktElement3 = analyzableElement = ktElement2 instanceof KtAnnotationEntry || ktElement2 instanceof KtTypeConstraint || ktElement2 instanceof KtSuperTypeList || ktElement2 instanceof KtTypeParameter || ktElement2 instanceof KtParameter ? (KtElement)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)topmostElement), (Class[])new Class[]{KtClassOrObject.class, KtCallableDeclaration.class}) : topmostElement;
        if (analyzableElement instanceof KtPrimaryConstructor) {
            return (KtElement)((KtPrimaryConstructor)analyzableElement).getContainingClassOrObject();
        }
        if (analyzableElement instanceof KtClassInitializer) {
            return (KtElement)((KtClassInitializer)analyzableElement).getContainingDeclaration();
        }
        KtElement ktElement4 = analyzableElement;
        if (ktElement4 == null) {
            ktElement4 = ktElement = (KtElement)PsiTreeUtil.getTopmostParentOfType((PsiElement)((PsiElement)element2), KtDeclaration.class);
        }
        if (ktElement4 == null) {
            PsiFile psiFile = element2.getContainingFile();
            if (!(psiFile instanceof KtFile)) {
                psiFile = null;
            }
            ktElement = (KtElement)((KtFile)psiFile);
        }
        return ktElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final AnalysisResult analyze(@NotNull Project project, @NotNull GlobalContext globalContext, @NotNull ModuleDescriptor moduleDescriptor, @NotNull ResolveSession resolveSession, @NotNull CodeFragmentAnalyzer codeFragmentAnalyzer, @NotNull BodyResolveCache bodyResolveCache, @NotNull KtElement analyzableElement, @Nullable BindingTrace bindingTrace, @Nullable DiagnosticSink.DiagnosticsCallback callback) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)globalContext, (String)"globalContext");
        Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"moduleDescriptor");
        Intrinsics.checkNotNullParameter((Object)resolveSession, (String)"resolveSession");
        Intrinsics.checkNotNullParameter((Object)codeFragmentAnalyzer, (String)"codeFragmentAnalyzer");
        Intrinsics.checkNotNullParameter((Object)bodyResolveCache, (String)"bodyResolveCache");
        Intrinsics.checkNotNullParameter((Object)analyzableElement, (String)"analyzableElement");
        try {
            if (analyzableElement instanceof KtCodeFragment) {
                BodyResolveMode bodyResolveMode = BodyResolveMode.PARTIAL_FOR_COMPLETION;
                BindingTrace trace = codeFragmentAnalyzer.analyzeCodeFragment((KtCodeFragment)analyzableElement, bodyResolveMode);
                BindingContext bindingContext = trace.getBindingContext();
                Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"trace.bindingContext");
                BindingContext bindingContext2 = bindingContext;
                return AnalysisResult.Companion.success(bindingContext2, moduleDescriptor);
            }
            BindingTrace bindingTrace2 = bindingTrace;
            if (bindingTrace2 == null) {
                BindingContext bindingContext = resolveSession.getBindingContext();
                Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"resolveSession.bindingContext");
                bindingTrace2 = (BindingTrace)new DelegatingBindingTrace(bindingContext, "Trace for resolution of " + analyzableElement, false, null, true, null, 44, null);
            }
            BindingTrace trace = bindingTrace2;
            KtFile ktFile = analyzableElement.getContainingKtFile();
            Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"analyzableElement.containingKtFile");
            IdeaModuleInfo moduleInfo = GetModuleInfoKt.getModuleInfo((PsiElement)ktFile);
            TargetPlatform targetPlatform = moduleInfo.getPlatform();
            DiagnosticSink.DiagnosticsCallback diagnosticsCallback = callback;
            if (diagnosticsCallback != null) {
                DiagnosticSink.DiagnosticsCallback diagnosticsCallback2 = diagnosticsCallback;
                boolean bl = false;
                boolean bl2 = false;
                DiagnosticSink.DiagnosticsCallback it = diagnosticsCallback2;
                boolean bl3 = false;
                trace.setCallback(it);
            }
            try {
                void $this$get$iv;
                ComponentProvider componentProvider = (ComponentProvider)InjectionKt.createContainerForLazyBodyResolve((ModuleContext)ContextKt.withModule((ProjectContext)ContextKt.withProject((GlobalContext)globalContext, (Project)project), (ModuleDescriptor)moduleDescriptor), (KotlinCodeAnalyzer)((KotlinCodeAnalyzer)resolveSession), (BindingTrace)trace, (TargetPlatform)targetPlatform, (BodyResolveCache)bodyResolveCache, (PlatformDependentAnalyzerServices)AnalyzerServicesKt.findAnalyzerServices(targetPlatform, project), (LanguageVersionSettings)PlatformKt.getLanguageVersionSettings((PsiElement)analyzableElement), (ModuleStructureOracle)new IdeaModuleStructureOracle(), (MainFunctionDetector.Factory)new IdeMainFunctionDetectorFactory(), (SealedClassInheritorsProvider)IdeSealedClassInheritorsProvider.INSTANCE);
                boolean $i$f$get = false;
                LazyTopDownAnalyzer lazyTopDownAnalyzer = (LazyTopDownAnalyzer)DslKt.getService((ComponentProvider)$this$get$iv, LazyTopDownAnalyzer.class);
                LazyTopDownAnalyzer.analyzeDeclarations$default((LazyTopDownAnalyzer)lazyTopDownAnalyzer, (TopDownAnalysisMode)TopDownAnalysisMode.TopLevelDeclarations, (Collection)CollectionsKt.listOf((Object)analyzableElement), null, null, (int)12, null);
            }
            finally {
                trace.resetCallback();
            }
            BindingContext bindingContext = trace.getBindingContext();
            Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"trace.bindingContext");
            return AnalysisResult.Companion.success(bindingContext, moduleDescriptor);
        }
        catch (ProcessCanceledException e) {
            throw (Throwable)e;
        }
        catch (IndexNotReadyException e) {
            throw (Throwable)e;
        }
        catch (Throwable e) {
            DiagnosticUtils.throwIfRunningOnServer((Throwable)e);
            KotlinCacheServiceImplKt.getLOG().error(e);
            BindingContext bindingContext = BindingContext.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"BindingContext.EMPTY");
            return AnalysisResult.Companion.internalError(bindingContext, e);
        }
    }

    private KotlinResolveDataProvider() {
    }

    static {
        KotlinResolveDataProvider kotlinResolveDataProvider;
        INSTANCE = kotlinResolveDataProvider = new KotlinResolveDataProvider();
        topmostElementTypes = new Class[]{KtNamedFunction.class, KtAnonymousInitializer.class, KtProperty.class, KtImportDirective.class, KtPackageDirective.class, KtCodeFragment.class, KtAnnotationEntry.class, KtTypeConstraint.class, KtSuperTypeList.class, KtTypeParameter.class, KtParameter.class, KtTypeAlias.class};
    }
}

