/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.caches.project;

import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.fileTypes.FileTypeEvent;
import com.intellij.openapi.fileTypes.FileTypeListener;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.messages.MessageBusConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.caches.project.LibraryModificationTrackerKt;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J+\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\t0\u0012H\u0082\bR\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/caches/project/LibraryModificationTracker;", "Lcom/intellij/openapi/util/SimpleModificationTracker;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "projectFileIndex", "Lcom/intellij/openapi/roots/ProjectFileIndex;", "kotlin.jvm.PlatformType", "isLibraryArchiveRoot", "", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "processBulk", "", "events", "", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "check", "Lkotlin/Function1;", "Companion", "kotlin.core"})
public final class LibraryModificationTracker
extends SimpleModificationTracker {
    private final ProjectFileIndex projectFileIndex;
    @NotNull
    public static final Companion Companion = new Companion(null);

    private final void processBulk(List<? extends VFileEvent> events, Function1<? super VirtualFile, Boolean> check) {
        int $i$f$processBulk = 0;
        Iterable $this$forEach$iv = events;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VirtualFile file;
            VFileEvent event = (VFileEvent)element$iv;
            boolean bl = false;
            if (!event.isValid() || (file = event.getFile()) == null || !((Boolean)check.invoke((Object)file)).booleanValue()) continue;
            this.incModificationCount();
            return;
        }
    }

    private final boolean isLibraryArchiveRoot(VirtualFile virtualFile) {
        if (Intrinsics.areEqual((Object)virtualFile.getFileType(), (Object)ArchiveFileType.INSTANCE) ^ true) {
            return false;
        }
        VirtualFile virtualFile2 = JarFileSystem.getInstance().getRootByLocal(virtualFile);
        if (virtualFile2 == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"JarFileSystem.getInstanc\u2026tualFile) ?: return false");
        VirtualFile archiveRoot = virtualFile2;
        return this.projectFileIndex.isInLibraryClasses(archiveRoot);
    }

    public LibraryModificationTracker(final @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        MessageBusConnection messageBusConnection = project.getMessageBus().connect((Disposable)project);
        Intrinsics.checkNotNullExpressionValue((Object)messageBusConnection, (String)"project.messageBus.connect(project)");
        MessageBusConnection connection = messageBusConnection;
        connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            /*
             * WARNING - void declaration
             */
            public void after(@NotNull List<? extends VFileEvent> events) {
                void $this$filterTo$iv$iv;
                Intrinsics.checkNotNullParameter(events, (String)"events");
                Iterable $this$filter$iv = events;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    VFileEvent p1 = (VFileEvent)element$iv$iv;
                    boolean bl = false;
                    if (!LibraryModificationTrackerKt.access$isRelevantEvent(p1)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List list = (List)destination$iv$iv;
                boolean bl = false;
                boolean bl2 = false;
                List createEvents = list;
                boolean bl3 = false;
                Collection collection = createEvents;
                boolean bl4 = false;
                if (!collection.isEmpty()) {
                    ApplicationManager.getApplication().invokeLater(new Runnable(createEvents, this){
                        final /* synthetic */ List $createEvents;
                        final /* synthetic */ 1 this$0;
                        {
                            this.$createEvents = list;
                            this.this$0 = var2_2;
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public final void run() {
                            if (!this.this$0.project.isDisposed()) {
                                LibraryModificationTracker libraryModificationTracker = this.this$0.this;
                                List events$iv = this.$createEvents;
                                boolean $i$f$processBulk = false;
                                Iterable $this$forEach$iv$iv = events$iv;
                                boolean $i$f$forEach = false;
                                for (T element$iv$iv : $this$forEach$iv$iv) {
                                    void this_$iv;
                                    VirtualFile file$iv;
                                    VFileEvent event$iv = (VFileEvent)element$iv$iv;
                                    boolean bl = false;
                                    if (!event$iv.isValid() || (file$iv = event$iv.getFile()) == null) continue;
                                    VirtualFile it = file$iv;
                                    boolean bl2 = false;
                                    if (!(LibraryModificationTracker.access$getProjectFileIndex$p(this.this$0.this).isInLibraryClasses(it) || LibraryModificationTracker.access$isLibraryArchiveRoot(this.this$0.this, it))) continue;
                                    this_$iv.incModificationCount();
                                    break;
                                }
                            }
                        }
                    });
                }
            }

            public void before(@NotNull List<? extends VFileEvent> events) {
                Intrinsics.checkNotNullParameter(events, (String)"events");
                LibraryModificationTracker this_$iv = this;
                boolean $i$f$processBulk = false;
                Iterable $this$forEach$iv$iv = events;
                boolean $i$f$forEach = false;
                for (Object element$iv$iv : $this$forEach$iv$iv) {
                    VirtualFile file$iv;
                    VFileEvent event$iv = (VFileEvent)element$iv$iv;
                    boolean bl = false;
                    if (!event$iv.isValid() || (file$iv = event$iv.getFile()) == null) continue;
                    VirtualFile it = file$iv;
                    boolean bl2 = false;
                    if (!projectFileIndex.isInLibraryClasses(it)) continue;
                    this_$iv.incModificationCount();
                    break;
                }
            }
        });
        connection.subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

            public void enteredDumbMode() {
                this.incModificationCount();
            }

            public void exitDumbMode() {
                this.incModificationCount();
            }
        });
        connection.subscribe(FileTypeManager.TOPIC, (Object)new FileTypeListener(){

            public void beforeFileTypesChanged(@NotNull FileTypeEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.incModificationCount();
            }

            public void fileTypesChanged(@NotNull FileTypeEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.incModificationCount();
            }
        });
        this.projectFileIndex = ProjectFileIndex.SERVICE.getInstance((Project)project);
    }

    public static final /* synthetic */ void access$processBulk(LibraryModificationTracker $this, List events, Function1 check) {
        $this.processBulk(events, (Function1<? super VirtualFile, Boolean>)check);
    }

    public static final /* synthetic */ boolean access$isLibraryArchiveRoot(LibraryModificationTracker $this, VirtualFile virtualFile) {
        return $this.isLibraryArchiveRoot(virtualFile);
    }

    @JvmStatic
    @NotNull
    public static final LibraryModificationTracker getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/caches/project/LibraryModificationTracker$Companion;", "", "()V", "getInstance", "Lorg/jetbrains/kotlin/idea/caches/project/LibraryModificationTracker;", "project", "Lcom/intellij/openapi/project/Project;", "kotlin.core"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final LibraryModificationTracker getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$getServiceSafe$iv = (ComponentManager)project;
            boolean $i$f$getServiceSafe = false;
            Object object = $this$getServiceSafe$iv.getService(LibraryModificationTracker.class);
            if (object == null) {
                String string = "Unable to locate service " + LibraryModificationTracker.class.getName();
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            return (LibraryModificationTracker)((Object)object);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

