/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.caches;

import com.intellij.ProjectTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.file.impl.FileManager;
import com.intellij.util.messages.MessageBusConnection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.caches.KotlinPackageContentModificationListener;
import org.jetbrains.kotlin.idea.caches.PerModulePackageCacheService;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/caches/KotlinPackageContentModificationListener;", "Lcom/intellij/openapi/startup/StartupActivity;", "()V", "runActivity", "", "project", "Lcom/intellij/openapi/project/Project;", "Companion", "kotlin.core"})
public final class KotlinPackageContentModificationListener
implements StartupActivity {
    @NotNull
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    public void runActivity(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        MessageBusConnection messageBusConnection = project.getMessageBus().connect((Disposable)project);
        Intrinsics.checkNotNullExpressionValue((Object)messageBusConnection, (String)"project.messageBus.connect(project)");
        MessageBusConnection connection = messageBusConnection;
        connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(project){
            final /* synthetic */ Project $project;

            public void before(@NotNull List<? extends VFileEvent> events) {
                Intrinsics.checkNotNullParameter(events, (String)"events");
                this.onEvents(events, false);
            }

            public void after(@NotNull List<? extends VFileEvent> events) {
                Intrinsics.checkNotNullParameter(events, (String)"events");
                this.onEvents(events, true);
            }

            private final boolean isRelevant(VFileEvent event) {
                boolean bl;
                VFileEvent vFileEvent = event;
                if (vFileEvent instanceof VFilePropertyChangeEvent) {
                    bl = false;
                } else if (vFileEvent instanceof VFileCreateEvent) {
                    bl = true;
                } else if (vFileEvent instanceof VFileMoveEvent) {
                    bl = true;
                } else if (vFileEvent instanceof VFileDeleteEvent) {
                    bl = true;
                } else if (vFileEvent instanceof VFileContentChangeEvent) {
                    bl = true;
                } else if (vFileEvent instanceof VFileCopyEvent) {
                    bl = true;
                } else {
                    KotlinPackageContentModificationListener.Companion.getLOG().warn("Unknown vfs event: " + event.getClass());
                    bl = false;
                }
                return bl;
            }

            /*
             * WARNING - void declaration
             */
            public final void onEvents(@NotNull List<? extends VFileEvent> events, boolean isAfter) {
                Intrinsics.checkNotNullParameter(events, (String)"events");
                PerModulePackageCacheService service = PerModulePackageCacheService.Companion.getInstance(this.$project);
                PsiManagerEx psiManagerEx = PsiManagerEx.getInstanceEx((Project)this.$project);
                Intrinsics.checkNotNullExpressionValue((Object)psiManagerEx, (String)"PsiManagerEx.getInstanceEx(project)");
                FileManager fileManager = psiManagerEx.getFileManager();
                Intrinsics.checkNotNullExpressionValue((Object)fileManager, (String)"PsiManagerEx.getInstanceEx(project).fileManager");
                FileManager fileManager2 = fileManager;
                if (events.size() >= 1000) {
                    service.onTooComplexChange$kotlin_core();
                } else {
                    void $this$forEach$iv;
                    Sequence sequence = SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)events), (Function1)((Function1)new Function1<VFileEvent, Boolean>(this){

                        public final boolean invoke(@NotNull VFileEvent p1) {
                            Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                            return runActivity.1.access$isRelevant(this.receiver, p1);
                        }
                    })), (Function1)runActivity.onEvents.2.INSTANCE), (Function1)runActivity.onEvents.3.INSTANCE), (Function1)((Function1)new Function1<VFileEvent, Boolean>(isAfter, fileManager2){
                        final /* synthetic */ boolean $isAfter;
                        final /* synthetic */ FileManager $fileManager;

                        public final boolean invoke(@NotNull VFileEvent it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            return it instanceof VFileContentChangeEvent ? this.$isAfter && this.$fileManager.findCachedViewProvider(((VFileContentChangeEvent)it).getFile()) == null : true;
                        }
                        {
                            this.$isAfter = bl;
                            this.$fileManager = fileManager;
                            super(1);
                        }
                    })), (Function1)((Function1)new Function1<VFileEvent, Boolean>(this){
                        final /* synthetic */ runActivity.1 this$0;

                        public final boolean invoke(@NotNull VFileEvent it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            Object origin = it.getRequestor();
                            return origin instanceof Project ? Intrinsics.areEqual((Object)origin, (Object)this.this$0.$project) : (origin instanceof PsiManager ? Intrinsics.areEqual((Object)((PsiManager)origin).getProject(), (Object)this.this$0.$project) : true);
                        }
                        {
                            this.this$0 = var1_1;
                            super(1);
                        }
                    }));
                    boolean $i$f$forEach = false;
                    for (E element$iv : $this$forEach$iv) {
                        VFileEvent event = (VFileEvent)element$iv;
                        boolean bl = false;
                        service.notifyPackageChange$kotlin_core(event);
                    }
                }
            }
            {
                this.$project = $captured_local_variable$0;
            }

            public static final /* synthetic */ boolean access$isRelevant(runActivity.1 $this, VFileEvent event) {
                return $this.isRelevant(event);
            }
        });
        connection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(project){
            final /* synthetic */ Project $project;

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                PerModulePackageCacheService.Companion.getInstance(this.$project).onTooComplexChange$kotlin_core();
            }
            {
                this.$project = $captured_local_variable$0;
            }
        });
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(Companion.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(this::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/caches/KotlinPackageContentModificationListener$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "kotlin.core"})
    public static final class Companion {
        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

