/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.android;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.android.AndroidJpsUtil;
import org.jetbrains.jps.builders.AdditionalRootsProviderService;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.java.JavaModuleBuildTargetType;
import org.jetbrains.jps.builders.java.JavaSourceRootDescriptor;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.model.module.JpsModule;

public class AndroidAdditionalRootProviderService
extends AdditionalRootsProviderService<JavaSourceRootDescriptor> {
    public AndroidAdditionalRootProviderService() {
        super(Collections.singletonList(JavaModuleBuildTargetType.PRODUCTION));
    }

    @NotNull
    public List<JavaSourceRootDescriptor> getAdditionalRoots(@NotNull BuildTarget<JavaSourceRootDescriptor> target, BuildDataPaths dataPaths) {
        ModuleBuildTarget buildTarget = (ModuleBuildTarget)target;
        JpsModule module = buildTarget.getModule();
        if (AndroidJpsUtil.getExtension(module) == null) {
            return Collections.emptyList();
        }
        File generatedSourcesRoot = AndroidJpsUtil.getGeneratedSourcesStorage(module, dataPaths);
        ArrayList<JavaSourceRootDescriptor> result = new ArrayList<JavaSourceRootDescriptor>();
        AndroidAdditionalRootProviderService.addRoot(result, buildTarget, new File(generatedSourcesRoot, "aapt"));
        AndroidAdditionalRootProviderService.addRoot(result, buildTarget, new File(generatedSourcesRoot, "aidl"));
        AndroidAdditionalRootProviderService.addRoot(result, buildTarget, new File(generatedSourcesRoot, "rs"));
        AndroidAdditionalRootProviderService.addRoot(result, buildTarget, new File(generatedSourcesRoot, "build_config"));
        AndroidAdditionalRootProviderService.addRoot(result, buildTarget, AndroidJpsUtil.getCopiedSourcesStorage(module, dataPaths));
        return result;
    }

    private static void addRoot(List<JavaSourceRootDescriptor> result, ModuleBuildTarget buildTarget, File file) {
        result.add(new JavaSourceRootDescriptor(file, buildTarget, true, false, "", Collections.emptySet()));
    }
}

