/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.core.JavaPsiBundle;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class VisibilityUtil {
    @NonNls
    public static final String ESCALATE_VISIBILITY = "EscalateVisible";
    private static final String[] visibilityModifiers = new String[]{"private", "packageLocal", "protected", "public"};

    private VisibilityUtil() {
    }

    public static int compare(@PsiModifier.ModifierConstant String v1, @PsiModifier.ModifierConstant String v2) {
        return ArrayUtilRt.find((Object[])visibilityModifiers, (Object)v2) - ArrayUtilRt.find((Object[])visibilityModifiers, (Object)v1);
    }

    @PsiModifier.ModifierConstant
    public static String getHighestVisibility(@PsiModifier.ModifierConstant String v1, @PsiModifier.ModifierConstant String v2) {
        return VisibilityUtil.compare(v1, v2) < 0 ? v1 : v2;
    }

    public static void escalateVisibility(PsiMember modifierListOwner, PsiElement place) throws IncorrectOperationException {
        String modifier;
        int index;
        String visibilityModifier = VisibilityUtil.getVisibilityModifier(modifierListOwner.getModifierList());
        for (index = 0; index < visibilityModifiers.length && !(modifier = visibilityModifiers[index]).equals(visibilityModifier); ++index) {
        }
        while (index < visibilityModifiers.length && !PsiUtil.isAccessible(modifierListOwner, place, null)) {
            modifier = visibilityModifiers[index];
            PsiUtil.setModifierProperty(modifierListOwner, modifier, true);
            ++index;
        }
    }

    public static void escalateVisibility(PsiModifierList modifierList, PsiElement place) throws IncorrectOperationException {
        PsiElement parent = modifierList.getParent();
        if (parent instanceof PsiMember) {
            VisibilityUtil.escalateVisibility((PsiMember)parent, place);
        }
    }

    @PsiModifier.ModifierConstant
    public static String getPossibleVisibility(PsiMember psiMethod, PsiElement place) {
        Project project = psiMethod.getProject();
        if (PsiUtil.isAccessible(project, psiMethod, place, null)) {
            return VisibilityUtil.getVisibilityModifier(psiMethod.getModifierList());
        }
        if (JavaPsiFacade.getInstance(project).arePackagesTheSame(psiMethod, place)) {
            return "packageLocal";
        }
        if (InheritanceUtil.isInheritorOrSelf((PsiClass)PsiTreeUtil.getParentOfType((PsiElement)place, PsiClass.class), psiMethod.getContainingClass(), true)) {
            return "protected";
        }
        return "public";
    }

    @PsiModifier.ModifierConstant
    @NotNull
    public static String getVisibilityModifier(PsiModifierList list) {
        if (list == null) {
            return "packageLocal";
        }
        for (String modifier : visibilityModifiers) {
            if (!list.hasModifierProperty(modifier)) continue;
            return modifier;
        }
        return "packageLocal";
    }

    @NotNull
    @NonNls
    public static String getVisibilityString(@PsiModifier.ModifierConstant @NotNull String visibilityModifier) {
        if ("packageLocal".equals(visibilityModifier)) {
            return "";
        }
        return visibilityModifier;
    }

    @Nls
    @NotNull
    public static String getVisibilityStringToDisplay(@NotNull PsiMember member) {
        if (member.hasModifierProperty("public")) {
            return VisibilityUtil.toPresentableText("public");
        }
        if (member.hasModifierProperty("protected")) {
            return VisibilityUtil.toPresentableText("protected");
        }
        if (member.hasModifierProperty("private")) {
            return VisibilityUtil.toPresentableText("private");
        }
        return VisibilityUtil.toPresentableText("packageLocal");
    }

    @NotNull
    public static String toPresentableText(@PsiModifier.ModifierConstant @NotNull String modifier) {
        return JavaPsiBundle.visibilityPresentation(modifier);
    }

    public static void fixVisibility(PsiElement[] elements, PsiMember member, @PsiModifier.ModifierConstant String newVisibility) {
        if (newVisibility == null) {
            return;
        }
        if (ESCALATE_VISIBILITY.equals(newVisibility)) {
            for (PsiElement element : elements) {
                if (element == null) continue;
                VisibilityUtil.escalateVisibility(member, element);
            }
        } else {
            VisibilityUtil.setVisibility(member.getModifierList(), newVisibility);
        }
    }

    public static void setVisibility(@NotNull PsiModifierList modifierList, @PsiModifier.ModifierConstant @NotNull String newVisibility) throws IncorrectOperationException {
        PsiClass containingClass;
        PsiMethod method;
        modifierList.setModifierProperty(newVisibility, true);
        if (newVisibility.equals("private")) {
            modifierList.setModifierProperty("default", false);
        } else if (newVisibility.equals("public") && !modifierList.hasExplicitModifier("static") && (method = (PsiMethod)ObjectUtils.tryCast((Object)modifierList.getParent(), PsiMethod.class)) != null && (containingClass = method.getContainingClass()) != null && containingClass.isInterface()) {
            modifierList.setModifierProperty("default", true);
        }
    }

    public static void fixVisibility(PsiExpression[] expressions, PsiMember member, String newVisibility) {
        if (newVisibility == null) {
            return;
        }
        if (ESCALATE_VISIBILITY.equals(newVisibility)) {
            for (PsiExpression element : expressions) {
                VisibilityUtil.escalateVisibility(member, (PsiElement)element);
            }
        } else {
            VisibilityUtil.setVisibility(member.getModifierList(), newVisibility);
        }
    }
}

