/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.AnnotationInvocationHandler;
import com.intellij.codeInsight.AnnotationTargetUtil;
import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.codeInsight.InferredAnnotationsManager;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConstantEvaluationHelper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.BitUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Stream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnnotationUtil {
    public static final String NULLABLE = "org.jetbrains.annotations.Nullable";
    public static final String NOT_NULL = "org.jetbrains.annotations.NotNull";
    public static final String NON_NLS = "org.jetbrains.annotations.NonNls";
    public static final String NLS = "org.jetbrains.annotations.Nls";
    public static final String PROPERTY_KEY = "org.jetbrains.annotations.PropertyKey";
    public static final String PROPERTY_KEY_RESOURCE_BUNDLE_PARAMETER = "resourceBundle";
    public static final String TEST_ONLY = "org.jetbrains.annotations.TestOnly";
    public static final String LANGUAGE = "org.intellij.lang.annotations.Language";
    public static final int CHECK_HIERARCHY = 1;
    public static final int CHECK_EXTERNAL = 2;
    public static final int CHECK_INFERRED = 4;
    public static final int CHECK_TYPE = 8;
    private static final String[] SIMPLE_NAMES = new String[]{"NotNull", "Nullable", "NonNls", "PropertyKey", "TestOnly", "Language", "Identifier", "Pattern", "PrintFormat", "RegExp", "Subst"};

    @Nullable
    public static PsiAnnotation findAnnotation(@Nullable PsiModifierListOwner listOwner, String ... annotationNames) {
        return AnnotationUtil.findAnnotation(listOwner, false, annotationNames);
    }

    @Nullable
    public static PsiAnnotation findAnnotation(@Nullable PsiModifierListOwner listOwner, boolean skipExternal, String ... annotationNames) {
        if (annotationNames.length == 0) {
            return null;
        }
        HashSet set = annotationNames.length == 1 ? Collections.singleton(annotationNames[0]) : ContainerUtil.newHashSet((Object[])annotationNames);
        return AnnotationUtil.findAnnotation(listOwner, set, skipExternal);
    }

    @Nullable
    public static PsiAnnotation findAnnotation(@Nullable PsiModifierListOwner listOwner, @NotNull Set<String> annotationNames) {
        return AnnotationUtil.findAnnotation(listOwner, annotationNames);
    }

    @Nullable
    public static PsiAnnotation findAnnotation(@Nullable PsiModifierListOwner listOwner, @NotNull Collection<String> annotationNames) {
        return AnnotationUtil.findAnnotation(listOwner, annotationNames, false);
    }

    @Nullable
    public static PsiAnnotation findAnnotation(@Nullable PsiModifierListOwner listOwner, @NotNull Collection<String> annotationNames, boolean skipExternal) {
        if (listOwner == null) {
            return null;
        }
        List<PsiAnnotation> result = AnnotationUtil.findAllAnnotations(listOwner, annotationNames, skipExternal);
        return result.isEmpty() ? null : result.get(0);
    }

    @NotNull
    public static List<PsiAnnotation> findAllAnnotations(@NotNull PsiModifierListOwner listOwner, @NotNull Collection<String> annotationNames, boolean skipExternal) {
        List<PsiAnnotation> ownAnnotations = AnnotationUtil.findOwnAnnotations(listOwner, annotationNames);
        List<PsiAnnotation> nonCodeAnnotations = skipExternal ? null : AnnotationUtil.findNonCodeAnnotations(listOwner, annotationNames);
        SmartList annotations = null;
        if (ownAnnotations != null || nonCodeAnnotations != null) {
            annotations = new SmartList();
            if (ownAnnotations != null) {
                annotations.addAll(ownAnnotations);
            }
            if (nonCodeAnnotations != null) {
                annotations.addAll(nonCodeAnnotations);
            }
        }
        return annotations == null ? Collections.emptyList() : annotations;
    }

    @Nullable
    private static List<PsiAnnotation> findOwnAnnotations(@NotNull PsiModifierListOwner listOwner, @NotNull Collection<String> annotationNames) {
        PsiModifierList list = listOwner.getModifierList();
        if (list == null) {
            return null;
        }
        List result = null;
        for (PsiAnnotation annotation : list.getAnnotations()) {
            if (!ContainerUtil.exists(annotationNames, annotation::hasQualifiedName) || !AnnotationUtil.isApplicableToDeclaration(annotation, list)) continue;
            if (result == null) {
                result = new SmartList();
            }
            result.add(annotation);
        }
        return result;
    }

    private static boolean isApplicableToDeclaration(PsiAnnotation annotation, PsiModifierList list) {
        PsiAnnotation.TargetType[] allTargets = AnnotationTargetUtil.getTargetsForLocation(list);
        if (allTargets.length == 0) {
            return true;
        }
        PsiAnnotation.TargetType[] nonTypeUse = (PsiAnnotation.TargetType[])Stream.of(allTargets).filter(t -> t != PsiAnnotation.TargetType.TYPE_USE).toArray(PsiAnnotation.TargetType[]::new);
        return AnnotationTargetUtil.findAnnotationTarget(annotation, nonTypeUse) != null;
    }

    @Nullable
    private static List<PsiAnnotation> findNonCodeAnnotations(@NotNull PsiModifierListOwner listOwner, @NotNull Collection<String> annotationNames) {
        if (listOwner instanceof PsiLocalVariable) {
            return null;
        }
        Map map = (Map)CachedValuesManager.getCachedValue((PsiElement)listOwner, () -> {
            ConcurrentMap value = ConcurrentFactoryMap.createMap(annotationNames1 -> {
                PsiUtilCore.ensureValid((PsiElement)listOwner);
                Project project = listOwner.getProject();
                List annotations = null;
                ExternalAnnotationsManager externalAnnotationsManager = ExternalAnnotationsManager.getInstance(project);
                for (String annotationName : annotationNames1) {
                    List<PsiAnnotation> externalAnnotations = externalAnnotationsManager.findExternalAnnotations(listOwner, annotationName);
                    if (externalAnnotations.isEmpty()) continue;
                    if (annotations == null) {
                        annotations = new SmartList();
                    }
                    annotations.addAll(externalAnnotations);
                }
                InferredAnnotationsManager inferredAnnotationsManager = InferredAnnotationsManager.getInstance(project);
                for (String annotationName : annotationNames1) {
                    PsiAnnotation annotation = inferredAnnotationsManager.findInferredAnnotation(listOwner, annotationName);
                    if (annotation == null) continue;
                    if (annotations == null) {
                        annotations = new SmartList();
                    }
                    annotations.add(annotation);
                }
                return annotations;
            });
            return CachedValueProvider.Result.create((Object)value, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
        return (List)map.get(annotationNames);
    }

    public static PsiAnnotation @NotNull [] findAnnotations(@Nullable PsiModifierListOwner modifierListOwner, @NotNull Collection<String> annotationNames) {
        if (modifierListOwner == null) {
            return PsiAnnotation.EMPTY_ARRAY;
        }
        PsiModifierList modifierList = modifierListOwner.getModifierList();
        if (modifierList == null) {
            return PsiAnnotation.EMPTY_ARRAY;
        }
        PsiAnnotation[] annotations = modifierList.getAnnotations();
        ArrayList<PsiAnnotation> result = null;
        for (PsiAnnotation psiAnnotation : annotations) {
            if (!annotationNames.contains(psiAnnotation.getQualifiedName())) continue;
            if (result == null) {
                result = new ArrayList<PsiAnnotation>();
            }
            result.add(psiAnnotation);
        }
        return result == null ? PsiAnnotation.EMPTY_ARRAY : result.toArray(PsiAnnotation.EMPTY_ARRAY);
    }

    @NotNull
    public static <T extends PsiModifierListOwner> List<T> getSuperAnnotationOwners(@NotNull T element) {
        return (List)CachedValuesManager.getCachedValue(element, () -> {
            List<Object> list;
            LinkedHashSet result = new LinkedHashSet();
            if (element instanceof PsiMethod) {
                if (!element.hasModifierProperty("static")) {
                    AnnotationUtil.collectSuperMethods(result, ((PsiMethod)element).getHierarchicalMethodSignature(), element, JavaPsiFacade.getInstance(element.getProject()).getResolveHelper());
                }
            } else if (element instanceof PsiClass) {
                InheritanceUtil.processSupers((PsiClass)element, false, (Processor<? super PsiClass>)Processors.cancelableCollectProcessor(result));
            } else if (element instanceof PsiParameter) {
                AnnotationUtil.collectSuperParameters(result, (PsiParameter)element);
            }
            if (result.isEmpty()) {
                list = Collections.emptyList();
            } else {
                PsiModifierListOwner[] array = result.toArray(new PsiModifierListOwner[0]);
                list = Arrays.asList(array);
            }
            return CachedValueProvider.Result.create(list, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
    }

    @Nullable
    public static PsiAnnotation findAnnotationInHierarchy(@NotNull PsiModifierListOwner listOwner, @NotNull Set<String> annotationNames) {
        return AnnotationUtil.findAnnotationInHierarchy(listOwner, annotationNames, false);
    }

    @Nullable
    public static PsiAnnotation findAnnotationInHierarchy(@NotNull PsiModifierListOwner listOwner, @NotNull Set<String> annotationNames, boolean skipExternal) {
        PsiAnnotation directAnnotation = AnnotationUtil.findAnnotation(listOwner, annotationNames, skipExternal);
        if (directAnnotation != null) {
            return directAnnotation;
        }
        for (PsiModifierListOwner superOwner : AnnotationUtil.getSuperAnnotationOwners(listOwner)) {
            PsiAnnotation annotation = AnnotationUtil.findAnnotation(superOwner, annotationNames, skipExternal);
            if (annotation == null) continue;
            return annotation;
        }
        return null;
    }

    private static void collectSuperParameters(@NotNull Set<? super PsiModifierListOwner> result, @NotNull PsiParameter parameter) {
        block5: {
            PsiElement scope;
            Consumer forEachSuperMethod;
            block4: {
                PsiElement parent = parameter.getParent();
                if (!(parent instanceof PsiParameterList)) {
                    return;
                }
                int index = ((PsiParameterList)parent).getParameterIndex(parameter);
                forEachSuperMethod = method -> {
                    PsiParameter[] superParameters = method.getParameterList().getParameters();
                    if (index < superParameters.length) {
                        result.add(superParameters[index]);
                    }
                };
                scope = parent.getParent();
                if (!(scope instanceof PsiLambdaExpression)) break block4;
                PsiMethod method2 = LambdaUtil.getFunctionalInterfaceMethod(((PsiLambdaExpression)scope).getFunctionalInterfaceType());
                if (method2 == null) break block5;
                forEachSuperMethod.consume((Object)method2);
                for (PsiMethod superMethod : AnnotationUtil.getSuperAnnotationOwners(method2)) {
                    forEachSuperMethod.consume((Object)superMethod);
                }
                break block5;
            }
            if (scope instanceof PsiMethod) {
                for (PsiMethod superMethod : AnnotationUtil.getSuperAnnotationOwners((PsiMethod)scope)) {
                    forEachSuperMethod.consume((Object)superMethod);
                }
            }
        }
    }

    private static void collectSuperMethods(@NotNull Set<? super PsiModifierListOwner> result, @NotNull HierarchicalMethodSignature signature, @NotNull PsiElement place, @NotNull PsiResolveHelper resolveHelper) {
        for (HierarchicalMethodSignature superSignature : signature.getSuperSignatures()) {
            PsiMethod superMethod = superSignature.getMethod();
            if (!resolveHelper.isAccessible(superMethod, place, null) || !result.add(superMethod)) continue;
            AnnotationUtil.collectSuperMethods(result, superSignature, place, resolveHelper);
        }
    }

    @Contract(value="null, _ -> null")
    @Nullable
    public static PsiAnnotation findAnnotationInTypeHierarchy(@Nullable PsiType type, @NotNull Set<String> qualifiedNames) {
        if (type == null) {
            return null;
        }
        Ref result = Ref.create(null);
        InheritanceUtil.processSuperTypes(type, true, (Processor<? super PsiType>)((Processor)eachType -> {
            for (PsiAnnotation annotation : eachType.getAnnotations()) {
                String qualifiedName = annotation.getQualifiedName();
                if (!qualifiedNames.contains(qualifiedName)) continue;
                result.set((Object)annotation);
                return false;
            }
            return !(eachType instanceof PsiClassType) || PsiUtil.resolveClassInClassTypeOnly(eachType) instanceof PsiTypeParameter;
        }));
        return (PsiAnnotation)result.get();
    }

    public static boolean isAnnotated(@NotNull PsiModifierListOwner listOwner, @NotNull Collection<String> annotations, @Flags int flags) {
        return annotations.stream().anyMatch(annotation -> AnnotationUtil.isAnnotated(listOwner, annotation, flags, null));
    }

    public static boolean isAnnotated(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFqn, @Flags int flags) {
        return AnnotationUtil.isAnnotated(listOwner, annotationFqn, flags, null);
    }

    private static boolean isAnnotated(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFQN, @Flags int flags, @Nullable Set<? super PsiMember> processed) {
        block18: {
            block19: {
                Project project;
                PsiModifierList modifierList = listOwner.getModifierList();
                if (modifierList == null) {
                    return false;
                }
                PsiAnnotation annotation = modifierList.findAnnotation(annotationFQN);
                if (annotation != null) {
                    return true;
                }
                if (BitUtil.isSet((int)flags, (int)8)) {
                    PsiType type = null;
                    if (listOwner instanceof PsiMethod) {
                        type = ((PsiMethod)listOwner).getReturnType();
                    } else if (listOwner instanceof PsiParameter && listOwner.getParent() instanceof PsiParameterList && listOwner.getParent().getParent() instanceof PsiLambdaExpression) {
                        if (((PsiParameter)listOwner).getTypeElement() != null) {
                            type = ((PsiParameter)listOwner).getType();
                        }
                    } else if (listOwner instanceof PsiVariable) {
                        type = ((PsiVariable)listOwner).getType();
                    }
                    if (type != null && type.hasAnnotation(annotationFQN)) {
                        return true;
                    }
                }
                if (BitUtil.isSet((int)flags, (int)2) && ExternalAnnotationsManager.getInstance(project = listOwner.getProject()).findExternalAnnotation(listOwner, annotationFQN) != null) {
                    return true;
                }
                if (BitUtil.isSet((int)flags, (int)4) && InferredAnnotationsManager.getInstance(project = listOwner.getProject()).findInferredAnnotation(listOwner, annotationFQN) != null) {
                    return true;
                }
                if (!BitUtil.isSet((int)flags, (int)1)) break block18;
                if (!(listOwner instanceof PsiMethod)) break block19;
                PsiMethod method = (PsiMethod)listOwner;
                if (processed == null) {
                    processed = new THashSet();
                }
                if (!processed.add((PsiMember)method)) {
                    return false;
                }
                for (PsiMethod superMethod : method.findSuperMethods()) {
                    if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)superMethod, annotationFQN, flags, (Set<? super PsiMember>)processed)) continue;
                    return true;
                }
                break block18;
            }
            if (!(listOwner instanceof PsiClass)) break block18;
            PsiClass clazz = (PsiClass)listOwner;
            if (processed == null) {
                processed = new THashSet();
            }
            if (!processed.add(clazz)) {
                return false;
            }
            for (PsiClass superClass : clazz.getSupers()) {
                if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)superClass, annotationFQN, flags, (Set<? super PsiMember>)processed)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isAnnotatingApplicable(@NotNull PsiElement elt) {
        return AnnotationUtil.isAnnotatingApplicable(elt, NullableNotNullManager.getInstance(elt.getProject()).getDefaultNullable());
    }

    public static boolean isAnnotatingApplicable(@NotNull PsiElement elt, @NotNull String annotationFQN) {
        Project project = elt.getProject();
        return PsiUtil.isLanguageLevel5OrHigher(elt) && JavaPsiFacade.getInstance(project).findClass(annotationFQN, elt.getResolveScope()) != null;
    }

    @Contract(value="null,_ -> false")
    public static boolean checkAnnotatedUsingPatterns(@Nullable PsiModifierListOwner owner, @NotNull Collection<String> annotations) {
        PsiModifierList modList;
        if (owner == null || (modList = owner.getModifierList()) == null) {
            return false;
        }
        ArrayList<String> fqns = null;
        for (String fqn : annotations) {
            boolean isPattern = fqn.endsWith("*");
            if (!isPattern && AnnotationUtil.isAnnotated(owner, fqn, 0)) {
                return true;
            }
            if (!isPattern) continue;
            if (fqns == null) {
                PsiAnnotation[] ownAnnotations;
                fqns = new ArrayList<String>();
                for (PsiAnnotation anno : ownAnnotations = modList.getAnnotations()) {
                    String qName = anno.getQualifiedName();
                    if (qName == null) continue;
                    fqns.add(qName);
                }
                if (fqns.isEmpty()) {
                    return false;
                }
            }
            fqn = fqn.substring(0, fqn.length() - 2);
            for (String annoFQN : fqns) {
                if (!annoFQN.startsWith(fqn)) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static PsiMethod getAnnotationMethod(@NotNull PsiNameValuePair pair) {
        PsiAnnotation annotation = (PsiAnnotation)PsiTreeUtil.getParentOfType((PsiElement)pair.getParent(), PsiAnnotation.class);
        assert (annotation != null);
        String fqn = annotation.getQualifiedName();
        if (fqn == null) {
            return null;
        }
        PsiClass psiClass = JavaPsiFacade.getInstance(pair.getProject()).findClass(fqn, pair.getResolveScope());
        if (psiClass != null && psiClass.isAnnotationType()) {
            String name = pair.getName();
            return (PsiMethod)ArrayUtil.getFirstElement((Object[])psiClass.findMethodsByName(name != null ? name : "value", false));
        }
        return null;
    }

    public static PsiAnnotation @NotNull [] getAllAnnotations(@NotNull PsiModifierListOwner owner, boolean inHierarchy, @Nullable Set<? super PsiModifierListOwner> visited) {
        return AnnotationUtil.getAllAnnotations(owner, inHierarchy, visited, true);
    }

    public static PsiAnnotation @NotNull [] getAllAnnotations(@NotNull PsiModifierListOwner owner, boolean inHierarchy, @Nullable Set<? super PsiModifierListOwner> visited, boolean withInferred) {
        Object[] annotations;
        block11: {
            PsiParameter parameter;
            PsiElement scope;
            block13: {
                block12: {
                    Project project;
                    Object[] externalAnnotations;
                    PsiModifierList list = owner.getModifierList();
                    annotations = PsiAnnotation.EMPTY_ARRAY;
                    if (list != null) {
                        annotations = list.getAnnotations();
                    }
                    if ((externalAnnotations = ExternalAnnotationsManager.getInstance(project = owner.getProject()).findExternalAnnotations(owner)) != null) {
                        annotations = (PsiAnnotation[])ArrayUtil.mergeArrays((Object[])annotations, (Object[])externalAnnotations, PsiAnnotation.ARRAY_FACTORY);
                    }
                    if (withInferred) {
                        Object[] inferredAnnotations = InferredAnnotationsManager.getInstance(project).findInferredAnnotations(owner);
                        annotations = (PsiAnnotation[])ArrayUtil.mergeArrays((Object[])annotations, (Object[])inferredAnnotations, PsiAnnotation.ARRAY_FACTORY);
                    }
                    if (!inHierarchy) break block11;
                    if (!(owner instanceof PsiClass)) break block12;
                    for (PsiClass superClass : ((PsiClass)owner).getSupers()) {
                        if (visited == null) {
                            visited = new THashSet();
                        }
                        if (!visited.add((PsiModifierListOwner)superClass)) continue;
                        annotations = (PsiAnnotation[])ArrayUtil.mergeArrays((Object[])annotations, (Object[])AnnotationUtil.getAllAnnotations(superClass, true, (Set<? super PsiModifierListOwner>)visited, withInferred));
                    }
                    break block11;
                }
                if (!(owner instanceof PsiMethod)) break block13;
                PsiMethod method = (PsiMethod)owner;
                PsiClass aClass = method.getContainingClass();
                if (aClass == null) break block11;
                HierarchicalMethodSignature methodSignature = method.getHierarchicalMethodSignature();
                List<HierarchicalMethodSignature> superSignatures = methodSignature.getSuperSignatures();
                PsiResolveHelper resolveHelper = PsiResolveHelper.SERVICE.getInstance(aClass.getProject());
                for (HierarchicalMethodSignature superSignature : superSignatures) {
                    PsiMethod superMethod = superSignature.getMethod();
                    if (visited == null) {
                        visited = new THashSet();
                    }
                    if (!visited.add(superMethod) || !resolveHelper.isAccessible(superMethod, owner, null)) continue;
                    annotations = (PsiAnnotation[])ArrayUtil.mergeArrays((Object[])annotations, (Object[])AnnotationUtil.getAllAnnotations(superMethod, true, (Set<? super PsiModifierListOwner>)visited, withInferred));
                }
                break block11;
            }
            if (owner instanceof PsiParameter && (scope = (parameter = (PsiParameter)owner).getDeclarationScope()) instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)scope;
                PsiClass aClass = method.getContainingClass();
                PsiElement parent = parameter.getParent();
                if (aClass != null && parent instanceof PsiParameterList) {
                    int index = ((PsiParameterList)parent).getParameterIndex(parameter);
                    HierarchicalMethodSignature methodSignature = method.getHierarchicalMethodSignature();
                    List<HierarchicalMethodSignature> superSignatures = methodSignature.getSuperSignatures();
                    PsiResolveHelper resolveHelper = PsiResolveHelper.SERVICE.getInstance(aClass.getProject());
                    for (HierarchicalMethodSignature superSignature : superSignatures) {
                        PsiParameter[] superParameters;
                        PsiMethod superMethod = superSignature.getMethod();
                        if (visited == null) {
                            visited = new THashSet();
                        }
                        if (!visited.add(superMethod) || !resolveHelper.isAccessible(superMethod, owner, null) || index >= (superParameters = superMethod.getParameterList().getParameters()).length) continue;
                        annotations = (PsiAnnotation[])ArrayUtil.mergeArrays((Object[])annotations, (Object[])AnnotationUtil.getAllAnnotations(superParameters[index], true, (Set<? super PsiModifierListOwner>)visited, withInferred));
                    }
                }
            }
        }
        return annotations;
    }

    public static boolean isInsideAnnotation(@NotNull PsiElement element) {
        for (int level = 0; level < 4; ++level) {
            if (element instanceof PsiNameValuePair) {
                return true;
            }
            if ((element = element.getParent()) != null) continue;
            return false;
        }
        return false;
    }

    public static boolean isInferredAnnotation(@NotNull PsiAnnotation annotation) {
        return InferredAnnotationsManager.getInstance(annotation.getProject()).isInferredAnnotation(annotation);
    }

    public static boolean isExternalAnnotation(@NotNull PsiAnnotation annotation) {
        return ExternalAnnotationsManager.getInstance(annotation.getProject()).isExternalAnnotation(annotation);
    }

    @Nullable
    public static String getStringAttributeValue(@NotNull PsiAnnotation anno, @Nullable String attributeName) {
        PsiAnnotationMemberValue attrValue = anno.findAttributeValue(attributeName);
        return attrValue == null ? null : AnnotationUtil.getStringAttributeValue(attrValue);
    }

    @Nullable
    public static Boolean getBooleanAttributeValue(@NotNull PsiAnnotation anno, @Nullable String attributeName) {
        PsiAnnotationMemberValue attrValue = anno.findAttributeValue(attributeName);
        Object constValue = JavaPsiFacade.getInstance(anno.getProject()).getConstantEvaluationHelper().computeConstantExpression(attrValue);
        return constValue instanceof Boolean ? (Boolean)constValue : null;
    }

    @Nullable
    public static Long getLongAttributeValue(@NotNull PsiAnnotation anno, @Nullable String attributeName) {
        PsiAnnotationMemberValue attrValue = anno.findAttributeValue(attributeName);
        Object constValue = JavaPsiFacade.getInstance(anno.getProject()).getConstantEvaluationHelper().computeConstantExpression(attrValue);
        return constValue instanceof Number ? Long.valueOf(((Number)constValue).longValue()) : null;
    }

    @Nullable
    public static String getDeclaredStringAttributeValue(@NotNull PsiAnnotation anno, @Nullable String attributeName) {
        PsiAnnotationMemberValue attrValue = anno.findDeclaredAttributeValue(attributeName);
        return attrValue == null ? null : AnnotationUtil.getStringAttributeValue(attrValue);
    }

    @Nullable
    public static String getStringAttributeValue(@NotNull PsiAnnotationMemberValue attrValue) {
        PsiConstantEvaluationHelper evaluationHelper = JavaPsiFacade.getInstance(attrValue.getProject()).getConstantEvaluationHelper();
        Object constValue = evaluationHelper.computeConstantExpression(attrValue);
        return constValue instanceof String ? (String)constValue : null;
    }

    @Nullable
    public static <T extends Annotation> T findAnnotationInHierarchy(@NotNull PsiModifierListOwner listOwner, @NotNull Class<T> annotationClass) {
        PsiAnnotation annotation = AnnotationUtil.findAnnotationInHierarchy(listOwner, Collections.singleton(annotationClass.getName()));
        if (annotation == null) {
            return null;
        }
        AnnotationInvocationHandler handler = new AnnotationInvocationHandler(annotationClass, annotation);
        Annotation t = (Annotation)Proxy.newProxyInstance(annotationClass.getClassLoader(), new Class[]{annotationClass}, (InvocationHandler)handler);
        return (T)t;
    }

    @Nullable
    public static PsiNameValuePair findDeclaredAttribute(@NotNull PsiAnnotation annotation, @Nullable(value="null means 'value'") @Nullable(value="null means 'value'") String attributeName) {
        if ("value".equals(attributeName)) {
            attributeName = null;
        }
        for (PsiNameValuePair attribute : annotation.getParameterList().getAttributes()) {
            String name = attribute.getName();
            if (!Objects.equals(name, attributeName) && (attributeName != null || !"value".equals(name))) continue;
            return attribute;
        }
        return null;
    }

    public static boolean equal(@Nullable PsiAnnotation a, @Nullable PsiAnnotation b) {
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return false;
        }
        String name = a.getQualifiedName();
        if (name == null || !name.equals(b.getQualifiedName())) {
            return false;
        }
        THashMap valueMap1 = new THashMap(2);
        THashMap valueMap2 = new THashMap(2);
        if (!AnnotationUtil.fillValueMap(a.getParameterList(), (Map<String, PsiAnnotationMemberValue>)valueMap1) || !AnnotationUtil.fillValueMap(b.getParameterList(), (Map<String, PsiAnnotationMemberValue>)valueMap2) || valueMap1.size() != valueMap2.size()) {
            return false;
        }
        for (Map.Entry entry : valueMap1.entrySet()) {
            if (AnnotationUtil.equal((PsiAnnotationMemberValue)entry.getValue(), (PsiAnnotationMemberValue)valueMap2.get(entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    private static boolean fillValueMap(@NotNull PsiAnnotationParameterList parameterList, @NotNull Map<String, PsiAnnotationMemberValue> valueMap) {
        PsiNameValuePair[] attributes1;
        for (PsiNameValuePair attribute : attributes1 = parameterList.getAttributes()) {
            PsiReference reference = attribute.getReference();
            if (reference == null) {
                return false;
            }
            PsiElement target = reference.resolve();
            if (!(target instanceof PsiAnnotationMethod)) {
                return false;
            }
            PsiAnnotationMethod annotationMethod = (PsiAnnotationMethod)target;
            PsiAnnotationMemberValue defaultValue = annotationMethod.getDefaultValue();
            PsiAnnotationMemberValue value = attribute.getValue();
            if (AnnotationUtil.equal(value, defaultValue)) continue;
            String name1 = attribute.getName();
            valueMap.put(name1 == null ? "value" : name1, value);
        }
        return true;
    }

    public static boolean equal(@Nullable PsiAnnotationMemberValue value1, @Nullable PsiAnnotationMemberValue value2) {
        if (value1 instanceof PsiArrayInitializerMemberValue && value2 instanceof PsiArrayInitializerMemberValue) {
            PsiAnnotationMemberValue[] initializers2;
            PsiAnnotationMemberValue[] initializers1 = ((PsiArrayInitializerMemberValue)value1).getInitializers();
            if (initializers1.length != (initializers2 = ((PsiArrayInitializerMemberValue)value2).getInitializers()).length) {
                return false;
            }
            for (int i = 0; i < initializers1.length; ++i) {
                if (AnnotationUtil.equal(initializers1[i], initializers2[i])) continue;
                return false;
            }
            return true;
        }
        if (value1 != null && value2 != null) {
            PsiConstantEvaluationHelper constantEvaluationHelper = JavaPsiFacade.getInstance(value1.getProject()).getConstantEvaluationHelper();
            Object const1 = constantEvaluationHelper.computeConstantExpression(value1);
            Object const2 = constantEvaluationHelper.computeConstantExpression(value2);
            return const1 != null && const1.equals(const2);
        }
        return false;
    }

    public static boolean equal(PsiAnnotation @NotNull [] annotations1, PsiAnnotation @NotNull [] annotations2) {
        Map<String, PsiAnnotation> map1 = AnnotationUtil.buildAnnotationMap(annotations1);
        Map<String, PsiAnnotation> map2 = AnnotationUtil.buildAnnotationMap(annotations2);
        if (map1.size() != map2.size()) {
            return false;
        }
        for (Map.Entry<String, PsiAnnotation> entry : map1.entrySet()) {
            if (AnnotationUtil.equal(entry.getValue(), map2.get(entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private static Map<String, PsiAnnotation> buildAnnotationMap(PsiAnnotation @NotNull [] annotations) {
        HashMap<String, PsiAnnotation> map = new HashMap<String, PsiAnnotation>();
        for (PsiAnnotation annotation : annotations) {
            map.put(annotation.getQualifiedName(), annotation);
        }
        map.remove("java.lang.Override");
        map.remove("java.lang.SuppressWarnings");
        return map;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    public static boolean isJetbrainsAnnotation(@NotNull String simpleName) {
        return ArrayUtil.find((Object[])SIMPLE_NAMES, (Object)simpleName) != -1;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    public static boolean isAnnotated(@NotNull PsiModifierListOwner listOwner, @NotNull Collection<String> annotations) {
        return AnnotationUtil.isAnnotated(listOwner, annotations, 8);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    public static boolean isAnnotated(@NotNull PsiModifierListOwner listOwner, @NotNull Collection<String> annotations, boolean checkHierarchy) {
        return AnnotationUtil.isAnnotated(listOwner, annotations, AnnotationUtil.flags(checkHierarchy, true, true));
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    public static boolean isAnnotated(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFQN, boolean checkHierarchy) {
        return AnnotationUtil.isAnnotated(listOwner, annotationFQN, AnnotationUtil.flags(checkHierarchy, true, true));
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    public static boolean isAnnotated(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFQN, boolean checkHierarchy, boolean skipExternal) {
        return AnnotationUtil.isAnnotated(listOwner, annotationFQN, AnnotationUtil.flags(checkHierarchy, skipExternal, skipExternal));
    }

    @Flags
    private static int flags(boolean checkHierarchy, boolean skipExternal, boolean skipInferred) {
        int flags = 8;
        if (checkHierarchy) {
            flags |= 1;
        }
        if (!skipExternal) {
            flags |= 2;
        }
        if (!skipInferred) {
            flags |= 4;
        }
        return flags;
    }

    @NotNull
    public static List<PsiAnnotationMemberValue> arrayAttributeValues(@Nullable PsiAnnotationMemberValue attributeValue) {
        if (attributeValue instanceof PsiArrayInitializerMemberValue) {
            return Arrays.asList(((PsiArrayInitializerMemberValue)attributeValue).getInitializers());
        }
        return ContainerUtil.createMaybeSingletonList((Object)attributeValue);
    }

    @Target(value={ElementType.PARAMETER, ElementType.METHOD})
    private static @interface Flags {
    }
}

