/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.plugins.idea;

import androidx.compose.plugins.idea.ComposeErrors;
import androidx.compose.plugins.idea.ComposeFqNamesKt;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.container.DslKt;
import org.jetbrains.kotlin.container.StorageComponentContainer;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.extensions.StorageComponentContainerContributor;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.jvm.JvmPlatformKt;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016\u00a8\u0006\u0019"}, d2={"Landroidx/compose/plugins/idea/ComposableDeclarationChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "Lorg/jetbrains/kotlin/extensions/StorageComponentContainerContributor;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "checkFunction", "Lorg/jetbrains/kotlin/psi/KtFunction;", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "checkProperty", "Lorg/jetbrains/kotlin/psi/KtProperty;", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "registerModuleComponents", "container", "Lorg/jetbrains/kotlin/container/StorageComponentContainer;", "platform", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "intellij.android.compose-ide-plugin"})
public final class ComposableDeclarationChecker
implements DeclarationChecker,
StorageComponentContainerContributor {
    public void registerModuleComponents(@NotNull StorageComponentContainer container, @NotNull TargetPlatform platform, @NotNull ModuleDescriptor moduleDescriptor) {
        Intrinsics.checkParameterIsNotNull((Object)container, (String)"container");
        Intrinsics.checkParameterIsNotNull((Object)platform, (String)"platform");
        Intrinsics.checkParameterIsNotNull((Object)moduleDescriptor, (String)"moduleDescriptor");
        if (!JvmPlatformKt.isJvm((TargetPlatform)platform)) {
            return;
        }
        DslKt.useInstance((StorageComponentContainer)container, (Object)this);
    }

    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor, @NotNull DeclarationCheckerContext context) {
        block2: {
            KtDeclaration ktDeclaration;
            block1: {
                Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                Intrinsics.checkParameterIsNotNull((Object)descriptor, (String)"descriptor");
                Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
                if (!ComposeFqNamesKt.hasComposableAnnotation((Annotated)descriptor)) {
                    return;
                }
                ktDeclaration = declaration;
                if (!(ktDeclaration instanceof KtProperty)) break block1;
                this.checkProperty((KtProperty)declaration, (PropertyDescriptor)descriptor, context);
                break block2;
            }
            if (!(ktDeclaration instanceof KtFunction)) break block2;
            this.checkFunction((KtFunction)declaration, (FunctionDescriptor)descriptor, context);
        }
    }

    private final void checkFunction(KtFunction declaration, FunctionDescriptor descriptor, DeclarationCheckerContext context) {
        if (descriptor.isSuspend()) {
            BindingTrace bindingTrace = context.getTrace();
            PsiElement psiElement = declaration.getNameIdentifier();
            if (psiElement == null) {
                psiElement = (PsiElement)declaration;
            }
            bindingTrace.report((Diagnostic)ComposeErrors.COMPOSABLE_SUSPEND_FUN.on(psiElement));
        }
    }

    private final void checkProperty(KtProperty declaration, PropertyDescriptor descriptor, DeclarationCheckerContext context) {
        KtExpression initializer = declaration.getInitializer();
        PsiElement name = declaration.getNameIdentifier();
        if (initializer != null && name != null) {
            context.getTrace().report((Diagnostic)ComposeErrors.COMPOSABLE_PROPERTY_BACKING_FIELD.on(name));
        }
        if (descriptor.isVar() && name != null) {
            context.getTrace().report((Diagnostic)ComposeErrors.COMPOSABLE_VAR.on(name));
        }
    }
}

