/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sh.run;

import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.Platform;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PtyCommandLine;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.process.KillableProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.sh.ShStringUtil;
import com.intellij.sh.run.ShBeforeRunProviderDelegate;
import com.intellij.sh.run.ShRunConfiguration;
import com.intellij.sh.run.ShRunner;
import com.intellij.terminal.TerminalExecutionConsole;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.io.BaseDataReader;
import com.intellij.util.io.BaseOutputReader;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShRunConfigurationProfileState
implements RunProfileState {
    private final Project myProject;
    private final ShRunConfiguration myRunConfiguration;

    public ShRunConfigurationProfileState(@NotNull Project project, @NotNull ShRunConfiguration runConfiguration) {
        this.myProject = project;
        this.myRunConfiguration = runConfiguration;
    }

    @Nullable
    public ExecutionResult execute(Executor executor, @NotNull ProgramRunner<?> runner) throws ExecutionException {
        ShRunner shRunner = (ShRunner)ServiceManager.getService((Project)this.myProject, ShRunner.class);
        if (shRunner == null || !shRunner.isAvailable(this.myProject) || this.isRunBeforeConfig()) {
            return this.buildExecutionResult();
        }
        shRunner.run(this.buildCommand(), this.myRunConfiguration.getScriptWorkingDirectory(), this.myRunConfiguration.getName());
        return null;
    }

    private ExecutionResult buildExecutionResult() throws ExecutionException {
        GeneralCommandLine commandLine = this.createCommandLine();
        ProcessHandler processHandler = ShRunConfigurationProfileState.createProcessHandler(commandLine);
        ProcessTerminatedListener.attach((ProcessHandler)processHandler);
        TerminalExecutionConsole console = new TerminalExecutionConsole(this.myProject, processHandler);
        console.attachToProcess(processHandler);
        return new DefaultExecutionResult((ExecutionConsole)console, processHandler);
    }

    @NotNull
    private static ProcessHandler createProcessHandler(GeneralCommandLine commandLine) throws ExecutionException {
        return new KillableProcessHandler(commandLine){

            @NotNull
            protected BaseOutputReader.Options readerOptions() {
                return new BaseOutputReader.Options(){

                    public BaseDataReader.SleepingPolicy policy() {
                        return BaseDataReader.SleepingPolicy.BLOCKING;
                    }

                    public boolean splitToLines() {
                        return false;
                    }

                    public boolean withSeparators() {
                        return true;
                    }
                };
            }
        };
    }

    @NotNull
    private GeneralCommandLine createCommandLine() throws ExecutionException {
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(this.myRunConfiguration.getScriptPath());
        if (virtualFile == null || virtualFile.getParent() == null) {
            throw new ExecutionException("Cannot determine shell script parent directory");
        }
        WSLDistribution wslDistribution = ShRunConfiguration.getWSLDistributionIfNeeded(this.myRunConfiguration.getInterpreterPath(), this.myRunConfiguration.getScriptPath());
        PtyCommandLine commandLine = new PtyCommandLine();
        if (!SystemInfo.isWindows || wslDistribution != null) {
            commandLine.getEnvironment().put("TERM", "xterm-256color");
        }
        commandLine.withConsoleMode(false);
        commandLine.withInitialColumns(120);
        commandLine.withParentEnvironmentType(GeneralCommandLine.ParentEnvironmentType.CONSOLE);
        commandLine.setWorkDirectory(ShRunConfigurationProfileState.convertToWslIfNeeded(this.myRunConfiguration.getScriptWorkingDirectory(), wslDistribution));
        commandLine.setExePath(this.myRunConfiguration.getInterpreterPath());
        if (StringUtil.isNotEmpty((String)this.myRunConfiguration.getInterpreterOptions())) {
            commandLine.addParameters(ParametersListUtil.parse((String)this.myRunConfiguration.getInterpreterOptions()));
        }
        commandLine.addParameter(ShRunConfigurationProfileState.convertToWslIfNeeded(this.myRunConfiguration.getScriptPath(), wslDistribution));
        if (StringUtil.isNotEmpty((String)this.myRunConfiguration.getScriptOptions())) {
            commandLine.addParameters(ParametersListUtil.parse((String)this.myRunConfiguration.getScriptOptions()));
        }
        if (wslDistribution != null) {
            commandLine = (PtyCommandLine)wslDistribution.patchCommandLine((GeneralCommandLine)commandLine, this.myProject, null, false);
        }
        return commandLine;
    }

    private boolean isRunBeforeConfig() {
        Key<Boolean> userDataKey = ShBeforeRunProviderDelegate.getRunBeforeUserDataKey((RunConfiguration)this.myRunConfiguration);
        Boolean userDataValue = (Boolean)this.myProject.getUserData(userDataKey);
        boolean isRunBeforeConfig = userDataValue != null && userDataValue != false;
        this.myRunConfiguration.getProject().putUserData(userDataKey, (Object)false);
        return isRunBeforeConfig;
    }

    @NotNull
    private String buildCommand() {
        WSLDistribution wslDistribution = ShRunConfiguration.getWSLDistributionIfNeeded(this.myRunConfiguration.getInterpreterPath(), this.myRunConfiguration.getScriptPath());
        ArrayList<String> commandLine = new ArrayList<String>();
        ShRunConfigurationProfileState.addIfPresent(commandLine, ShRunConfigurationProfileState.adaptPathForExecution(this.myRunConfiguration.getInterpreterPath(), null));
        ShRunConfigurationProfileState.addIfPresent(commandLine, this.myRunConfiguration.getInterpreterOptions());
        commandLine.add(ShRunConfigurationProfileState.adaptPathForExecution(this.myRunConfiguration.getScriptPath(), wslDistribution));
        ShRunConfigurationProfileState.addIfPresent(commandLine, this.myRunConfiguration.getScriptOptions());
        if (wslDistribution != null) {
            return wslDistribution.patchCommandLine(new GeneralCommandLine(commandLine), this.myProject, wslDistribution.getWslPath(this.myRunConfiguration.getScriptWorkingDirectory()), false).getCommandLineString();
        }
        return String.join((CharSequence)" ", commandLine);
    }

    private static void addIfPresent(@NotNull List<String> commandLine, @Nullable String options) {
        ContainerUtil.addIfNotNull(commandLine, (Object)StringUtil.nullize((String)options));
    }

    private static String adaptPathForExecution(@NotNull String systemDependentPath, @Nullable WSLDistribution wslDistribution) {
        if (wslDistribution != null) {
            return ShStringUtil.quote(wslDistribution.getWslPath(systemDependentPath));
        }
        if (Platform.current() != Platform.WINDOWS) {
            return ShStringUtil.quote(systemDependentPath);
        }
        String escapedPath = StringUtil.escapeQuotes((String)systemDependentPath);
        return StringUtil.containsWhitespaces((CharSequence)systemDependentPath) ? (String)StringUtil.QUOTER.fun((Object)escapedPath) : escapedPath;
    }

    private static String convertToWslIfNeeded(@NotNull String path, @Nullable WSLDistribution wslDistribution) {
        return wslDistribution != null ? wslDistribution.getWslPath(path) : path;
    }
}

