/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sh.run;

import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.RefactoringListenerProvider;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WSLUtil;
import com.intellij.openapi.application.Experiments;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.listeners.RefactoringElementAdapter;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.sh.ShSupport;
import com.intellij.sh.psi.ShFile;
import com.intellij.sh.run.ShRunConfigurationEditor;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShRunConfiguration
extends LocatableConfigurationBase
implements RefactoringListenerProvider {
    @NonNls
    private static final String TAG_PREFIX = "INDEPENDENT_";
    @NonNls
    private static final String SCRIPT_PATH_TAG = "SCRIPT_PATH";
    @NonNls
    private static final String SCRIPT_OPTIONS_TAG = "SCRIPT_OPTIONS";
    @NonNls
    private static final String SCRIPT_WORKING_DIRECTORY_TAG = "SCRIPT_WORKING_DIRECTORY";
    @NonNls
    private static final String INTERPRETER_PATH_TAG = "INTERPRETER_PATH";
    @NonNls
    private static final String INTERPRETER_OPTIONS_TAG = "INTERPRETER_OPTIONS";
    private String myScriptPath = "";
    private String myScriptOptions = "";
    private String myInterpreterPath = "";
    private String myInterpreterOptions = "";
    private String myScriptWorkingDirectory = "";

    ShRunConfiguration(@NotNull Project project, @NotNull ConfigurationFactory factory, @NotNull String name) {
        super(project, factory, name);
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        return new ShRunConfigurationEditor(this.getProject());
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        if (!FileUtil.exists((String)this.myScriptPath)) {
            throw new RuntimeConfigurationError("Shell script not found");
        }
        if (!FileUtil.exists((String)this.myScriptWorkingDirectory)) {
            throw new RuntimeConfigurationError("Working directory not found");
        }
        if (StringUtil.isNotEmpty((String)this.myInterpreterPath) || !new File(this.myScriptPath).canExecute()) {
            if (this.myInterpreterPath.endsWith("sh") && ShRunConfiguration.getWSLDistributionIfNeeded() != null) {
                return;
            }
            if (!FileUtil.exists((String)this.myInterpreterPath)) {
                throw new RuntimeConfigurationError("Interpreter not found");
            }
            if (!new File(this.myInterpreterPath).canExecute()) {
                throw new RuntimeConfigurationError("Interpreter should be executable file");
            }
        }
    }

    @Nullable
    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment environment) {
        return ShSupport.getInstance().createRunProfileState(executor, environment, this);
    }

    public void writeExternal(@NotNull Element element) {
        super.writeExternal(element);
        ShRunConfiguration.writePathWithMetadata(element, this.myScriptPath, SCRIPT_PATH_TAG);
        JDOMExternalizerUtil.writeField((Element)element, (String)SCRIPT_OPTIONS_TAG, (String)this.myScriptOptions);
        ShRunConfiguration.writePathWithMetadata(element, this.myScriptWorkingDirectory, SCRIPT_WORKING_DIRECTORY_TAG);
        ShRunConfiguration.writePathWithMetadata(element, this.myInterpreterPath, INTERPRETER_PATH_TAG);
        JDOMExternalizerUtil.writeField((Element)element, (String)INTERPRETER_OPTIONS_TAG, (String)this.myInterpreterOptions);
    }

    public void readExternal(@NotNull Element element) throws InvalidDataException {
        super.readExternal(element);
        this.myScriptPath = ShRunConfiguration.readPathWithMetadata(element, SCRIPT_PATH_TAG);
        this.myScriptOptions = ShRunConfiguration.readStringTagValue(element, SCRIPT_OPTIONS_TAG);
        this.myScriptWorkingDirectory = ShRunConfiguration.readPathWithMetadata(element, SCRIPT_WORKING_DIRECTORY_TAG);
        this.myInterpreterPath = ShRunConfiguration.readPathWithMetadata(element, INTERPRETER_PATH_TAG);
        this.myInterpreterOptions = ShRunConfiguration.readStringTagValue(element, INTERPRETER_OPTIONS_TAG);
    }

    @Nullable
    public RefactoringElementListener getRefactoringElementListener(PsiElement element) {
        if (StringUtil.isEmpty((String)this.myScriptPath) || !(element instanceof ShFile) || !this.myScriptPath.equals(ShRunConfiguration.getPathByElement(element))) {
            return null;
        }
        return new RefactoringElementAdapter(){

            protected void elementRenamedOrMoved(@NotNull PsiElement newElement) {
                if (newElement instanceof ShFile) {
                    ShRunConfiguration.this.setScriptPath(((ShFile)newElement).getVirtualFile().getPath());
                }
            }

            public void undoElementMovedOrRenamed(@NotNull PsiElement newElement, @NotNull String oldQualifiedName) {
                this.elementRenamedOrMoved(newElement);
            }
        };
    }

    @Nullable
    private static String getPathByElement(@NotNull PsiElement element) {
        VirtualFile vfile = PsiUtilCore.getVirtualFile((PsiElement)element);
        if (vfile == null) {
            return null;
        }
        return vfile.getPath();
    }

    private static void writePathWithMetadata(@NotNull Element element, @NotNull String path, @NotNull String pathTag) {
        String systemIndependentPath = FileUtil.toSystemIndependentName((String)path);
        JDOMExternalizerUtil.writeField((Element)element, (String)(TAG_PREFIX + pathTag), (String)Boolean.toString(systemIndependentPath.equals(path)));
        JDOMExternalizerUtil.writeField((Element)element, (String)pathTag, (String)systemIndependentPath);
    }

    private static String readPathWithMetadata(@NotNull Element element, @NotNull String pathTag) {
        return Boolean.parseBoolean(JDOMExternalizerUtil.readField((Element)element, (String)(TAG_PREFIX + pathTag))) ? ShRunConfiguration.readStringTagValue(element, pathTag) : FileUtil.toSystemDependentName((String)ShRunConfiguration.readStringTagValue(element, pathTag));
    }

    @NotNull
    private static String readStringTagValue(@NotNull Element element, @NotNull String tagName) {
        return StringUtilRt.notNullize((String)JDOMExternalizerUtil.readField((Element)element, (String)tagName), (String)"");
    }

    public String getScriptPath() {
        return this.myScriptPath;
    }

    public void setScriptPath(@NotNull String scriptPath) {
        this.myScriptPath = scriptPath.trim();
    }

    public String getScriptOptions() {
        return this.myScriptOptions;
    }

    public void setScriptOptions(@NotNull String scriptOptions) {
        this.myScriptOptions = scriptOptions.trim();
    }

    public String getScriptWorkingDirectory() {
        return this.myScriptWorkingDirectory;
    }

    public void setScriptWorkingDirectory(String scriptWorkingDirectory) {
        this.myScriptWorkingDirectory = scriptWorkingDirectory.trim();
    }

    public String getInterpreterPath() {
        return this.myInterpreterPath;
    }

    public void setInterpreterPath(@NotNull String interpreterPath) {
        this.myInterpreterPath = interpreterPath.trim();
    }

    public String getInterpreterOptions() {
        return this.myInterpreterOptions;
    }

    public void setInterpreterOptions(@NotNull String interpreterOptions) {
        this.myInterpreterOptions = interpreterOptions.trim();
    }

    private static WSLDistribution getWSLDistributionIfNeeded() {
        return ShRunConfiguration.getWSLDistributionIfNeeded(null, null);
    }

    public static WSLDistribution getWSLDistributionIfNeeded(@Nullable String interpreterPath, @Nullable String scriptPath) {
        if (!Experiments.getInstance().isFeatureEnabled("com.intellij.sh.run.with.wsl")) {
            return null;
        }
        if (interpreterPath != null && new File(interpreterPath).canExecute() || scriptPath != null && (scriptPath.endsWith("cmd") || scriptPath.endsWith("bat"))) {
            return null;
        }
        if (EnvironmentUtil.getValue((String)"SHELL") != null) {
            return null;
        }
        return (WSLDistribution)ContainerUtil.getFirstItem((List)WSLUtil.getAvailableDistributions());
    }
}

