/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sh.formatter;

import com.intellij.formatting.Block;
import com.intellij.formatting.FormattingDocumentModel;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.formatting.Spacing;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.FormattingDocumentModelImpl;
import com.intellij.psi.formatter.common.AbstractBlock;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShFormatterModelBuilder
implements FormattingModelBuilder {
    @NotNull
    public FormattingModel createModel(PsiElement element, CodeStyleSettings settings) {
        return ShFormatterModelBuilder.createDumbModel(element);
    }

    @NotNull
    private static FormattingModel createDumbModel(@NotNull PsiElement element) {
        final AbstractBlock block = new AbstractBlock(element.getNode(), null, null){

            protected List<Block> buildChildren() {
                return EMPTY;
            }

            @Nullable
            public Spacing getSpacing(@Nullable Block child1, @NotNull Block child2) {
                return null;
            }

            public boolean isLeaf() {
                return false;
            }
        };
        final Document document = FormattingDocumentModelImpl.createOn((PsiFile)element.getContainingFile()).getDocument();
        final FormattingDocumentModel model = new FormattingDocumentModel(){

            public int getLineNumber(int offset) {
                return document.getLineNumber(offset);
            }

            public int getLineStartOffset(int line) {
                return document.getLineStartOffset(line);
            }

            @NotNull
            public CharSequence getText(TextRange textRange) {
                return document.getText(textRange);
            }

            public int getTextLength() {
                return document.getTextLength();
            }

            @NotNull
            public Document getDocument() {
                return document;
            }

            public boolean containsWhiteSpaceSymbolsOnly(int startOffset, int endOffset) {
                return false;
            }

            @NotNull
            public CharSequence adjustWhiteSpaceIfNecessary(@NotNull CharSequence whiteSpaceText, int startOffset, int endOffset, ASTNode nodeAfter, boolean changedViaPsi) {
                return whiteSpaceText;
            }
        };
        return new FormattingModel(){

            @NotNull
            public Block getRootBlock() {
                return block;
            }

            @NotNull
            public FormattingDocumentModel getDocumentModel() {
                return model;
            }

            public TextRange replaceWhiteSpace(TextRange textRange, String whiteSpace) {
                return textRange;
            }

            public TextRange shiftIndentInsideRange(ASTNode node, TextRange range, int indent) {
                return range;
            }

            public void commitChanges() {
            }
        };
    }
}

