/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sh;

import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.IntroduceTargetChooser;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.sh.ShBundle;
import com.intellij.sh.psi.ShCommand;
import com.intellij.sh.psi.ShCommandsList;
import com.intellij.sh.psi.ShCompositeElement;
import com.intellij.sh.psi.ShFile;
import com.intellij.sh.statistics.ShFeatureUsagesCollector;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ShExplainShellIntention
extends BaseIntentionAction {
    private static final Logger LOG = Logger.getInstance(ShExplainShellIntention.class);
    @NonNls
    private static final String FEATURE_ACTION_ID = "ExplainShellUsed";

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @NotNull
    public String getText() {
        return ShBundle.message("sh.explain.inspection.text", new Object[0]);
    }

    public boolean startInWriteAction() {
        return false;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        Caret caret;
        int offset;
        PsiElement at;
        if (!(file instanceof ShFile)) {
            return false;
        }
        SelectionModel selectionModel = editor.getSelectionModel();
        if (selectionModel.hasSelection()) {
            String selectedText = selectionModel.getSelectedText();
            if (StringUtil.isEmptyOrSpaces((String)selectedText)) {
                return false;
            }
            if (selectedText.trim().contains("\n")) {
                return false;
            }
        }
        if ((at = file.findElementAt(offset = (caret = editor.getCaretModel().getPrimaryCaret()).getOffset())) == null) {
            return false;
        }
        return !(at instanceof LeafPsiElement) || !(at.getParent() instanceof ShFile);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        String selectedText = editor.getSelectionModel().getSelectedText();
        if (selectedText != null) {
            ShExplainShellIntention.explain(selectedText.trim());
        } else {
            HashSet strings;
            Caret caret = editor.getCaretModel().getPrimaryCaret();
            int offset = caret.getOffset();
            PsiElement at = file.findElementAt(offset);
            List parents = at == null ? Collections.emptyList() : PsiTreeUtil.collectParents((PsiElement)at, ShCompositeElement.class, (boolean)true, psiElement -> psiElement.getText().contains("\n"));
            List commands = ContainerUtil.filter((Collection)parents, arg_0 -> ShExplainShellIntention.lambda$invoke$1(strings = new HashSet(), arg_0));
            if (commands.isEmpty()) {
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)ShBundle.message("sh.explain.nothing.to.explain", new Object[0]), (String)ShBundle.message("sh.explain.nothing.to.explain", new Object[0]), (String)"");
            } else {
                IntroduceTargetChooser.showChooser((Editor)editor, (List)commands, (Pass)new Pass<PsiElement>(){

                    public void pass(@NotNull PsiElement psiElement) {
                        ShExplainShellIntention.explain(psiElement.getText());
                    }
                }, PsiElement::getText, (String)ShBundle.message("sh.explain.command.to.explain", new Object[0]));
            }
            ShFeatureUsagesCollector.logFeatureUsage(FEATURE_ACTION_ID);
        }
    }

    private static void explain(@NotNull String text) {
        String encodedText = text;
        try {
            encodedText = URLEncoder.encode(text, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOG.warn("Couldn't encode " + text + " for explainshell URL", (Throwable)e);
        }
        BrowserUtil.browse((String)("https://explainshell.com/explain?cmd=" + encodedText));
    }

    private static /* synthetic */ boolean lambda$invoke$1(Set strings, ShCompositeElement e) {
        return (e instanceof ShCommand || e instanceof ShCommandsList) && strings.add(e.getText());
    }
}

