/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.inject.config;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import org.intellij.plugins.intelliLang.inject.config.BaseInjection;
import org.intellij.plugins.intelliLang.inject.config.XPathSupportProxy;
import org.intellij.plugins.intelliLang.util.StringMatcher;
import org.jaxen.JaxenException;
import org.jaxen.XPath;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractTagInjection
extends BaseInjection {
    private static final Logger LOG = Logger.getInstance(AbstractTagInjection.class);
    @NotNull
    @NonNls
    private StringMatcher myTagName = StringMatcher.ANY;
    @NotNull
    @NonNls
    private Set<String> myTagNamespace = Collections.emptySet();
    @NotNull
    @NonNls
    private String myXPathCondition = "";
    private volatile Condition<XmlElement> myCompiledXPathCondition;
    private boolean myApplyToSubTags;

    public AbstractTagInjection() {
        super("xml");
    }

    @NotNull
    public String getTagName() {
        return this.myTagName.getPattern();
    }

    public void setTagName(@NotNull @NonNls String tagName) {
        this.myTagName = StringMatcher.create(tagName);
    }

    @Override
    public boolean acceptsPsiElement(PsiElement element) {
        return super.acceptsPsiElement(element) && (!(element instanceof XmlElement) || this.matchXPath((XmlElement)element));
    }

    @NotNull
    public String getTagNamespace() {
        return StringUtil.join(this.myTagNamespace, (String)"|");
    }

    public void setTagNamespace(@NotNull @NonNls String tagNamespace) {
        this.myTagNamespace = new TreeSet<String>(StringUtil.split((String)tagNamespace, (String)"|"));
    }

    @NotNull
    public String getXPathCondition() {
        return this.myXPathCondition;
    }

    public void setXPathCondition(@Nullable String condition) {
        this.myXPathCondition = StringUtil.notNullize((String)condition);
        this.myCompiledXPathCondition = null;
    }

    private Condition<XmlElement> compileXPath() {
        if (StringUtil.isEmptyOrSpaces((String)this.myXPathCondition)) {
            return Conditions.alwaysTrue();
        }
        try {
            XPathSupportProxy xPathSupport = XPathSupportProxy.getInstance();
            if (xPathSupport != null) {
                XPath path = xPathSupport.createXPath(this.myXPathCondition);
                return context -> {
                    try {
                        return path.booleanValueOf(context);
                    }
                    catch (JaxenException e) {
                        LOG.warn((Throwable)e);
                        this.myCompiledXPathCondition = Conditions.alwaysFalse();
                        return false;
                    }
                };
            }
        }
        catch (JaxenException e) {
            LOG.warn("Invalid XPath expression", (Throwable)e);
        }
        return Conditions.alwaysFalse();
    }

    protected boolean matches(@Nullable XmlTag tag) {
        if (tag == null) {
            return false;
        }
        if (!this.myTagName.matches(tag.getLocalName())) {
            return false;
        }
        return this.myTagNamespace.contains(tag.getNamespace());
    }

    @Override
    public abstract AbstractTagInjection copy();

    @Override
    public AbstractTagInjection copyFrom(@NotNull BaseInjection o) {
        super.copyFrom(o);
        if (o instanceof AbstractTagInjection) {
            AbstractTagInjection other = (AbstractTagInjection)o;
            this.myTagName = other.myTagName;
            this.myTagNamespace = other.myTagNamespace;
            this.setXPathCondition(other.getXPathCondition());
            this.setApplyToSubTags(other.isApplyToSubTags());
        }
        return this;
    }

    @Override
    protected void readExternalImpl(Element e) {
        this.setXPathCondition(e.getChildText("xpath-condition"));
        this.myApplyToSubTags = e.getChild("apply-to-subtags") != null;
    }

    @Override
    protected void writeExternalImpl(Element e) {
        if (StringUtil.isNotEmpty((String)this.myXPathCondition)) {
            e.addContent(new Element("xpath-condition").setText(this.myXPathCondition));
        }
        if (this.myApplyToSubTags) {
            e.addContent(new Element("apply-to-subtags"));
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AbstractTagInjection that = (AbstractTagInjection)o;
        if (!this.myTagName.equals(that.myTagName)) {
            return false;
        }
        if (!this.myTagNamespace.equals(that.myTagNamespace)) {
            return false;
        }
        if (!this.myXPathCondition.equals(that.myXPathCondition)) {
            return false;
        }
        return this.myApplyToSubTags == that.myApplyToSubTags;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.myTagName.hashCode();
        result = 31 * result + this.myTagNamespace.hashCode();
        result = 31 * result + this.myXPathCondition.hashCode();
        result = 31 * result + (this.myApplyToSubTags ? 1 : 0);
        return result;
    }

    boolean matchXPath(XmlElement context) {
        Condition<XmlElement> compiled = this.myCompiledXPathCondition;
        if (compiled == null) {
            this.myCompiledXPathCondition = compiled = this.compileXPath();
        }
        return compiled.value((Object)context);
    }

    public boolean isApplyToSubTags() {
        return this.myApplyToSubTags;
    }

    public void setApplyToSubTags(boolean applyToSubTagTexts) {
        this.myApplyToSubTags = applyToSubTagTexts;
    }

    @Override
    public boolean acceptForReference(PsiElement element) {
        if (element instanceof XmlAttributeValue) {
            PsiElement parent = element.getParent();
            return parent instanceof XmlAttribute && this.acceptsPsiElement(parent);
        }
        return element instanceof XmlTag && this.acceptsPsiElement(element);
    }
}

