/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.inject;

import com.intellij.lang.Language;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Trinity;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import java.util.Collections;
import java.util.List;
import org.intellij.plugins.intelliLang.inject.InjectedLanguage;
import org.intellij.plugins.intelliLang.inject.InjectorUtils;
import org.intellij.plugins.intelliLang.inject.TemporaryPlacesRegistry;
import org.jetbrains.annotations.NotNull;

public final class TemporaryPlacesInjector
implements MultiHostInjector {
    public static final Logger LOG = Logger.getInstance(TemporaryPlacesInjector.class);

    @NotNull
    public List<? extends Class<? extends PsiElement>> elementsToInjectIn() {
        return Collections.singletonList(PsiLanguageInjectionHost.class);
    }

    public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement context) {
        Language language;
        PsiFile containingFile;
        if (!(context instanceof PsiLanguageInjectionHost) || !((PsiLanguageInjectionHost)context).isValidHost()) {
            return;
        }
        PsiLanguageInjectionHost host = (PsiLanguageInjectionHost)context;
        TemporaryPlacesRegistry registry = TemporaryPlacesRegistry.getInstance(host.getProject());
        InjectedLanguage injectedLanguage = registry.getLanguageFor(host, containingFile = context.getContainingFile());
        Language language2 = language = injectedLanguage != null ? injectedLanguage.getLanguage() : null;
        if (language == null) {
            return;
        }
        ElementManipulator manipulator = ElementManipulators.getManipulator((PsiElement)host);
        if (manipulator == null) {
            return;
        }
        List<Trinity> trinities = Collections.singletonList(Trinity.create((Object)host, (Object)injectedLanguage, (Object)manipulator.getRangeInElement((PsiElement)host)));
        InjectorUtils.registerInjection(language, trinities, containingFile, registrar);
        InjectorUtils.registerSupport(registry.getLanguageInjectionSupport(), false, context, language);
    }
}

