/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.extensions.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.BaseExtensionPointName;
import com.intellij.openapi.extensions.DefaultPluginDescriptor;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.extensions.impl.BeanExtensionPoint;
import com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import com.intellij.openapi.extensions.impl.InterfaceExtensionPoint;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ThreeState;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ExtensionsAreaImpl
implements ExtensionsArea {
    private static final Logger LOG = Logger.getInstance(ExtensionsAreaImpl.class);
    private static final boolean DEBUG_REGISTRATION = false;
    private final ComponentManager componentManager;
    private final Map<String, ExtensionPointImpl<?>> extensionPoints = new ConcurrentHashMap();
    private final Map<String, Throwable> epTraces = null;

    public ExtensionsAreaImpl(@NotNull ComponentManager componentManager) {
        this.componentManager = componentManager;
    }

    public final void notifyAreaReplaced(@Nullable ExtensionsAreaImpl newArea) {
        HashSet<String> processedEPs = new HashSet<String>(this.extensionPoints.size());
        for (ExtensionPointImpl<?> point : this.extensionPoints.values()) {
            point.notifyAreaReplaced(this);
            processedEPs.add(point.getName());
        }
        if (newArea == null) {
            return;
        }
        for (ExtensionPointImpl<?> point : newArea.extensionPoints.values()) {
            if (processedEPs.contains(point.getName())) continue;
            point.notifyAreaReplaced(this);
        }
    }

    public void registerExtensionPoints(@NotNull PluginDescriptor pluginDescriptor, @NotNull List<Element> extensionPointElements) {
        for (Element element : extensionPointElements) {
            this.registerExtensionPoint(pluginDescriptor, element);
        }
    }

    private void registerExtensionPoint(@NotNull PluginDescriptor pluginDescriptor, @NotNull Element extensionPointElement) {
        String pointName = this.getExtensionPointName(extensionPointElement, pluginDescriptor);
        String beanClassName = extensionPointElement.getAttributeValue("beanClass");
        String interfaceClassName = extensionPointElement.getAttributeValue("interface");
        if (beanClassName == null && interfaceClassName == null) {
            throw this.componentManager.createError("Neither 'beanClass' nor 'interface' attribute is specified for extension point '" + pointName + "' in '" + pluginDescriptor + "' plugin", pluginDescriptor.getPluginId());
        }
        if (beanClassName != null && interfaceClassName != null) {
            throw this.componentManager.createError("Both 'beanClass' and 'interface' attributes are specified for extension point '" + pointName + "' in '" + pluginDescriptor + "' plugin", pluginDescriptor.getPluginId());
        }
        boolean dynamic = Boolean.parseBoolean(extensionPointElement.getAttributeValue("dynamic"));
        String className = interfaceClassName == null ? beanClassName : interfaceClassName;
        this.doRegisterExtensionPoint(pointName, className, pluginDescriptor, interfaceClassName != null, dynamic);
    }

    @NotNull
    private String getExtensionPointName(@NotNull Element extensionPointElement, @NotNull PluginDescriptor pluginDescriptor) {
        String pointName = extensionPointElement.getAttributeValue("qualifiedName");
        if (pointName == null) {
            String name = extensionPointElement.getAttributeValue("name");
            if (name == null) {
                throw this.componentManager.createError("'name' attribute not specified for extension point in '" + pluginDescriptor + "' plugin", pluginDescriptor.getPluginId());
            }
            assert (pluginDescriptor.getPluginId() != null);
            pointName = pluginDescriptor.getPluginId().getIdString() + '.' + name;
        }
        return pointName;
    }

    @Override
    public void registerExtension(@NotNull PluginDescriptor pluginDescriptor, @NotNull Element extensionElement, String extensionNs) {
        String epName = ExtensionsAreaImpl.extractPointName(extensionElement, extensionNs);
        this.registerExtension(this.getExtensionPoint(epName), pluginDescriptor, extensionElement);
    }

    @Override
    public void registerExtension(@NotNull ExtensionPoint<?> extensionPoint, @NotNull PluginDescriptor pluginDescriptor, @NotNull Element extensionElement) {
        ((ExtensionPointImpl)extensionPoint).createAndRegisterAdapter(extensionElement, pluginDescriptor, this.componentManager);
    }

    public boolean unregisterExtensions(@NotNull String extensionPointName, @NotNull PluginDescriptor loadedPluginDescriptor, @NotNull List<Element> elements, @NotNull List<Runnable> priorityListenerCallbacks, @NotNull List<Runnable> listenerCallbacks) {
        ExtensionPointImpl<?> point = this.extensionPoints.get(extensionPointName);
        if (point == null) {
            return false;
        }
        point.unregisterExtensions(this.componentManager, loadedPluginDescriptor, elements, priorityListenerCallbacks, listenerCallbacks);
        return true;
    }

    public void resetExtensionPoints(@NotNull List<ExtensionPointImpl<?>> rawExtensionPoints) {
        for (ExtensionPointImpl<?> point : rawExtensionPoints) {
            ExtensionPointImpl<?> extensionPoint = this.extensionPoints.get(point.getName());
            if (extensionPoint == null) continue;
            extensionPoint.reset();
        }
    }

    public void clearUserCache() {
        this.extensionPoints.values().forEach(ExtensionPointImpl::clearUserCache);
    }

    public void unregisterExtensionPoints(@NotNull List<ExtensionPointImpl<?>> rawExtensionPoints) {
        for (ExtensionPointImpl<?> point : rawExtensionPoints) {
            this.extensionPoints.remove(point.getName());
        }
    }

    @NotNull
    public static String extractPointName(@NotNull Element extensionElement, @Nullable String ns) {
        String epName = extensionElement.getAttributeValue("point");
        if (epName == null) {
            if (ns == null) {
                Namespace namespace = extensionElement.getNamespace();
                epName = namespace.getURI() + '.' + extensionElement.getName();
            } else {
                epName = ns + '.' + extensionElement.getName();
            }
        }
        return epName;
    }

    @Override
    public void registerExtensionPoint(@NotNull @NonNls String extensionPointName, @NotNull String extensionPointBeanClass, @NotNull ExtensionPoint.Kind kind) {
        this.doRegisterExtensionPoint(extensionPointName, extensionPointBeanClass, kind);
    }

    public void registerExtensionPoint(@NotNull BaseExtensionPointName<?> extensionPoint, @NotNull String extensionPointBeanClass, @NotNull ExtensionPoint.Kind kind, @NotNull Disposable parentDisposable) {
        String extensionPointName = extensionPoint.getName();
        this.doRegisterExtensionPoint(extensionPointName, extensionPointBeanClass, kind);
        Disposer.register((Disposable)parentDisposable, () -> this.unregisterExtensionPoint(extensionPointName));
    }

    void doRegisterExtensionPoint(@NotNull String extensionPointName, @NotNull String extensionPointBeanClass, @NotNull ExtensionPoint.Kind kind) {
        DefaultPluginDescriptor pluginDescriptor = new DefaultPluginDescriptor(PluginId.getId("FakeIdForTests"));
        this.doRegisterExtensionPoint(extensionPointName, extensionPointBeanClass, pluginDescriptor, kind == ExtensionPoint.Kind.INTERFACE, false);
    }

    public <T> ExtensionPointImpl<T> registerPoint(@NotNull String name, @NotNull Class<T> extensionClass, @NotNull PluginDescriptor pluginDescriptor) {
        return this.doRegisterExtensionPoint(name, extensionClass.getName(), pluginDescriptor, extensionClass.isInterface() || (extensionClass.getModifiers() & 0x400) != 0, false);
    }

    @NotNull
    private <T> ExtensionPointImpl<T> doRegisterExtensionPoint(@NotNull String name, @NotNull String extensionClass, @NotNull PluginDescriptor pluginDescriptor, boolean isInterface, boolean dynamic) {
        ExtensionPointImpl point = isInterface ? new InterfaceExtensionPoint(name, extensionClass, pluginDescriptor, dynamic) : new BeanExtensionPoint(name, extensionClass, pluginDescriptor, dynamic);
        point.setComponentManager(this.componentManager);
        this.registerExtensionPoint(point);
        return point;
    }

    public <T> ExtensionPointImpl<T> registerFakeBeanPoint(@NotNull String name, @NotNull PluginDescriptor pluginDescriptor) {
        return this.doRegisterExtensionPoint(name, Object.class.getName(), pluginDescriptor, false, false);
    }

    private void checkThatPointNotDuplicated(@NotNull String pointName, @NotNull PluginDescriptor pluginDescriptor) {
        if (!this.hasExtensionPoint(pointName)) {
            return;
        }
        PluginId id1 = ((ExtensionPointImpl)this.getExtensionPoint(pointName)).getPluginDescriptor().getPluginId();
        PluginId id2 = pluginDescriptor.getPluginId();
        String message = "Duplicate registration for EP '" + pointName + "': first in " + id1 + ", second in " + id2;
        throw this.componentManager.createError(message, pluginDescriptor.getPluginId());
    }

    private void registerExtensionPoint(@NotNull ExtensionPointImpl<?> point) {
        String name = point.getName();
        this.checkThatPointNotDuplicated(name, point.getPluginDescriptor());
        this.extensionPoints.put(name, point);
    }

    @ApiStatus.Internal
    public void registerExtensionPoints(@NotNull List<? extends ExtensionPointImpl<?>> points, boolean clonePoint) {
        ComponentManager componentManager = this.componentManager;
        Map<String, ExtensionPointImpl<?>> map = this.extensionPoints;
        for (ExtensionPointImpl<?> point : points) {
            ExtensionPointImpl<?> old;
            if (clonePoint) {
                point = point.cloneFor(componentManager);
            } else {
                point.setComponentManager(componentManager);
            }
            if ((old = map.put(point.getName(), point)) == null) continue;
            map.put(point.getName(), old);
            throw componentManager.createError("Duplicate registration for EP '" + point.getName() + "': first in " + old.getPluginDescriptor() + ", second in " + point.getPluginDescriptor(), point.getPluginDescriptor().getPluginId());
        }
    }

    @NotNull
    public <T> ExtensionPointImpl<T> getExtensionPoint(@NotNull String extensionPointName) {
        ExtensionPointImpl<?> extensionPoint = this.extensionPoints.get(extensionPointName);
        if (extensionPoint == null) {
            throw new IllegalArgumentException("Missing extension point: " + extensionPointName + " in container " + this.componentManager);
        }
        return extensionPoint;
    }

    public void registerExtensions(@NotNull Map<String, List<Element>> extensions, @NotNull PluginDescriptor pluginDescriptor, @Nullable List<Runnable> listenerCallbacks) {
        extensions.forEach((name, list) -> {
            ExtensionPointImpl<?> point = this.extensionPoints.get(name);
            if (point != null) {
                point.registerExtensions((List<Element>)list, pluginDescriptor, this.componentManager, listenerCallbacks);
            }
        });
    }

    public boolean registerExtensions(@NotNull String pointName, @NotNull List<Element> extensions, @NotNull PluginDescriptor pluginDescriptor, @Nullable List<Runnable> listenerCallbacks) {
        ExtensionPointImpl<?> point = this.extensionPoints.get(pointName);
        if (point == null) {
            return false;
        }
        point.registerExtensions(extensions, pluginDescriptor, this.componentManager, listenerCallbacks);
        return true;
    }

    @Nullable
    public <T> ExtensionPointImpl<T> getExtensionPointIfRegistered(@NotNull String extensionPointName) {
        return this.extensionPoints.get(extensionPointName);
    }

    @Override
    @NotNull
    public <T> ExtensionPoint<T> getExtensionPoint(@NotNull ExtensionPointName<T> extensionPointName) {
        return this.getExtensionPoint(extensionPointName.getName());
    }

    public void processExtensionPoints(@NotNull Consumer<ExtensionPointImpl<?>> consumer) {
        this.extensionPoints.values().forEach(consumer);
    }

    @Override
    @NotNull
    public List<ExtensionPoint<?>> getExtensionPoints() {
        return Collections.unmodifiableList(new ArrayList(this.extensionPoints.values()));
    }

    @ApiStatus.Internal
    @Nullable
    public <T> T findExtensionByClass(@NotNull Class<T> aClass) {
        if (aClass.getName().equals("com.intellij.execution.executors.DefaultDebugExecutor")) {
            return this.extensionPoints.get("com.intellij.executor").findExtension(aClass, false, ThreeState.YES);
        }
        for (ExtensionPointImpl<?> point : this.extensionPoints.values()) {
            if (!(point instanceof InterfaceExtensionPoint)) continue;
            try {
                T extension;
                Class<T> extensionClass = point.getExtensionClass();
                if (!extensionClass.isAssignableFrom(aClass) || (extension = point.findExtension(aClass, false, ThreeState.YES)) == null) continue;
                return extension;
            }
            catch (Throwable e) {
                LOG.warn("error during findExtensionPointByClass", e);
            }
        }
        return null;
    }

    @Override
    public void unregisterExtensionPoint(@NotNull String extensionPointName) {
        ExtensionPointImpl<?> extensionPoint = this.extensionPoints.get(extensionPointName);
        if (extensionPoint != null) {
            extensionPoint.reset();
            this.extensionPoints.remove(extensionPointName);
        }
    }

    @Override
    public boolean hasExtensionPoint(@NotNull String extensionPointName) {
        return this.extensionPoints.containsKey(extensionPointName);
    }

    @Override
    public boolean hasExtensionPoint(@NotNull ExtensionPointName<?> extensionPointName) {
        return this.hasExtensionPoint(extensionPointName.getName());
    }

    public String toString() {
        return this.componentManager.toString();
    }
}

