/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0010\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B'\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0000J\u0006\u0010\u0011\u001a\u00020\u0000J\u000e\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0000J\b\u0010\u0014\u001a\u00020\u0003H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/types/Variance;", "", "label", "", "allowsInPosition", "", "allowsOutPosition", "superpositionFactor", "", "(Ljava/lang/String;ILjava/lang/String;ZZI)V", "getAllowsInPosition", "()Z", "getAllowsOutPosition", "getLabel", "()Ljava/lang/String;", "allowsPosition", "position", "opposite", "superpose", "other", "toString", "INVARIANT", "IN_VARIANCE", "OUT_VARIANCE", "compiler.common"})
public final class Variance
extends Enum<Variance> {
    @NotNull
    private final String label;
    private final boolean allowsInPosition;
    private final boolean allowsOutPosition;
    private final int superpositionFactor;
    public static final /* enum */ Variance INVARIANT = new Variance("", true, true, 0);
    public static final /* enum */ Variance IN_VARIANCE = new Variance("in", true, false, -1);
    public static final /* enum */ Variance OUT_VARIANCE = new Variance("out", false, true, 1);
    private static final /* synthetic */ Variance[] $VALUES;

    private Variance(String label, boolean allowsInPosition, boolean allowsOutPosition, int superpositionFactor) {
        this.label = label;
        this.allowsInPosition = allowsInPosition;
        this.allowsOutPosition = allowsOutPosition;
        this.superpositionFactor = superpositionFactor;
    }

    @NotNull
    public final String getLabel() {
        return this.label;
    }

    public final boolean getAllowsInPosition() {
        return this.allowsInPosition;
    }

    public final boolean getAllowsOutPosition() {
        return this.allowsOutPosition;
    }

    public final boolean allowsPosition(@NotNull Variance position) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)((Object)position), (String)"position");
        Variance variance = position;
        int n = WhenMappings.$EnumSwitchMapping$0[variance.ordinal()];
        switch (n) {
            case 1: {
                bl = this.allowsInPosition;
                break;
            }
            case 2: {
                bl = this.allowsOutPosition;
                break;
            }
            case 3: {
                if (this.allowsInPosition && this.allowsOutPosition) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    @NotNull
    public final Variance superpose(@NotNull Variance other) {
        Variance variance;
        int r;
        Intrinsics.checkNotNullParameter((Object)((Object)other), (String)"other");
        int n = r = this.superpositionFactor * other.superpositionFactor;
        switch (n) {
            case 0: {
                variance = INVARIANT;
                break;
            }
            case -1: {
                variance = IN_VARIANCE;
                break;
            }
            case 1: {
                variance = OUT_VARIANCE;
                break;
            }
            default: {
                throw new IllegalStateException(Intrinsics.stringPlus((String)"Illegal factor: ", (Object)r));
            }
        }
        return variance;
    }

    @NotNull
    public final Variance opposite() {
        Variance variance;
        Variance variance2 = this;
        int n = WhenMappings.$EnumSwitchMapping$0[variance2.ordinal()];
        switch (n) {
            case 3: {
                variance = INVARIANT;
                break;
            }
            case 1: {
                variance = OUT_VARIANCE;
                break;
            }
            case 2: {
                variance = IN_VARIANCE;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return variance;
    }

    @NotNull
    public String toString() {
        return this.label;
    }

    public static Variance[] values() {
        Variance[] varianceArray = $VALUES;
        Variance[] varianceArray2 = new Variance[varianceArray.length];
        System.arraycopy(varianceArray, 0, varianceArray2, 0, varianceArray.length);
        return varianceArray2;
    }

    public static Variance valueOf(String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return Enum.valueOf(Variance.class, value);
    }

    static {
        $VALUES = varianceArray = new Variance[]{Variance.INVARIANT, Variance.IN_VARIANCE, Variance.OUT_VARIANCE};
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Variance.values().length];
            nArray[Variance.IN_VARIANCE.ordinal()] = 1;
            nArray[Variance.OUT_VARIANCE.ordinal()] = 2;
            nArray[Variance.INVARIANT.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

