/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.targets;

import com.intellij.util.Consumer;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.impl.BuildTargetChunk;
import org.jetbrains.jps.cmdline.ProjectDescriptor;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.model.java.JpsJavaClasspathKind;
import org.jetbrains.jps.model.java.JpsJavaDependenciesEnumerator;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.library.JpsLibrary;
import org.jetbrains.jps.model.library.JpsLibraryRoot;
import org.jetbrains.jps.model.library.JpsOrderRootType;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.util.JpsPathUtil;
import org.jetbrains.kotlin.jps.build.JpsUtilKt;
import org.jetbrains.kotlin.jps.build.KotlinBuilder;
import org.jetbrains.kotlin.jps.build.KotlinChunk;
import org.jetbrains.kotlin.jps.build.KotlinCompileContext;
import org.jetbrains.kotlin.jps.model.ModuleSettingsKt;
import org.jetbrains.kotlin.jps.targets.KotlinCommonModuleBuildTarget;
import org.jetbrains.kotlin.jps.targets.KotlinJsModuleBuildTarget;
import org.jetbrains.kotlin.jps.targets.KotlinJvmModuleBuildTarget;
import org.jetbrains.kotlin.jps.targets.KotlinModuleBuildTarget;
import org.jetbrains.kotlin.jps.targets.KotlinTargetsIndex;
import org.jetbrains.kotlin.jps.targets.KotlinUnsupportedModuleBuildTarget;
import org.jetbrains.kotlin.platform.DefaultIdeTargetPlatformKindProvider;
import org.jetbrains.kotlin.platform.IdePlatformKind;
import org.jetbrains.kotlin.platform.IdePlatformKindUtil;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.impl.CommonIdePlatformUtil;
import org.jetbrains.kotlin.platform.impl.JsIdePlatformKind;
import org.jetbrains.kotlin.platform.impl.JsIdePlatformUtil;
import org.jetbrains.kotlin.platform.impl.JvmIdePlatformUtil;
import org.jetbrains.kotlin.utils.LibraryUtils;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u000f\u001a\u00020\u0010J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\bH\u0002J\u0014\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u00182\u0006\u0010\u0019\u001a\u00020\u0007H\u0002J\u0014\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\u0019\u001a\u00020\u0007H\u0002J\u0010\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u0007H\u0002R\u001e\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/jps/targets/KotlinTargetsIndexBuilder;", "", "uninitializedContext", "Lorg/jetbrains/kotlin/jps/build/KotlinCompileContext;", "(Lorg/jetbrains/kotlin/jps/build/KotlinCompileContext;)V", "byJpsModuleBuildTarget", "", "Lorg/jetbrains/jps/incremental/ModuleBuildTarget;", "Lorg/jetbrains/kotlin/jps/targets/KotlinModuleBuildTarget;", "chunks", "", "Lorg/jetbrains/kotlin/jps/build/KotlinChunk;", "isKotlinJsStdlibJar", "", "", "build", "Lorg/jetbrains/kotlin/jps/targets/KotlinTargetsIndex;", "calculateChunkDependencies", "", "calculateTargetDependencies", "", "Lorg/jetbrains/kotlin/jps/targets/KotlinModuleBuildTarget$Dependency;", "srcTarget", "detectTargetPlatform", "Lorg/jetbrains/kotlin/platform/IdePlatformKind;", "target", "ensureLoaded", "hasJsStdLib", "kotlin.jps-plugin"})
public final class KotlinTargetsIndexBuilder {
    private final Map<ModuleBuildTarget, KotlinModuleBuildTarget<?>> byJpsModuleBuildTarget;
    private final Map<String, Boolean> isKotlinJsStdlibJar;
    private final List<KotlinChunk> chunks;
    private final KotlinCompileContext uninitializedContext;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final KotlinTargetsIndex build() {
        Map map;
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        boolean $i$f$measureTimeMillis22 = false;
        boolean bl = false;
        long start$iv = System.currentTimeMillis();
        boolean bl2 = false;
        CompileContext jpsContext = this.uninitializedContext.getJpsContext();
        ProjectDescriptor projectDescriptor = jpsContext.getProjectDescriptor();
        Intrinsics.checkNotNullExpressionValue((Object)projectDescriptor, (String)"jpsContext.projectDescriptor");
        List list = projectDescriptor.getBuildTargetIndex().getSortedTargetChunks(jpsContext);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"jpsContext.projectDescri\u2026dTargetChunks(jpsContext)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$mapNotNullTo$iv$iv;
            BuildTargetChunk chunk = (BuildTargetChunk)element$iv;
            boolean bl3 = false;
            BuildTargetChunk buildTargetChunk = chunk;
            Intrinsics.checkNotNullExpressionValue((Object)buildTargetChunk, (String)"chunk");
            Set set = buildTargetChunk.getTargets();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"chunk.targets");
            Iterable $this$mapNotNull$iv = set;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach2 = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                KotlinModuleBuildTarget<?> kotlinModuleBuildTarget;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl4 = false;
                BuildTarget it = (BuildTarget)element$iv$iv;
                boolean bl5 = false;
                if ((it instanceof ModuleBuildTarget ? this.ensureLoaded((ModuleBuildTarget)it) : null) == null) continue;
                kotlinModuleBuildTarget = kotlinModuleBuildTarget;
                boolean bl6 = false;
                boolean bl7 = false;
                KotlinModuleBuildTarget<?> it$iv$iv = kotlinModuleBuildTarget;
                boolean bl8 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List moduleBuildTargets = (List)destination$iv$iv;
            $this$mapNotNull$iv = moduleBuildTargets;
            $i$f$mapNotNull = false;
            if (!(!$this$mapNotNull$iv.isEmpty())) continue;
            KotlinChunk kotlinChunk = new KotlinChunk(this.uninitializedContext, moduleBuildTargets);
            Iterable $this$forEach$iv2 = moduleBuildTargets;
            boolean $i$f$forEach3 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                KotlinModuleBuildTarget it = (KotlinModuleBuildTarget)element$iv2;
                boolean bl9 = false;
                it.setChunk(kotlinChunk);
            }
            this.chunks.add(kotlinChunk);
        }
        this.calculateChunkDependencies();
        long time = System.currentTimeMillis() - start$iv;
        KotlinBuilder.Companion.getLOG().info("KotlinTargetsIndex created in " + time + " ms");
        Iterable $i$f$measureTimeMillis22 = this.chunks;
        List<KotlinChunk> list2 = this.chunks;
        Map<ModuleBuildTarget, KotlinModuleBuildTarget<?>> map2 = this.byJpsModuleBuildTarget;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        void var6_43 = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            KotlinChunk kotlinChunk = (KotlinChunk)element$iv$iv;
            map = destination$iv$iv;
            boolean bl10 = false;
            ModuleBuildTarget moduleBuildTarget = it.getRepresentativeTarget().getJpsModuleBuildTarget();
            map.put(moduleBuildTarget, element$iv$iv);
        }
        Map map3 = map = destination$iv$iv;
        List<KotlinChunk> list3 = list2;
        Map<ModuleBuildTarget, KotlinModuleBuildTarget<?>> map4 = map2;
        return new KotlinTargetsIndex(map4, list3, map3);
    }

    private final void calculateChunkDependencies() {
        Iterable $this$forEach$iv = this.chunks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KotlinChunk chunk = (KotlinChunk)element$iv;
            boolean bl = false;
            boolean bl2 = false;
            Set dependencies = new LinkedHashSet();
            Iterable $this$forEach$iv2 = chunk.getTargets();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                KotlinModuleBuildTarget it = (KotlinModuleBuildTarget)element$iv2;
                boolean bl3 = false;
                dependencies.addAll((Collection)this.calculateTargetDependencies(it));
            }
            chunk.setDependencies$kotlin_jps_plugin(CollectionsKt.toList((Iterable)dependencies));
            $this$forEach$iv2 = chunk.getDependencies();
            $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                KotlinModuleBuildTarget.Dependency dependency = (KotlinModuleBuildTarget.Dependency)element$iv2;
                boolean bl4 = false;
                Set<KotlinModuleBuildTarget.Dependency> set = dependency.getTarget().getChunk().get_dependent$kotlin_jps_plugin();
                Intrinsics.checkNotNull(set);
                set.add(dependency);
            }
        }
        $this$forEach$iv = this.chunks;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KotlinChunk it = (KotlinChunk)element$iv;
            boolean bl = false;
            Set<KotlinModuleBuildTarget.Dependency> set = it.get_dependent$kotlin_jps_plugin();
            Intrinsics.checkNotNull(set);
            it.setDependent$kotlin_jps_plugin(CollectionsKt.toList((Iterable)set));
            it.set_dependent$kotlin_jps_plugin(null);
        }
    }

    private final List<KotlinModuleBuildTarget.Dependency> calculateTargetDependencies(KotlinModuleBuildTarget<?> srcTarget) {
        KotlinModuleBuildTarget<?> srcProductionTarget;
        boolean bl = false;
        List dependencies = new ArrayList();
        JpsJavaClasspathKind classpathKind = JpsJavaClasspathKind.compile((boolean)srcTarget.isTests());
        boolean bl2 = false;
        Set dependentTargets = new LinkedHashSet();
        JpsJavaExtensionService.dependencies((JpsModule)srcTarget.getModule()).includedIn(classpathKind).processModules((Consumer)new Consumer<JpsModule>(this, srcTarget, dependentTargets){
            final /* synthetic */ KotlinTargetsIndexBuilder this$0;
            final /* synthetic */ KotlinModuleBuildTarget $srcTarget;
            final /* synthetic */ Set $dependentTargets;

            public final void consume(JpsModule destModule) {
                Map map = KotlinTargetsIndexBuilder.access$getByJpsModuleBuildTarget$p(this.this$0);
                JpsModule jpsModule = destModule;
                Intrinsics.checkNotNullExpressionValue((Object)jpsModule, (String)"destModule");
                KotlinModuleBuildTarget destKotlinTarget = (KotlinModuleBuildTarget)map.get(JpsUtilKt.ModuleBuildTarget(jpsModule, this.$srcTarget.isTests()));
                if (destKotlinTarget != null) {
                    this.$dependentTargets.add(destKotlinTarget);
                }
            }
            {
                this.this$0 = kotlinTargetsIndexBuilder;
                this.$srcTarget = kotlinModuleBuildTarget;
                this.$dependentTargets = set;
            }
        });
        JpsJavaExtensionService.dependencies((JpsModule)srcTarget.getModule()).includedIn(classpathKind).exportedOnly().processModules((Consumer)new Consumer<JpsModule>(this, srcTarget, dependentTargets, dependencies){
            final /* synthetic */ KotlinTargetsIndexBuilder this$0;
            final /* synthetic */ KotlinModuleBuildTarget $srcTarget;
            final /* synthetic */ Set $dependentTargets;
            final /* synthetic */ List $dependencies;

            public final void consume(JpsModule module) {
                Map map = KotlinTargetsIndexBuilder.access$getByJpsModuleBuildTarget$p(this.this$0);
                JpsModule jpsModule = module;
                Intrinsics.checkNotNullExpressionValue((Object)jpsModule, (String)"module");
                KotlinModuleBuildTarget destKotlinTarget = (KotlinModuleBuildTarget)map.get(JpsUtilKt.ModuleBuildTarget(jpsModule, this.$srcTarget.isTests()));
                if (destKotlinTarget != null) {
                    this.$dependentTargets.remove(destKotlinTarget);
                    this.$dependencies.add(new KotlinModuleBuildTarget.Dependency(this.$srcTarget, destKotlinTarget, true));
                }
            }
            {
                this.this$0 = kotlinTargetsIndexBuilder;
                this.$srcTarget = kotlinModuleBuildTarget;
                this.$dependentTargets = set;
                this.$dependencies = list;
            }
        });
        Iterable $this$forEach$iv = dependentTargets;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KotlinModuleBuildTarget destTarget = (KotlinModuleBuildTarget)element$iv;
            boolean bl3 = false;
            dependencies.add(new KotlinModuleBuildTarget.Dependency(srcTarget, destTarget, false));
        }
        if (srcTarget.isTests() && (srcProductionTarget = this.byJpsModuleBuildTarget.get(JpsUtilKt.ModuleBuildTarget(srcTarget.getModule(), false))) != null) {
            dependencies.add(new KotlinModuleBuildTarget.Dependency(srcTarget, srcProductionTarget, true));
        }
        return dependencies;
    }

    private final KotlinModuleBuildTarget<?> ensureLoaded(ModuleBuildTarget target) {
        KotlinModuleBuildTarget<?> kotlinModuleBuildTarget = this.byJpsModuleBuildTarget.computeIfAbsent(target, new Function<ModuleBuildTarget, KotlinModuleBuildTarget<?>>(this, target){
            final /* synthetic */ KotlinTargetsIndexBuilder this$0;
            final /* synthetic */ ModuleBuildTarget $target;

            @NotNull
            public final KotlinModuleBuildTarget<?> apply(@NotNull ModuleBuildTarget it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                JpsModule jpsModule = this.$target.getModule();
                Intrinsics.checkNotNullExpressionValue((Object)jpsModule, (String)"target.module");
                Object object = ModuleSettingsKt.getPlatform(jpsModule);
                if (object == null || (object = IdePlatformKindUtil.getIdePlatformKind((TargetPlatform)object)) == null) {
                    object = KotlinTargetsIndexBuilder.access$detectTargetPlatform(this.this$0, this.$target);
                }
                Object platform = object;
                return CommonIdePlatformUtil.isCommon(platform) ? (KotlinModuleBuildTarget)new KotlinCommonModuleBuildTarget(KotlinTargetsIndexBuilder.access$getUninitializedContext$p(this.this$0), this.$target) : (JsIdePlatformUtil.isJavaScript(platform) ? (KotlinModuleBuildTarget)new KotlinJsModuleBuildTarget(KotlinTargetsIndexBuilder.access$getUninitializedContext$p(this.this$0), this.$target) : (JvmIdePlatformUtil.isJvm(platform) ? (KotlinModuleBuildTarget)new KotlinJvmModuleBuildTarget(KotlinTargetsIndexBuilder.access$getUninitializedContext$p(this.this$0), this.$target) : (KotlinModuleBuildTarget)new KotlinUnsupportedModuleBuildTarget(KotlinTargetsIndexBuilder.access$getUninitializedContext$p(this.this$0), this.$target)));
            }
            {
                this.this$0 = kotlinTargetsIndexBuilder;
                this.$target = moduleBuildTarget;
            }
        });
        Intrinsics.checkNotNullExpressionValue(kotlinModuleBuildTarget, (String)"byJpsModuleBuildTarget.c\u2026)\n            }\n        }");
        return kotlinModuleBuildTarget;
    }

    private final IdePlatformKind<?> detectTargetPlatform(ModuleBuildTarget target) {
        if (this.hasJsStdLib(target)) {
            return JsIdePlatformKind.INSTANCE;
        }
        return IdePlatformKindUtil.getIdePlatformKind(DefaultIdeTargetPlatformKindProvider.Companion.getDefaultPlatform());
    }

    private final boolean hasJsStdLib(ModuleBuildTarget target) {
        JpsJavaDependenciesEnumerator jpsJavaDependenciesEnumerator = JpsJavaExtensionService.dependencies((JpsModule)target.getModule()).recursively().exportedOnly().includedIn(JpsJavaClasspathKind.compile((boolean)target.isTests()));
        Intrinsics.checkNotNullExpressionValue((Object)jpsJavaDependenciesEnumerator, (String)"JpsJavaExtensionService.\u2026.compile(target.isTests))");
        Set set = jpsJavaDependenciesEnumerator.getLibraries();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"JpsJavaExtensionService.\u2026))\n            .libraries");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JpsLibrary library = (JpsLibrary)element$iv;
            boolean bl = false;
            Iterator iterator2 = library.getRoots(JpsOrderRootType.COMPILED).iterator();
            while (iterator2.hasNext()) {
                String url;
                JpsLibraryRoot root;
                JpsLibraryRoot jpsLibraryRoot = root = (JpsLibraryRoot)iterator2.next();
                Intrinsics.checkNotNullExpressionValue((Object)jpsLibraryRoot, (String)"root");
                Intrinsics.checkNotNullExpressionValue((Object)jpsLibraryRoot.getUrl(), (String)"root.url");
                Boolean bl2 = this.isKotlinJsStdlibJar.computeIfAbsent(url, new Function<String, Boolean>(url){
                    final /* synthetic */ String $url;

                    @NotNull
                    public final Boolean apply(@NotNull String it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        File file2 = JpsPathUtil.urlToFile((String)this.$url);
                        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"JpsPathUtil.urlToFile(url)");
                        return LibraryUtils.isKotlinJavascriptStdLibrary(file2);
                    }
                    {
                        this.$url = string2;
                    }
                });
                Intrinsics.checkNotNullExpressionValue((Object)bl2, (String)"isKotlinJsStdlibJar.comp\u2026l))\n                    }");
                boolean isKotlinJsLib2 = bl2;
                if (!isKotlinJsLib2) continue;
                return true;
            }
        }
        return false;
    }

    public KotlinTargetsIndexBuilder(@NotNull KotlinCompileContext uninitializedContext) {
        Intrinsics.checkNotNullParameter((Object)uninitializedContext, (String)"uninitializedContext");
        this.uninitializedContext = uninitializedContext;
        boolean bl = false;
        this.byJpsModuleBuildTarget = new LinkedHashMap();
        bl = false;
        this.isKotlinJsStdlibJar = new LinkedHashMap();
        bl = false;
        this.chunks = new ArrayList();
    }

    public static final /* synthetic */ Map access$getByJpsModuleBuildTarget$p(KotlinTargetsIndexBuilder $this) {
        return $this.byJpsModuleBuildTarget;
    }

    public static final /* synthetic */ IdePlatformKind access$detectTargetPlatform(KotlinTargetsIndexBuilder $this, ModuleBuildTarget target) {
        return $this.detectTargetPlatform(target);
    }

    public static final /* synthetic */ KotlinCompileContext access$getUninitializedContext$p(KotlinTargetsIndexBuilder $this) {
        return $this.uninitializedContext;
    }
}

