/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.storage;

import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.IOUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u0001:\u0001\u000eB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0005J\u001e\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0016J&\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0014\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0002H\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/incremental/storage/ConstantsMapExternalizer;", "Lcom/intellij/util/io/DataExternalizer;", "", "", "", "()V", "read", "input", "Ljava/io/DataInput;", "save", "", "output", "Ljava/io/DataOutput;", "map", "Kind", "kotlin-build-common"})
public final class ConstantsMapExternalizer
implements DataExternalizer<Map<String, ? extends Object>> {
    @NotNull
    public static final ConstantsMapExternalizer INSTANCE = new ConstantsMapExternalizer();

    private ConstantsMapExternalizer() {
    }

    public void save(@NotNull DataOutput output, @Nullable Map<String, ? extends Object> map) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNull(map);
        output.writeInt(map.size());
        for (String name : CollectionsKt.sorted((Iterable)map.keySet())) {
            Object value;
            IOUtil.writeString((String)name, (DataOutput)output);
            Object object = map.get(name);
            Intrinsics.checkNotNull((Object)object);
            object = value = object;
            if (object instanceof Integer) {
                output.writeByte(Kind.INT.ordinal());
                output.writeInt(((Number)value).intValue());
                continue;
            }
            if (object instanceof Float) {
                output.writeByte(Kind.FLOAT.ordinal());
                output.writeFloat(((Number)value).floatValue());
                continue;
            }
            if (object instanceof Long) {
                output.writeByte(Kind.LONG.ordinal());
                output.writeLong(((Number)value).longValue());
                continue;
            }
            if (object instanceof Double) {
                output.writeByte(Kind.DOUBLE.ordinal());
                output.writeDouble(((Number)value).doubleValue());
                continue;
            }
            if (object instanceof String) {
                output.writeByte(Kind.STRING.ordinal());
                IOUtil.writeString((String)((String)value), (DataOutput)output);
                continue;
            }
            throw new IllegalStateException(Intrinsics.stringPlus((String)"Unexpected constant class: ", value.getClass()));
        }
    }

    @Nullable
    public Map<String, Object> read(@NotNull DataInput input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        int size = input.readInt();
        HashMap map = new HashMap(size);
        boolean bl = false;
        int n = 0;
        int n2 = size;
        for (n = 0; n < n2; ++n) {
            Object object;
            int it = n;
            boolean bl2 = false;
            String string2 = IOUtil.readString((DataInput)input);
            Intrinsics.checkNotNull((Object)string2);
            String name = string2;
            Kind kind = Kind.values()[input.readByte()];
            Object object2 = kind;
            int n3 = WhenMappings.$EnumSwitchMapping$0[((Enum)object2).ordinal()];
            switch (n3) {
                case 1: {
                    object = input.readInt();
                    break;
                }
                case 2: {
                    object = Float.valueOf(input.readFloat());
                    break;
                }
                case 3: {
                    object = input.readLong();
                    break;
                }
                case 4: {
                    object = input.readDouble();
                    break;
                }
                case 5: {
                    String string3 = IOUtil.readString((DataInput)input);
                    Intrinsics.checkNotNull((Object)string3);
                    object = string3;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            Number value = object;
            object2 = map;
            n3 = 0;
            object2.put(name, value);
        }
        return map;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/incremental/storage/ConstantsMapExternalizer$Kind;", "", "(Ljava/lang/String;I)V", "INT", "FLOAT", "LONG", "DOUBLE", "STRING", "kotlin-build-common"})
    private static final class Kind
    extends Enum<Kind> {
        public static final /* enum */ Kind INT = new Kind();
        public static final /* enum */ Kind FLOAT = new Kind();
        public static final /* enum */ Kind LONG = new Kind();
        public static final /* enum */ Kind DOUBLE = new Kind();
        public static final /* enum */ Kind STRING = new Kind();
        private static final /* synthetic */ Kind[] $VALUES;

        public static Kind[] values() {
            Kind[] kindArray = $VALUES;
            Kind[] kindArray2 = new Kind[kindArray.length];
            System.arraycopy(kindArray, 0, kindArray2, 0, kindArray.length);
            return kindArray2;
        }

        public static Kind valueOf(String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return Enum.valueOf(Kind.class, value);
        }

        static {
            $VALUES = kindArray = new Kind[]{Kind.INT, Kind.FLOAT, Kind.LONG, Kind.DOUBLE, Kind.STRING};
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Kind.values().length];
            nArray[Kind.INT.ordinal()] = 1;
            nArray[Kind.FLOAT.ordinal()] = 2;
            nArray[Kind.LONG.ordinal()] = 3;
            nArray[Kind.DOUBLE.ordinal()] = 4;
            nArray[Kind.STRING.ordinal()] = 5;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

