/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate;

import com.google.common.collect.ImmutableSet;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.debugger.engine.jdi.StackFrameProxy;
import com.intellij.debugger.jdi.LocalVariableProxyImpl;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.testFramework.EdtTestUtilKt;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VirtualMachine;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.eval4j.AbnormalTermination;
import org.jetbrains.eval4j.AbstractValue;
import org.jetbrains.eval4j.Eval;
import org.jetbrains.eval4j.Eval4JInterpretingException;
import org.jetbrains.eval4j.ExceptionThrown;
import org.jetbrains.eval4j.InterpreterLoopKt;
import org.jetbrains.eval4j.InterpreterResult;
import org.jetbrains.eval4j.Value;
import org.jetbrains.eval4j.ValueReturned;
import org.jetbrains.eval4j.ValuesKt;
import org.jetbrains.eval4j.jdi.JDIEval;
import org.jetbrains.eval4j.jdi.JdiValuesKt;
import org.jetbrains.kotlin.analyzer.AnalysisResult;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactoryWithPsiElement;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.jetbrains.kotlin.diagnostics.UnboundDiagnostic;
import org.jetbrains.kotlin.diagnostics.rendering.DefaultErrorMessages;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.idea.core.util.InlineAnalysisUtillKt;
import org.jetbrains.kotlin.idea.core.util.ProgressUtilKt;
import org.jetbrains.kotlin.idea.debugger.SafeUtilKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.EvaluationError;
import org.jetbrains.kotlin.idea.debugger.evaluate.EvaluationStatus;
import org.jetbrains.kotlin.idea.debugger.evaluate.EvaluationStatusKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.ExecutionContext;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinCodeFragmentFactory;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinDebuggerCaches;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinDebuggerEvaluationBundle;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinDebuggerEvaluator;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluator;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluatorBuilderKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.classLoading.ClassToLoad;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.CodeFragmentCompiler;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.CodeFragmentParameter;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.CompiledDataDescriptor;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.CompiledDataDescriptorKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.DebugLabelPropertyDescriptorProvider;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilingEvaluator.ClassLoadingResult;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilingEvaluator.CompilingEvaluatorKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.variables.EvaluatorValueConverter;
import org.jetbrains.kotlin.idea.debugger.evaluate.variables.VariableFinder;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacade;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.psi.KtBlockCodeFragment;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtExpressionCodeFragment;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.resolve.AnalyzingUtils;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.ClassNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.Frame;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 62\u00020\u0001:\u000267B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\t\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J(\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0017\u001a\u00020\u001bH\u0016J\u001a\u0010\u001c\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000b\u001a\u00020\fH\u0002J*\u0010\u001d\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u000b\u001a\u00020\fH\u0002J*\u0010 \u001a\u00020!2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001a\u0010\"\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0017\u001a\u00020\u001b2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\n\u0010#\u001a\u0004\u0018\u00010$H\u0016JQ\u0010%\u001a\u0002H&\"\u0004\b\u0000\u0010&2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u000b\u001a\u00020\f2\u001a\u0010'\u001a\u0016\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0010\u0012\u0004\u0012\u0002H&0(H\u0002\u00a2\u0006\u0002\u0010)J\u0018\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0002J\u0018\u00100\u001a\u0002012\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u000205H\u0002J\u0014\u00100\u001a\u000201*\u00020\u00032\u0006\u00104\u001a\u000205H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinEvaluator;", "Lcom/intellij/debugger/engine/evaluation/expression/Evaluator;", "codeFragment", "Lorg/jetbrains/kotlin/psi/KtCodeFragment;", "sourcePosition", "Lcom/intellij/debugger/SourcePosition;", "(Lorg/jetbrains/kotlin/psi/KtCodeFragment;Lcom/intellij/debugger/SourcePosition;)V", "getCodeFragment", "()Lorg/jetbrains/kotlin/psi/KtCodeFragment;", "analyze", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinEvaluator$ErrorCheckingResult;", "status", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/EvaluationStatus;", "debugProcess", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "calculateMainMethodCallArguments", "", "Lcom/sun/jdi/Value;", "variableFinder", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder;", "compiledData", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CompiledDataDescriptor;", "compileCodeFragment", "context", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/ExecutionContext;", "evaluate", "", "Lcom/intellij/debugger/engine/evaluation/EvaluationContextImpl;", "evaluateSafe", "evaluateWithCompilation", "classLoader", "Lcom/sun/jdi/ClassLoaderReference;", "evaluateWithEval4J", "Lorg/jetbrains/eval4j/InterpreterResult;", "evaluateWithStatus", "getModifier", "", "runEvaluation", "T", "block", "Lkotlin/Function1;", "(Lorg/jetbrains/kotlin/idea/debugger/evaluate/ExecutionContext;Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CompiledDataDescriptor;Lcom/sun/jdi/ClassLoaderReference;Lorg/jetbrains/kotlin/idea/debugger/evaluate/EvaluationStatus;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "updateLocalVariableValue", "", "converter", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/EvaluatorValueConverter;", "ref", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$RefWrapper;", "wrapToStringIfNeeded", "", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "Companion", "ErrorCheckingResult", "kotlin.jvm-debugger.evaluation"})
public final class KotlinEvaluator
implements Evaluator {
    @NotNull
    private final KtCodeFragment codeFragment;
    private final SourcePosition sourcePosition;
    private static final Set<DiagnosticFactory<?>> IGNORED_DIAGNOSTICS;
    private static final List<Type> DEFAULT_METHOD_MARKERS;
    @NotNull
    public static final Companion Companion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Object evaluate(@NotNull EvaluationContextImpl context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String string = this.codeFragment.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"codeFragment.text");
        CharSequence charSequence = string;
        boolean bl = false;
        if (charSequence.length() == 0) {
            DebugProcessImpl debugProcessImpl = context.getDebugProcess();
            Intrinsics.checkNotNullExpressionValue((Object)debugProcessImpl, (String)"context.debugProcess");
            return debugProcessImpl.getVirtualMachineProxy().mirrorOfVoid();
        }
        EvaluationStatus status = new EvaluationStatus();
        KotlinDebuggerEvaluator.EvaluationType evaluationType = (KotlinDebuggerEvaluator.EvaluationType)this.codeFragment.getUserData(KotlinCodeFragmentFactory.Companion.getEVALUATION_TYPE());
        if (evaluationType != null) {
            status.evaluationType(evaluationType);
        }
        EvaluationStatus.EvaluationContextLanguage language2 = (EvaluationStatus.EvaluationContextLanguage)((Object)ApplicationUtilsKt.runReadAction((Function0)((Function0)new Function0<EvaluationStatus.EvaluationContextLanguage>(this){
            final /* synthetic */ KotlinEvaluator this$0;

            @NotNull
            public final EvaluationStatus.EvaluationContextLanguage invoke() {
                EvaluationStatus.EvaluationContextLanguage evaluationContextLanguage;
                if (this.this$0.getCodeFragment().getCopyableUserData(KtCodeFragment.Companion.getFAKE_CONTEXT_FOR_JAVA_FILE()) != null) {
                    evaluationContextLanguage = EvaluationStatus.EvaluationContextLanguage.Java;
                } else {
                    PsiElement psiElement = this.this$0.getCodeFragment().getContext();
                    evaluationContextLanguage = Intrinsics.areEqual((Object)(psiElement != null ? psiElement.getLanguage() : null), (Object)KotlinLanguage.INSTANCE) ? EvaluationStatus.EvaluationContextLanguage.Kotlin : EvaluationStatus.EvaluationContextLanguage.Other;
                }
                return evaluationContextLanguage;
            }
            {
                this.this$0 = kotlinEvaluator;
                super(0);
            }
        })));
        EvaluationStatusKt.contextLanguage(status, language2);
        try {
            Object object = this.evaluateWithStatus(context, status);
            return object;
        }
        finally {
            status.send();
        }
    }

    private final Object evaluateWithStatus(EvaluationContextImpl context, EvaluationStatus status) {
        ApplicationUtilsKt.runReadAction((Function0)((Function0)new Function0<Unit>(this, status){
            final /* synthetic */ KotlinEvaluator this$0;
            final /* synthetic */ EvaluationStatus $status;

            public final void invoke() {
                DumbService dumbService = DumbService.getInstance((Project)this.this$0.getCodeFragment().getProject());
                Intrinsics.checkNotNullExpressionValue((Object)dumbService, (String)"DumbService.getInstance(codeFragment.project)");
                if (dumbService.isDumb()) {
                    this.$status.error(EvaluationError.DumbMode);
                    Void void_ = KotlinEvaluatorBuilderKt.access$evaluationException(KotlinDebuggerEvaluationBundle.message("error.dumb.mode", new Object[0]));
                    throw new KotlinNothingValueException();
                }
            }
            {
                this.this$0 = kotlinEvaluator;
                this.$status = evaluationStatus;
                super(0);
            }
        }));
        DebugProcessImpl debugProcessImpl = context.getDebugProcess();
        Intrinsics.checkNotNullExpressionValue((Object)debugProcessImpl, (String)"context.debugProcess");
        if (!debugProcessImpl.isAttached()) {
            status.error(EvaluationError.DebuggerNotAttached);
            EvaluateException evaluateException = EvaluateExceptionUtil.PROCESS_EXITED;
            Intrinsics.checkNotNullExpressionValue((Object)((Object)evaluateException), (String)"EvaluateExceptionUtil.PROCESS_EXITED");
            throw (Throwable)evaluateException;
        }
        StackFrameProxyImpl stackFrameProxyImpl = context.getFrameProxy();
        if (stackFrameProxyImpl == null) {
            KotlinEvaluator kotlinEvaluator = this;
            boolean bl = false;
            boolean bl2 = false;
            KotlinEvaluator $this$run = kotlinEvaluator;
            boolean bl3 = false;
            status.error(EvaluationError.NoFrameProxy);
            EvaluateException evaluateException = EvaluateExceptionUtil.NULL_STACK_FRAME;
            Intrinsics.checkNotNullExpressionValue((Object)((Object)evaluateException), (String)"EvaluateExceptionUtil.NULL_STACK_FRAME");
            throw (Throwable)evaluateException;
        }
        Intrinsics.checkNotNullExpressionValue((Object)stackFrameProxyImpl, (String)"context.frameProxy ?: ru\u2026ULL_STACK_FRAME\n        }");
        StackFrameProxyImpl frameProxy = stackFrameProxyImpl;
        SuspendContextImpl suspendContextImpl = context.getSuspendContext();
        Intrinsics.checkNotNullExpressionValue((Object)suspendContextImpl, (String)"context.suspendContext");
        ThreadReferenceProxyImpl threadReferenceProxyImpl = suspendContextImpl.getThread();
        if (threadReferenceProxyImpl == null) {
            KotlinEvaluator kotlinEvaluator = this;
            boolean bl = false;
            boolean $this$run = false;
            KotlinEvaluator $this$run2 = kotlinEvaluator;
            boolean bl4 = false;
            status.error(EvaluationError.ThreadNotAvailable);
            Void void_ = KotlinEvaluatorBuilderKt.access$evaluationException(KotlinDebuggerEvaluationBundle.message("error.thread.unavailable", new Object[0]));
            throw new KotlinNothingValueException();
        }
        Intrinsics.checkNotNullExpressionValue((Object)threadReferenceProxyImpl, (String)"context.suspendContext.t\u2026.unavailable\"))\n        }");
        ThreadReferenceProxyImpl operatingThread = threadReferenceProxyImpl;
        if (!operatingThread.isSuspended()) {
            status.error(EvaluationError.ThreadNotSuspended);
            Void void_ = KotlinEvaluatorBuilderKt.access$evaluationException(KotlinDebuggerEvaluationBundle.message("error.thread.not.suspended", new Object[0]));
            throw new KotlinNothingValueException();
        }
        try {
            ExecutionContext executionContext = new ExecutionContext(context, frameProxy);
            return this.evaluateSafe(executionContext, status);
        }
        catch (EvaluateException e) {
            EvaluationError error = e.getExceptionFromTargetVM() != null ? EvaluationError.ExceptionFromEvaluatedCode : EvaluationError.EvaluateException;
            status.error(error);
            throw (Throwable)e;
        }
        catch (ProcessCanceledException e) {
            status.error(EvaluationError.ProcessCancelledException);
            Void void_ = KotlinEvaluatorBuilderKt.access$evaluationException(e);
            throw new KotlinNothingValueException();
        }
        catch (Eval4JInterpretingException e) {
            status.error(EvaluationError.InterpretingException);
            Void void_ = KotlinEvaluatorBuilderKt.access$evaluationException(e.getCause());
            throw new KotlinNothingValueException();
        }
        catch (Exception e) {
            boolean isSpecialException = KotlinEvaluatorBuilderKt.access$isSpecialException(e);
            if (isSpecialException) {
                status.error(EvaluationError.SpecialException);
                Void void_ = KotlinEvaluatorBuilderKt.access$evaluationException(e);
                throw new KotlinNothingValueException();
            }
            status.error(EvaluationError.GenericException);
            String string = e.getMessage();
            if (string == null) {
                string = KotlinDebuggerEvaluationBundle.message("error.exception.occurred", new Object[0]);
            }
            KotlinEvaluatorBuilderKt.access$reportError(this.codeFragment, this.sourcePosition, string, e);
            String cause = e.getMessage() != null ? ": " + e.getMessage() : "";
            Void void_ = KotlinEvaluatorBuilderKt.access$evaluationException(KotlinDebuggerEvaluationBundle.message("error.cant.evaluate", new Object[0]) + cause);
            throw new KotlinNothingValueException();
        }
    }

    private final Object evaluateSafe(ExecutionContext context, EvaluationStatus status) {
        InterpreterResult interpreterResult;
        ClassLoaderReference classLoaderRef;
        Function0<CompiledDataDescriptor> $fun$compilerFactory$1 = new Function0<CompiledDataDescriptor>(this, context, status){
            final /* synthetic */ KotlinEvaluator this$0;
            final /* synthetic */ ExecutionContext $context;
            final /* synthetic */ EvaluationStatus $status;

            @NotNull
            public final CompiledDataDescriptor invoke() {
                return KotlinEvaluator.access$compileCodeFragment(this.this$0, this.$context, this.$status);
            }
            {
                this.this$0 = kotlinEvaluator;
                this.$context = executionContext;
                this.$status = evaluationStatus;
                super(0);
            }
        };
        Pair pair = KotlinDebuggerCaches.Companion.compileCodeFragmentCacheAware(this.codeFragment, this.sourcePosition, (Function0)new Function0<CompiledDataDescriptor>($fun$compilerFactory$1){
            final /* synthetic */ evaluateSafe.1 $compilerFactory$1;

            @NotNull
            public final CompiledDataDescriptor invoke() {
                return this.$compilerFactory$1.invoke();
            }
            {
                this.$compilerFactory$1 = var1_1;
                super(0, null, "compilerFactory", "invoke()Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CompiledDataDescriptor;", 0);
            }
        }, false);
        CompiledDataDescriptor compiledData = (CompiledDataDescriptor)pair.component1();
        ClassLoadingResult classLoadingResult = CompilingEvaluatorKt.loadClassesSafely(context, compiledData.getClasses());
        ClassLoadingResult classLoadingResult2 = classLoadingResult;
        if (!(classLoadingResult2 instanceof ClassLoadingResult.Success)) {
            classLoadingResult2 = null;
        }
        ClassLoadingResult.Success success = (ClassLoadingResult.Success)classLoadingResult2;
        ClassLoaderReference classLoaderReference = classLoaderRef = success != null ? success.getClassLoader() : null;
        if (classLoadingResult instanceof ClassLoadingResult.Failure) {
            EvaluationStatusKt.classLoadingFailed(status);
        }
        if (classLoaderRef != null) {
            try {
                EvaluationStatusKt.usedEvaluator(status, EvaluationStatus.EvaluatorType.Bytecode);
                return this.evaluateWithCompilation(context, compiledData, classLoaderRef, status);
            }
            catch (Throwable e) {
                InterpreterResult interpreterResult2;
                EvaluationStatusKt.compilingEvaluatorFailed(status);
                KotlinEvaluatorBuilderKt.getLOG().warn("Compiling evaluator failed", e);
                EvaluationStatusKt.usedEvaluator(status, EvaluationStatus.EvaluatorType.Eval4j);
                interpreterResult = interpreterResult2 = this.evaluateWithEval4J(context, compiledData, classLoaderRef, status);
            }
        } else {
            EvaluationStatusKt.usedEvaluator(status, EvaluationStatus.EvaluatorType.Eval4j);
            interpreterResult = this.evaluateWithEval4J(context, compiledData, classLoaderRef, status);
        }
        InterpreterResult result = interpreterResult;
        return KotlinEvaluator.Companion.toJdiValue(result, context, status);
    }

    /*
     * WARNING - void declaration
     */
    private final CompiledDataDescriptor compileCodeFragment(ExecutionContext context, EvaluationStatus status) {
        void analysisResult;
        DebugProcessImpl debugProcess = context.getDebugProcess();
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = this.analyze(this.codeFragment, status, debugProcess);
        if (this.wrapToStringIfNeeded(this.codeFragment, ((ErrorCheckingResult)analysisResult.element).getBindingContext())) {
            analysisResult.element = this.analyze(this.codeFragment, status, debugProcess);
        }
        Pair pair = (Pair)ApplicationUtilsKt.runReadAction((Function0)((Function0)new Function0<Pair<? extends BindingContext, ? extends List<? extends KtFile>>>(this, (Ref.ObjectRef)analysisResult){
            final /* synthetic */ KotlinEvaluator this$0;
            final /* synthetic */ Ref.ObjectRef $analysisResult;

            @NotNull
            public final Pair<BindingContext, List<KtFile>> invoke() {
                ResolutionFacade resolutionFacade = KotlinEvaluatorBuilderKt.getResolutionFacadeForCodeFragment(this.this$0.getCodeFragment());
                return InlineAnalysisUtillKt.analyzeInlinedFunctions((ResolutionFacade)resolutionFacade, (KtFile)((KtFile)this.this$0.getCodeFragment()), (boolean)false, (BindingContext)((ErrorCheckingResult)this.$analysisResult.element).getBindingContext());
            }
            {
                this.this$0 = kotlinEvaluator;
                this.$analysisResult = objectRef;
                super(0);
            }
        }));
        BindingContext bindingContext = (BindingContext)pair.component1();
        List filesToCompile = (List)pair.component2();
        ModuleDescriptor moduleDescriptor = ((ErrorCheckingResult)analysisResult.element).getModuleDescriptor();
        try {
            void bindingContext2;
            CodeFragmentCompiler.CompilationResult result = new CodeFragmentCompiler(context, status).compile(this.codeFragment, filesToCompile, (BindingContext)bindingContext2, moduleDescriptor);
            return KotlinEvaluatorBuilderKt.createCompiledDataDescriptor(result, this.sourcePosition);
        }
        catch (Throwable e) {
            status.error(EvaluationError.BackendException);
            throw e;
        }
    }

    private final boolean wrapToStringIfNeeded(KtCodeFragment $this$wrapToStringIfNeeded, BindingContext bindingContext) {
        KtExpression ktExpression = (KtExpression)ApplicationUtilsKt.runReadAction((Function0)((Function0)new Function0<KtExpression>($this$wrapToStringIfNeeded){
            final /* synthetic */ KtCodeFragment $this_wrapToStringIfNeeded;

            @Nullable
            public final KtExpression invoke() {
                KtExpression ktExpression;
                KtCodeFragment ktCodeFragment = this.$this_wrapToStringIfNeeded;
                if (ktCodeFragment instanceof KtExpressionCodeFragment) {
                    ktExpression = ((KtExpressionCodeFragment)this.$this_wrapToStringIfNeeded).getContentElement();
                } else if (ktCodeFragment instanceof KtBlockCodeFragment) {
                    List list = ((KtBlockCodeFragment)this.$this_wrapToStringIfNeeded).getContentElement().getStatements();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getContentElement().statements");
                    ktExpression = (KtExpression)CollectionsKt.lastOrNull((List)list);
                } else {
                    KotlinEvaluatorBuilderKt.getLOG().error("Invalid code fragment type: " + this.$this_wrapToStringIfNeeded.getClass());
                    ktExpression = null;
                }
                return ktExpression;
            }
            {
                this.$this_wrapToStringIfNeeded = ktCodeFragment;
                super(0);
            }
        }));
        if (ktExpression == null) {
            return false;
        }
        KtExpression expression2 = ktExpression;
        return this.wrapToStringIfNeeded(expression2, bindingContext);
    }

    private final boolean wrapToStringIfNeeded(KtExpression expression2, BindingContext bindingContext) {
        KotlinTypeInfo kotlinTypeInfo = (KotlinTypeInfo)bindingContext.get((ReadOnlySlice)BindingContext.EXPRESSION_TYPE_INFO, (Object)expression2);
        if (kotlinTypeInfo == null || (kotlinTypeInfo = kotlinTypeInfo.getType()) == null) {
            return false;
        }
        KotlinTypeInfo expressionType = kotlinTypeInfo;
        if (InlineClassesUtilsKt.isInlineClassType((KotlinType)expressionType)) {
            KtExpression newExpression2 = (KtExpression)ApplicationUtilsKt.runReadAction((Function0)((Function0)new Function0<KtExpression>(expression2){
                final /* synthetic */ KtExpression $expression;

                @NotNull
                public final KtExpression invoke() {
                    String expressionText = this.$expression.getText();
                    Project project = this.$expression.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"expression.project");
                    return new KtPsiFactory(project, false, 2, null).createExpression('(' + expressionText + ").toString()");
                }
                {
                    this.$expression = ktExpression;
                    super(0);
                }
            }));
            EdtTestUtilKt.runInEdtAndWait((Function0)((Function0)new Function0<Unit>(expression2, newExpression2){
                final /* synthetic */ KtExpression $expression;
                final /* synthetic */ KtExpression $newExpression;

                public final void invoke() {
                    Project project = this.$expression.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"expression.project");
                    ApplicationUtilsKt.executeWriteCommand((Project)project, (String)KotlinDebuggerEvaluationBundle.message("wrap.with.tostring", new Object[0]), (Function0)((Function0)new Function0<Unit>(this){
                        final /* synthetic */ wrapToStringIfNeeded.1 this$0;

                        public final void invoke() {
                            this.this$0.$expression.replace((PsiElement)this.this$0.$newExpression);
                        }
                        {
                            this.this$0 = var1_1;
                            super(0);
                        }
                    }));
                }
                {
                    this.$expression = ktExpression;
                    this.$newExpression = ktExpression2;
                    super(0);
                }
            }));
            return true;
        }
        return false;
    }

    private final ErrorCheckingResult analyze(KtCodeFragment codeFragment, EvaluationStatus status, DebugProcessImpl debugProcess) {
        return (ErrorCheckingResult)ProgressUtilKt.runInReadActionWithWriteActionPriorityWithPCE((Function0)((Function0)new Function0<ErrorCheckingResult>(codeFragment, status, debugProcess){
            final /* synthetic */ KtCodeFragment $codeFragment;
            final /* synthetic */ EvaluationStatus $status;
            final /* synthetic */ DebugProcessImpl $debugProcess;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final ErrorCheckingResult invoke() {
                Object v4;
                Iterable iterable;
                BindingContext bindingContext;
                AnalysisResult analysisResult;
                block7: {
                    void $this$firstOrNull$iv;
                    void $this$filterTo$iv$iv;
                    Iterable $this$filter$iv;
                    try {
                        AnalyzingUtils.checkForSyntacticErrors((PsiElement)((PsiElement)this.$codeFragment));
                    }
                    catch (IllegalArgumentException e) {
                        this.$status.error(EvaluationError.ErrorElementOccurred);
                        String string = e.getMessage();
                        if (string == null) {
                            string = e.toString();
                        }
                        Void void_ = KotlinEvaluatorBuilderKt.access$evaluationException(string);
                        throw new KotlinNothingValueException();
                    }
                    ResolutionFacade resolutionFacade = KotlinEvaluatorBuilderKt.getResolutionFacadeForCodeFragment(this.$codeFragment);
                    new DebugLabelPropertyDescriptorProvider(this.$codeFragment, this.$debugProcess).supplyDebugLabels();
                    analysisResult = ResolutionFacade.DefaultImpls.analyzeWithAllCompilerChecks$default((ResolutionFacade)resolutionFacade, (Collection)CollectionsKt.listOf((Object)this.$codeFragment), null, (int)2, null);
                    if (analysisResult.isError()) {
                        this.$status.error(EvaluationError.FrontendException);
                        Void void_ = KotlinEvaluatorBuilderKt.access$evaluationException(analysisResult.getError());
                        throw new KotlinNothingValueException();
                    }
                    bindingContext = analysisResult.getBindingContext();
                    Diagnostics diagnostics = bindingContext.getDiagnostics();
                    Intrinsics.checkNotNullExpressionValue((Object)diagnostics, (String)"bindingContext.diagnostics");
                    iterable = (Iterable)diagnostics;
                    boolean $i$f$filter = false;
                    Iterator<T> iterator = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        Diagnostic it = (Diagnostic)element$iv$iv;
                        boolean bl = false;
                        if (!(!KotlinEvaluator.access$getIGNORED_DIAGNOSTICS$cp().contains(it.getFactory()))) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$filter$iv = (List)destination$iv$iv;
                    boolean $i$f$firstOrNull = false;
                    for (T element$iv : $this$firstOrNull$iv) {
                        Diagnostic it = (Diagnostic)element$iv;
                        boolean bl = false;
                        if (!(it.getSeverity() == Severity.ERROR && Intrinsics.areEqual((Object)it.getPsiElement().getContainingFile(), (Object)this.$codeFragment))) continue;
                        v4 = element$iv;
                        break block7;
                    }
                    v4 = null;
                }
                Diagnostic diagnostic = v4;
                if (diagnostic != null) {
                    iterable = diagnostic;
                    boolean bl = false;
                    boolean bl2 = false;
                    Iterable it = iterable;
                    boolean bl3 = false;
                    this.$status.error(EvaluationError.ErrorsInCode);
                    String string = DefaultErrorMessages.render((UnboundDiagnostic)((UnboundDiagnostic)it));
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DefaultErrorMessages.render(it)");
                    Void void_ = KotlinEvaluatorBuilderKt.access$evaluationException(string);
                    throw new KotlinNothingValueException();
                }
                ModuleDescriptor moduleDescriptor = analysisResult.getModuleDescriptor();
                List<KtCodeFragment> list = Collections.singletonList(this.$codeFragment);
                Intrinsics.checkNotNullExpressionValue(list, (String)"Collections.singletonList(codeFragment)");
                return new ErrorCheckingResult(bindingContext, moduleDescriptor, list);
            }
            {
                this.$codeFragment = ktCodeFragment;
                this.$status = evaluationStatus;
                this.$debugProcess = debugProcessImpl;
                super(0);
            }
        }));
    }

    private final com.sun.jdi.Value evaluateWithCompilation(ExecutionContext context, CompiledDataDescriptor compiledData, ClassLoaderReference classLoader, EvaluationStatus status) {
        return (com.sun.jdi.Value)this.runEvaluation(context, compiledData, classLoader, status, (Function1)new Function1<List<? extends com.sun.jdi.Value>, com.sun.jdi.Value>(context, classLoader){
            final /* synthetic */ ExecutionContext $context;
            final /* synthetic */ ClassLoaderReference $classLoader;

            @Nullable
            public final com.sun.jdi.Value invoke(@NotNull List<? extends com.sun.jdi.Value> args) {
                Method mainMethod;
                Intrinsics.checkNotNullParameter(args, (String)"args");
                ReferenceType referenceType = this.$context.findClass("Generated_for_debugger_class", this.$classLoader);
                if (!(referenceType instanceof ClassType)) {
                    referenceType = null;
                }
                ClassType classType = (ClassType)referenceType;
                if (classType == null) {
                    String string = "Can not find class \"Generated_for_debugger_class\"";
                    boolean bl = false;
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                ClassType mainClassType = classType;
                List<Method> list = mainClassType.methods();
                Intrinsics.checkNotNullExpressionValue(list, (String)"mainClassType.methods()");
                Iterable $this$single$iv = list;
                boolean $i$f$single = false;
                Object single$iv = null;
                boolean found$iv = false;
                for (T element$iv : $this$single$iv) {
                    Method it = (Method)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.name(), (Object)"generated_for_debugger_fun")) continue;
                    if (found$iv) {
                        throw (Throwable)new IllegalArgumentException("Collection contains more than one matching element.");
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                if (!found$iv) {
                    throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
                }
                Method method = mainMethod = (Method)single$iv;
                Intrinsics.checkNotNullExpressionValue((Object)method, (String)"mainMethod");
                com.sun.jdi.Value returnValue = this.$context.invokeMethod(mainClassType, method, args);
                return new EvaluatorValueConverter(this.$context).unref(returnValue);
            }
            {
                this.$context = executionContext;
                this.$classLoader = classLoaderReference;
                super(1);
            }
        });
    }

    private final InterpreterResult evaluateWithEval4J(ExecutionContext context, CompiledDataDescriptor compiledData, ClassLoaderReference classLoader, EvaluationStatus status) {
        Object element$iv2;
        block2: {
            byte[] mainClassBytecode = CompiledDataDescriptorKt.getMainClass((CompiledDataDescriptor)compiledData).getBytes();
            ClassNode classNode = new ClassNode();
            boolean bl = false;
            boolean bl2 = false;
            ClassNode $this$apply = classNode;
            boolean bl3 = false;
            new ClassReader(mainClassBytecode).accept((ClassVisitor)$this$apply, 0);
            ClassNode mainClassAsmNode = classNode;
            List list = mainClassAsmNode.methods;
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"mainClassAsmNode.methods");
            Iterable $this$first$iv = list;
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                MethodNode it = (MethodNode)element$iv2;
                boolean bl4 = false;
                if (!Intrinsics.areEqual((Object)it.name, (Object)"generated_for_debugger_fun")) continue;
                break block2;
            }
            throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        MethodNode mainMethod = (MethodNode)element$iv2;
        ClassLoaderReference classLoaderReference = classLoader;
        if (classLoaderReference == null) {
            classLoaderReference = context.getEvaluationContext().getClassLoader();
        }
        return (InterpreterResult)this.runEvaluation(context, compiledData, classLoaderReference, status, (Function1)new Function1<List<? extends com.sun.jdi.Value>, InterpreterResult>(context, classLoader, mainMethod){
            final /* synthetic */ ExecutionContext $context;
            final /* synthetic */ ClassLoaderReference $classLoader;
            final /* synthetic */ MethodNode $mainMethod;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final InterpreterResult invoke(@NotNull List<? extends com.sun.jdi.Value> args) {
                Collection<Value> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                String it;
                Object object;
                VirtualMachine vm;
                block4: {
                    boolean bl;
                    String string;
                    block3: {
                        Intrinsics.checkNotNullParameter(args, (String)"args");
                        VirtualMachine virtualMachine = this.$context.getVm().getVirtualMachine();
                        Intrinsics.checkNotNullExpressionValue((Object)virtualMachine, (String)"context.vm.virtualMachine");
                        vm = virtualMachine;
                        object = this.$context.getSuspendContext().getThread();
                        if (object == null || (object = object.getThreadReference()) == null) break block3;
                        string = object;
                        bl = false;
                        boolean bl2 = false;
                        it = string;
                        boolean bl3 = false;
                        object = it.isSuspended() ? string : null;
                        if (object != null) break block4;
                    }
                    string = "Can not find a thread to run evaluation on";
                    bl = false;
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                Object thread = object;
                JDIEval eval2 = new JDIEval(this, vm, (ThreadReference)thread, vm, this.$classLoader, (ThreadReference)thread, this.$context.getInvokePolicy()){
                    final /* synthetic */ evaluateWithEval4J.1 this$0;
                    final /* synthetic */ VirtualMachine $vm;
                    final /* synthetic */ ThreadReference $thread;

                    @Nullable
                    public com.sun.jdi.Value jdiInvokeStaticMethod(@NotNull ClassType type2, @NotNull Method method, @NotNull List<? extends com.sun.jdi.Value> args, int invokePolicy) {
                        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
                        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                        Intrinsics.checkNotNullParameter(args, (String)"args");
                        return this.this$0.$context.invokeMethod(type2, method, args);
                    }

                    @Nullable
                    public com.sun.jdi.Value jdiInvokeStaticMethod(@NotNull InterfaceType type2, @NotNull Method method, @NotNull List<? extends com.sun.jdi.Value> args, int invokePolicy) {
                        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
                        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                        Intrinsics.checkNotNullParameter(args, (String)"args");
                        return this.this$0.$context.invokeMethod(type2, method, args);
                    }

                    @Nullable
                    public com.sun.jdi.Value jdiInvokeMethod(@NotNull ObjectReference obj, @NotNull Method method, @NotNull List<? extends com.sun.jdi.Value> args, int policy) {
                        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
                        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                        Intrinsics.checkNotNullParameter(args, (String)"args");
                        return this.this$0.$context.invokeMethod(obj, method, args, 2);
                    }
                    {
                        this.this$0 = this$0;
                        this.$vm = $captured_local_variable$1;
                        this.$thread = $captured_local_variable$2;
                        super($super_call_param$3, $super_call_param$4, $super_call_param$5, $super_call_param$6);
                    }
                };
                MethodNode methodNode = this.$mainMethod;
                Intrinsics.checkNotNullExpressionValue((Object)methodNode, (String)"mainMethod");
                MethodNode methodNode2 = this.$mainMethod;
                Intrinsics.checkNotNullExpressionValue((Object)methodNode2, (String)"mainMethod");
                Iterable iterable = args;
                MethodNode methodNode3 = methodNode2;
                MethodNode methodNode4 = methodNode;
                boolean $i$f$map = false;
                it = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it2;
                    com.sun.jdi.Value value2 = (com.sun.jdi.Value)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    Value value3 = JdiValuesKt.asValue((com.sun.jdi.Value)it2);
                    collection.add(value3);
                }
                collection = (List)destination$iv$iv;
                return InterpreterLoopKt.interpreterLoop$default((MethodNode)methodNode4, (Frame)JdiValuesKt.makeInitialFrame((MethodNode)methodNode3, (List)collection), (Eval)((Eval)eval2), null, (int)8, null);
            }
            {
                this.$context = executionContext;
                this.$classLoader = classLoaderReference;
                this.$mainMethod = methodNode;
                super(1);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final <T> T runEvaluation(ExecutionContext context, CompiledDataDescriptor compiledData, ClassLoaderReference classLoader, EvaluationStatus status, Function1<? super List<? extends com.sun.jdi.Value>, ? extends T> block) {
        void $this$forEach$iv;
        Iterator $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Iterable iterable = compiledData.getClasses();
        boolean $i$f$filter = false;
        void var8_9 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv = iterator.next();
            ClassToLoad it = (ClassToLoad)element$iv$iv;
            boolean bl = false;
            if (!(!it.isMainClass())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ClassToLoad it = (ClassToLoad)element$iv;
            boolean bl = false;
            context.findClass(it.getClassName(), classLoader);
        }
        for (Type parameterType : compiledData.getMainMethodSignature().getParameterTypes()) {
            context.findClass(parameterType, classLoader);
        }
        VariableFinder variableFinder = new VariableFinder(context);
        List<com.sun.jdi.Value> args = this.calculateMainMethodCallArguments(variableFinder, compiledData, status);
        Object result = block.invoke(args);
        for (VariableFinder.RefWrapper wrapper : variableFinder.getRefWrappers()) {
            this.updateLocalVariableValue(variableFinder.getEvaluatorValueConverter(), wrapper);
        }
        return (T)result;
    }

    private final void updateLocalVariableValue(EvaluatorValueConverter converter, VariableFinder.RefWrapper ref2) {
        StackFrameProxyImpl frameProxy = converter.getContext().getFrameProxy();
        LocalVariableProxyImpl localVariableProxyImpl = SafeUtilKt.safeVisibleVariableByName((StackFrameProxyImpl)frameProxy, (String)ref2.getLocalVariableName());
        if (localVariableProxyImpl == null) {
            return;
        }
        LocalVariableProxyImpl variable = localVariableProxyImpl;
        com.sun.jdi.Value newValue = converter.unref(ref2.getWrapper());
        try {
            frameProxy.setValue(variable, newValue);
        }
        catch (InvalidTypeException e) {
            com.sun.jdi.Value value2 = newValue;
            KotlinEvaluatorBuilderKt.getLOG().error("Cannot update local variable value: expected type " + variable.getType() + ", actual type " + (value2 != null ? value2.type() : null), (Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<com.sun.jdi.Value> calculateMainMethodCallArguments(VariableFinder variableFinder, CompiledDataDescriptor compiledData, EvaluationStatus status) {
        void $this$mapTo$iv$iv;
        List asmValueParameters = compiledData.getMainMethodSignature().getParameterTypes();
        List valueParameters = compiledData.getParameters();
        boolean bl = asmValueParameters.size() == valueParameters.size();
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        List args = CollectionsKt.zip((Iterable)valueParameters, (Iterable)asmValueParameters);
        Iterable $this$map$iv = args;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void parameter;
            void $dstr$parameter$asmType;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl6 = false;
            CodeFragmentParameter.Dumb dumb = (CodeFragmentParameter.Dumb)$dstr$parameter$asmType.component1();
            Type asmType = (Type)$dstr$parameter$asmType.component2();
            VariableFinder.Result result = variableFinder.find((CodeFragmentParameter)parameter, asmType);
            if (result == null) {
                String name = parameter.getDebugString();
                Function0<Boolean> $fun$isInsideDefaultInterfaceMethod$1 = new Function0<Boolean>(variableFinder, status, compiledData){
                    final /* synthetic */ VariableFinder $variableFinder$inlined;
                    final /* synthetic */ EvaluationStatus $status$inlined;
                    final /* synthetic */ CompiledDataDescriptor $compiledData$inlined;
                    {
                        this.$variableFinder$inlined = variableFinder;
                        this.$status$inlined = evaluationStatus;
                        this.$compiledData$inlined = compiledDataDescriptor;
                        super(0);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final boolean invoke() {
                        Type type2;
                        StringBuilder stringBuilder;
                        CharSequence charSequence;
                        Location location = SafeUtilKt.safeLocation((StackFrameProxy)((StackFrameProxy)this.$variableFinder$inlined.getContext().getFrameProxy()));
                        Comparable<Location> comparable = location;
                        if (location == null) return false;
                        Method method = SafeUtilKt.safeMethod((Location)comparable);
                        comparable = method;
                        if (method == null) return false;
                        Comparable<Location> method2 = comparable;
                        String desc = method2.signature();
                        String string = method2.name();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"method.name()");
                        if (!StringsKt.endsWith$default((String)string, (String)"$default", (boolean)false, (int)2, null)) return false;
                        Iterable $this$any$iv = KotlinEvaluator.access$getDEFAULT_METHOD_MARKERS$cp();
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            return false;
                        }
                        Iterator<T> iterator = $this$any$iv.iterator();
                        do {
                            if (!iterator.hasNext()) return false;
                            T element$iv = iterator.next();
                            Type it = (Type)element$iv;
                            boolean bl = false;
                            String string2 = desc;
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"desc");
                            charSequence = string2;
                            stringBuilder = new StringBuilder().append('I');
                            type2 = it;
                            Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"it");
                        } while (!StringsKt.contains$default((CharSequence)charSequence, (CharSequence)stringBuilder.append(type2.getDescriptor()).append(')').toString(), (boolean)false, (int)2, null));
                        return true;
                    }
                };
                if (parameter.getKind() == CodeFragmentParameter.Kind.COROUTINE_CONTEXT) {
                    status.error(EvaluationError.CoroutineContextUnavailable);
                    Void void_ = KotlinEvaluatorBuilderKt.access$evaluationException(KotlinDebuggerEvaluationBundle.message("error.coroutine.context.unavailable", new Object[0]));
                    throw new KotlinNothingValueException();
                }
                if (compiledData.getCrossingBounds().contains(parameter)) {
                    status.error(EvaluationError.ParameterNotCaptured);
                    Void void_ = KotlinEvaluatorBuilderKt.access$evaluationException(KotlinDebuggerEvaluationBundle.message("error.not.captured", name));
                    throw new KotlinNothingValueException();
                }
                if (parameter.getKind() == CodeFragmentParameter.Kind.FIELD_VAR) {
                    status.error(EvaluationError.BackingFieldNotFound);
                    Void void_ = KotlinEvaluatorBuilderKt.access$evaluationException(KotlinDebuggerEvaluationBundle.message("error.cant.find.backing.field", parameter.getName()));
                    throw new KotlinNothingValueException();
                }
                if (parameter.getKind() == CodeFragmentParameter.Kind.ORDINARY && $fun$isInsideDefaultInterfaceMethod$1.invoke()) {
                    status.error(EvaluationError.InsideDefaultMethod);
                    Void void_ = KotlinEvaluatorBuilderKt.access$evaluationException(KotlinDebuggerEvaluationBundle.message("error.parameter.evaluation.default.methods", new Object[0]));
                    throw new KotlinNothingValueException();
                }
                status.error(EvaluationError.CannotFindVariable);
                Object[] objectArray = new Object[2];
                objectArray[0] = name;
                String string = asmType.getClassName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asmType.className");
                objectArray[1] = string;
                Void void_ = KotlinEvaluatorBuilderKt.access$evaluationException(KotlinDebuggerEvaluationBundle.message("error.cant.find.variable", objectArray));
                throw new KotlinNothingValueException();
            }
            com.sun.jdi.Value value2 = result.getValue();
            collection.add(value2);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public Void getModifier() {
        return null;
    }

    @NotNull
    public final KtCodeFragment getCodeFragment() {
        return this.codeFragment;
    }

    public KotlinEvaluator(@NotNull KtCodeFragment codeFragment, @Nullable SourcePosition sourcePosition) {
        Intrinsics.checkNotNullParameter((Object)codeFragment, (String)"codeFragment");
        this.codeFragment = codeFragment;
        this.sourcePosition = sourcePosition;
    }

    static {
        Companion = new Companion(null);
        ImmutableSet immutableSet = Errors.INVISIBLE_REFERENCE_DIAGNOSTICS;
        Intrinsics.checkNotNullExpressionValue((Object)immutableSet, (String)"Errors.INVISIBLE_REFERENCE_DIAGNOSTICS");
        IGNORED_DIAGNOSTICS = SetsKt.plus((Set)((Set)immutableSet), (Iterable)SetsKt.setOf((Object[])new DiagnosticFactoryWithPsiElement[]{(DiagnosticFactoryWithPsiElement)Errors.EXPERIMENTAL_API_USAGE_ERROR, (DiagnosticFactoryWithPsiElement)Errors.MISSING_DEPENDENCY_SUPERCLASS, (DiagnosticFactoryWithPsiElement)Errors.IR_WITH_UNSTABLE_ABI_COMPILED_CLASS, (DiagnosticFactoryWithPsiElement)Errors.FIR_COMPILED_CLASS}));
        DEFAULT_METHOD_MARKERS = CollectionsKt.listOf((Object[])new Type[]{AsmTypes.OBJECT_TYPE, AsmTypes.DEFAULT_CONSTRUCTOR_MARKER});
    }

    public static final /* synthetic */ CompiledDataDescriptor access$compileCodeFragment(KotlinEvaluator $this, ExecutionContext context, EvaluationStatus status) {
        return $this.compileCodeFragment(context, status);
    }

    public static final /* synthetic */ Set access$getIGNORED_DIAGNOSTICS$cp() {
        return IGNORED_DIAGNOSTICS;
    }

    public static final /* synthetic */ List access$getDEFAULT_METHOD_MARKERS$cp() {
        return DEFAULT_METHOD_MARKERS;
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J-\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinEvaluator$ErrorCheckingResult;", "", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "files", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "(Lorg/jetbrains/kotlin/resolve/BindingContext;Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Ljava/util/List;)V", "getBindingContext", "()Lorg/jetbrains/kotlin/resolve/BindingContext;", "getFiles", "()Ljava/util/List;", "getModuleDescriptor", "()Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "kotlin.jvm-debugger.evaluation"})
    private static final class ErrorCheckingResult {
        @NotNull
        private final BindingContext bindingContext;
        @NotNull
        private final ModuleDescriptor moduleDescriptor;
        @NotNull
        private final List<KtFile> files;

        @NotNull
        public final BindingContext getBindingContext() {
            return this.bindingContext;
        }

        @NotNull
        public final ModuleDescriptor getModuleDescriptor() {
            return this.moduleDescriptor;
        }

        @NotNull
        public final List<KtFile> getFiles() {
            return this.files;
        }

        public ErrorCheckingResult(@NotNull BindingContext bindingContext, @NotNull ModuleDescriptor moduleDescriptor, @NotNull List<? extends KtFile> files) {
            Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
            Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"moduleDescriptor");
            Intrinsics.checkNotNullParameter(files, (String)"files");
            this.bindingContext = bindingContext;
            this.moduleDescriptor = moduleDescriptor;
            this.files = files;
        }

        @NotNull
        public final BindingContext component1() {
            return this.bindingContext;
        }

        @NotNull
        public final ModuleDescriptor component2() {
            return this.moduleDescriptor;
        }

        @NotNull
        public final List<KtFile> component3() {
            return this.files;
        }

        @NotNull
        public final ErrorCheckingResult copy(@NotNull BindingContext bindingContext, @NotNull ModuleDescriptor moduleDescriptor, @NotNull List<? extends KtFile> files) {
            Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
            Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"moduleDescriptor");
            Intrinsics.checkNotNullParameter(files, (String)"files");
            return new ErrorCheckingResult(bindingContext, moduleDescriptor, files);
        }

        public static /* synthetic */ ErrorCheckingResult copy$default(ErrorCheckingResult errorCheckingResult, BindingContext bindingContext, ModuleDescriptor moduleDescriptor, List list, int n, Object object) {
            if ((n & 1) != 0) {
                bindingContext = errorCheckingResult.bindingContext;
            }
            if ((n & 2) != 0) {
                moduleDescriptor = errorCheckingResult.moduleDescriptor;
            }
            if ((n & 4) != 0) {
                list = errorCheckingResult.files;
            }
            return errorCheckingResult.copy(bindingContext, moduleDescriptor, list);
        }

        @NotNull
        public String toString() {
            return "ErrorCheckingResult(bindingContext=" + this.bindingContext + ", moduleDescriptor=" + this.moduleDescriptor + ", files=" + this.files + ")";
        }

        public int hashCode() {
            BindingContext bindingContext = this.bindingContext;
            ModuleDescriptor moduleDescriptor = this.moduleDescriptor;
            List<KtFile> list = this.files;
            return ((bindingContext != null ? bindingContext.hashCode() : 0) * 31 + (moduleDescriptor != null ? moduleDescriptor.hashCode() : 0)) * 31 + (list != null ? ((Object)list).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ErrorCheckingResult)) break block3;
                    ErrorCheckingResult errorCheckingResult = (ErrorCheckingResult)object;
                    if (!Intrinsics.areEqual((Object)this.bindingContext, (Object)errorCheckingResult.bindingContext) || !Intrinsics.areEqual((Object)this.moduleDescriptor, (Object)errorCheckingResult.moduleDescriptor) || !Intrinsics.areEqual(this.files, errorCheckingResult.files)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001e\u0010\u0010\u001a\u0004\u0018\u00010\u0011*\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u001c\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0007\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinEvaluator$Companion;", "", "()V", "DEFAULT_METHOD_MARKERS", "", "Lorg/jetbrains/org/objectweb/asm/Type;", "kotlin.jvm.PlatformType", "IGNORED_DIAGNOSTICS", "", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory;", "getValueIfSharedVar", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$Result;", "value", "Lorg/jetbrains/eval4j/Value;", "context", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/ExecutionContext;", "toJdiValue", "Lcom/sun/jdi/Value;", "Lorg/jetbrains/eval4j/InterpreterResult;", "status", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/EvaluationStatus;", "kotlin.jvm-debugger.evaluation"})
    public static final class Companion {
        private final com.sun.jdi.Value toJdiValue(InterpreterResult $this$toJdiValue, ExecutionContext context, EvaluationStatus status) {
            InterpreterResult interpreterResult = $this$toJdiValue;
            if (!(interpreterResult instanceof ValueReturned)) {
                if (interpreterResult instanceof ExceptionThrown) {
                    if (((ExceptionThrown)$this$toJdiValue).getKind() == ExceptionThrown.ExceptionKind.FROM_EVALUATED_CODE) {
                        status.error(EvaluationError.ExceptionFromEvaluatedCode);
                        Object object = ((ExceptionThrown)$this$toJdiValue).getException().getValue();
                        if (object == null) {
                            throw new NullPointerException("null cannot be cast to non-null type com.sun.jdi.ObjectReference");
                        }
                        Void void_ = KotlinEvaluatorBuilderKt.access$evaluationException(new InvocationException((ObjectReference)object));
                        throw new KotlinNothingValueException();
                    }
                    if (((ExceptionThrown)$this$toJdiValue).getKind() == ExceptionThrown.ExceptionKind.BROKEN_CODE) {
                        Object object = ((ExceptionThrown)$this$toJdiValue).getException().getValue();
                        if (object == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Throwable");
                        }
                        throw (Throwable)object;
                    }
                    status.error(EvaluationError.Eval4JUnknownException);
                    Void void_ = KotlinEvaluatorBuilderKt.access$evaluationException(((ExceptionThrown)$this$toJdiValue).getException().toString());
                    throw new KotlinNothingValueException();
                }
                if (interpreterResult instanceof AbnormalTermination) {
                    status.error(EvaluationError.Eval4JAbnormalTermination);
                    Void void_ = KotlinEvaluatorBuilderKt.access$evaluationException(((AbnormalTermination)$this$toJdiValue).getMessage());
                    throw new KotlinNothingValueException();
                }
                throw (Throwable)new IllegalStateException("Unknown result value produced by eval4j");
            }
            Value jdiValue = ((ValueReturned)$this$toJdiValue).getResult();
            VariableFinder.Result sharedVar = jdiValue instanceof AbstractValue ? this.getValueIfSharedVar(jdiValue, context) : null;
            Object object = sharedVar;
            if (object == null || (object = ((VariableFinder.Result)object).getValue()) == null) {
                VirtualMachine virtualMachine = context.getVm().getVirtualMachine();
                Intrinsics.checkNotNullExpressionValue((Object)virtualMachine, (String)"context.vm.virtualMachine");
                object = JdiValuesKt.asJdiValue((Value)jdiValue, (VirtualMachine)virtualMachine, (Type)jdiValue.getAsmType());
            }
            return object;
        }

        private final VariableFinder.Result getValueIfSharedVar(Value value2, ExecutionContext context) {
            Object object = ValuesKt.obj((Value)value2, (Type)value2.getAsmType());
            if (!(object instanceof ObjectReference)) {
                object = null;
            }
            ObjectReference objectReference = (ObjectReference)object;
            if (objectReference == null) {
                return null;
            }
            ObjectReference obj = objectReference;
            return new VariableFinder.Result(new EvaluatorValueConverter(context).unref(obj));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

