/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.idea.ui;

import com.google.gct.idea.ui.CustomizableComboBoxPopup;
import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.ui.UIUtil;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Path2D;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.text.Document;
import org.jetbrains.annotations.Nullable;

public abstract class CustomizableComboBox
extends JPanel {
    private JBTextField myTextField;
    private JComboBox myThemedCombo = new ComboBox();
    private boolean myPopupVisible;

    public CustomizableComboBox() {
        super(new BorderLayout());
        this.myThemedCombo.setEditable(true);
        PopupMouseListener listener = new PopupMouseListener();
        if (SystemInfo.isXWindow && UIManager.getLookAndFeel().getName().contains("GTK")) {
            this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        } else {
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2), BorderFactory.createLineBorder(CustomizableComboBox.getBorderColor(), 1)));
        }
        this.myTextField = new JBTextField(){

            public void setBorder(Border border) {
                super.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 0));
            }
        };
        this.myTextField.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 0));
        this.myTextField.addMouseListener((MouseListener)listener);
        this.myTextField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                CustomizableComboBox.this.myTextField.selectAll();
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        JButton popupButton = this.createArrowButton();
        popupButton.addMouseListener(listener);
        this.add((Component)popupButton, "East");
        this.add((Component)this.myTextField, "Center");
    }

    @Override
    public Dimension getPreferredSize() {
        return this.myThemedCombo.getPreferredSize();
    }

    protected abstract CustomizableComboBoxPopup getPopup();

    protected abstract int getPreferredPopupHeight();

    protected JBTextField getTextField() {
        return this.myTextField;
    }

    public Document getDocument() {
        return this.getTextField().getDocument();
    }

    public void setText(@Nullable String text) {
        this.myTextField.setText(text);
    }

    public String getText() {
        return this.myTextField.getText();
    }

    private void showPopup() {
        if (!this.getPopup().isPopupVisible()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    boolean showOnTop = false;
                    GraphicsConfiguration gc = CustomizableComboBox.this.getGraphicsConfiguration();
                    if (gc != null) {
                        Rectangle bounds = gc.getBounds();
                        Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(gc);
                        int effectiveScreenAreaHeight = bounds.height - screenInsets.top - screenInsets.bottom;
                        Point comboLocation = CustomizableComboBox.this.getLocationOnScreen();
                        if (comboLocation.getY() + (double)CustomizableComboBox.this.getHeight() + (double)CustomizableComboBox.this.getPreferredPopupHeight() > (double)effectiveScreenAreaHeight) {
                            showOnTop = true;
                        }
                    }
                    if (showOnTop) {
                        CustomizableComboBox.this.getPopup().showPopup(new RelativePoint((Component)CustomizableComboBox.this, new Point(0, -CustomizableComboBox.this.getPreferredPopupHeight())));
                    } else {
                        CustomizableComboBox.this.getPopup().showPopup(new RelativePoint((Component)CustomizableComboBox.this, new Point(0, CustomizableComboBox.this.getHeight() - 1)));
                    }
                }
            });
        }
    }

    private static boolean isUsingDarculaUIFlavor() {
        return UIUtil.isUnderDarcula() || UIUtil.isUnderIntelliJLaF();
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if ((this.myTextField.isFocusOwner() || this.getPopup() != null && this.getPopup().isPopupVisible()) && CustomizableComboBox.isUsingDarculaUIFlavor()) {
            DarculaUIUtil.paintFocusOval((Graphics2D)((Graphics2D)g), (float)3.0f, (float)3.0f, (float)(this.getWidth() - 4), (float)(this.getHeight() - 4));
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.myTextField.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                CustomizableComboBox.this.repaint();
            }

            @Override
            public void focusLost(FocusEvent e) {
                CustomizableComboBox.this.repaint();
            }
        });
    }

    private static Color getButtonBackgroundColor() {
        Color color = CustomizableComboBox.isUsingDarculaUIFlavor() ? UIManager.getColor("ComboBox.darcula.arrowFillColor") : UIManager.getColor("ComboBox.buttonBackground");
        return color == null ? UIUtil.getControlColor() : color;
    }

    private Color getArrowColor() {
        Color color = null;
        if (CustomizableComboBox.isUsingDarculaUIFlavor()) {
            Object object = color = this.isEnabled() ? new JBColor((Color)Gray._255, this.getForeground()) : new JBColor((Color)Gray._255, this.getForeground().darker());
        }
        if (color == null) {
            color = this.getForeground();
        }
        return color;
    }

    private static Color getBorderColor() {
        return new JBColor((Color)Gray._150, (Color)Gray._100);
    }

    private JButton createArrowButton() {
        Color bg = this.getBackground();
        Color fg = this.getForeground();
        BasicArrowButton button = new BasicArrowButton(5, bg, fg, fg, fg){

            @Override
            public void paint(Graphics g2) {
                Graphics2D g = (Graphics2D)g2;
                GraphicsConfig config = new GraphicsConfig((Graphics)g);
                int w = this.getWidth();
                int h = this.getHeight();
                g.setColor(CustomizableComboBox.getButtonBackgroundColor());
                g.fillRect(0, 0, w, h);
                g.setColor(CustomizableComboBox.this.getArrowColor());
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
                g.setStroke(new BasicStroke(1.0f, 0, 2));
                int midx = (int)Math.ceil((w - 1) / 2) + 1;
                int midy = (int)Math.ceil(h / 2);
                Path2D.Double path = new Path2D.Double();
                path.moveTo(midx - 4, midy - 2);
                path.lineTo(midx + 4, midy - 2);
                path.lineTo(midx, midy + 4);
                path.lineTo(midx - 4, midy - 2);
                path.closePath();
                g.fill(path);
                g.setColor(CustomizableComboBox.getBorderColor());
                if (SystemInfo.isXWindow && UIManager.getLookAndFeel().getName().contains("GTK")) {
                    g.drawLine(0, 1, 0, h - 2);
                    g.drawLine(0, 1, w - 2, 1);
                    g.drawLine(0, h - 2, w - 2, h - 2);
                    g.drawLine(w - 2, 1, w - 2, h - 2);
                } else {
                    g.drawLine(0, 0, 0, h);
                }
                config.restore();
            }

            @Override
            public Dimension getPreferredSize() {
                int newSize = CustomizableComboBox.this.getHeight() - (CustomizableComboBox.this.getInsets().bottom + CustomizableComboBox.this.getInsets().top);
                return new Dimension(newSize, newSize);
            }
        };
        button.setOpaque(false);
        button.setFocusable(false);
        button.setBorder(BorderFactory.createEmptyBorder(1, 0, 1, 1));
        return button;
    }

    class PopupMouseListener
    implements MouseListener {
        PopupMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (CustomizableComboBox.this.myPopupVisible) {
                if (CustomizableComboBox.this.getPopup() != null && CustomizableComboBox.this.getPopup().isPopupVisible()) {
                    CustomizableComboBox.this.getPopup().hidePopup();
                }
                CustomizableComboBox.this.myPopupVisible = false;
            } else {
                CustomizableComboBox.this.myTextField.grabFocus();
                CustomizableComboBox.this.showPopup();
                CustomizableComboBox.this.myPopupVisible = true;
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            CustomizableComboBox.this.myPopupVisible = CustomizableComboBox.this.getPopup() != null && CustomizableComboBox.this.getPopup().isPopupVisible();
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }
}

