/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.idea.git;

import com.google.api.client.repackaged.com.google.common.base.Strings;
import com.google.gct.idea.git.CloneCloudRepositoryDialog;
import com.google.gct.idea.git.GcpHttpAuthDataProvider;
import com.google.gct.idea.util.GctBundle;
import com.google.gct.login.stats.UsageTrackerService;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.vcs.CheckoutProvider;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.DialogManager;
import git4idea.GitVcs;
import git4idea.actions.BasicAction;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandlerListener;
import git4idea.commands.GitStandardProgressAnalyzer;
import java.io.File;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GcpCheckoutProvider
implements CheckoutProvider {
    private static final Logger LOG = Logger.getInstance(GcpCheckoutProvider.class);
    private static final String URL_REGEX = "https?://(www\\.)?[-a-zA-Z0-9@:%._\\+~#=]{2,256}\\.[a-z]{2,6}\\b([-a-zA-Z0-9@:%_\\+.~#?&//=]*)";
    private final Git git = Git.getInstance();

    public String getVcsName() {
        return "_Google Cloud";
    }

    public void doCheckout(@NotNull Project project, @Nullable CheckoutProvider.Listener listener) {
        File parent;
        UsageTrackerService.getInstance().trackEvent("com.google.cloud.tools", "vcs", "checkout", null);
        BasicAction.saveAll();
        CloneCloudRepositoryDialog dialog = new CloneCloudRepositoryDialog(project);
        DialogManager.show((DialogWrapper)dialog);
        if (!dialog.isOK() || Strings.isNullOrEmpty((String)dialog.getParentDirectory()) || Strings.isNullOrEmpty((String)dialog.getSourceRepositoryUrl()) || Strings.isNullOrEmpty((String)dialog.getDirectoryName())) {
            return;
        }
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        VirtualFile destinationParent = lfs.findFileByIoFile(parent = new File(dialog.getParentDirectory()));
        if (destinationParent == null) {
            destinationParent = lfs.refreshAndFindFileByIoFile(parent);
        }
        if (destinationParent == null) {
            return;
        }
        String sourceRepositoryUrl = dialog.getSourceRepositoryUrl();
        String directoryName = dialog.getDirectoryName();
        String parentDirectory = dialog.getParentDirectory();
        String gcpUserName = dialog.getGcpUserName();
        if (Strings.isNullOrEmpty((String)gcpUserName)) {
            LOG.error("unexpected blank username during checkout");
            return;
        }
        GcpCheckoutProvider.clone(project, this.git, listener, destinationParent, sourceRepositoryUrl, directoryName, parentDirectory, gcpUserName);
    }

    private static void clone(final @NotNull Project project, final @NotNull Git git, final @Nullable CheckoutProvider.Listener listener, final @NotNull VirtualFile destinationParent, final @NotNull String sourceRepositoryUrl, final @NotNull String directoryName, final @NotNull String parentDirectory, final @Nullable String gcpUserName) {
        final AtomicBoolean cloneResult = new AtomicBoolean();
        new Task.Backgroundable(project, GctBundle.message("clonefromgcp.repository", sourceRepositoryUrl)){

            public void run(@NotNull ProgressIndicator indicator) {
                try (GcpHttpAuthDataProvider.Context context = GcpHttpAuthDataProvider.createContext(gcpUserName);){
                    cloneResult.set(GcpCheckoutProvider.doClone(project, indicator, git, directoryName, parentDirectory, sourceRepositoryUrl));
                }
            }

            public void onSuccess() {
                if (!cloneResult.get()) {
                    return;
                }
                destinationParent.refresh(true, true, new Runnable(){

                    @Override
                    public void run() {
                        if (project.isOpen() && !project.isDisposed() && !project.isDefault()) {
                            VcsDirtyScopeManager mgr = VcsDirtyScopeManager.getInstance((Project)project);
                            mgr.fileDirty(destinationParent);
                        }
                    }
                });
                ProjectManagerListener configWriter = new ProjectManagerListener(){

                    public void projectOpened(Project project) {
                        PropertiesComponent.getInstance((Project)project).setValue("com.google.gct.idea.git.username", gcpUserName == null ? "" : gcpUserName);
                    }

                    public boolean canCloseProject(Project project) {
                        return true;
                    }

                    public void projectClosed(Project project) {
                    }

                    public void projectClosing(Project project) {
                    }
                };
                ProjectManager.getInstance().addProjectManagerListener(configWriter);
                try {
                    if (listener != null) {
                        listener.directoryCheckedOut(new File(parentDirectory, directoryName), GitVcs.getKey());
                        listener.checkoutCompleted();
                    }
                }
                finally {
                    ProjectManager.getInstance().removeProjectManagerListener(configWriter);
                }
            }
        }.queue();
    }

    private static boolean doClone(@NotNull Project project, @NotNull ProgressIndicator indicator, @NotNull Git git, @NotNull String directoryName, @NotNull String parentDirectory, @NotNull String sourceRepositoryUrl) {
        indicator.setIndeterminate(false);
        GitLineHandlerListener progressListener = GitStandardProgressAnalyzer.createListener((ProgressIndicator)indicator);
        GitCommandResult result = git.clone(project, new File(parentDirectory), sourceRepositoryUrl, directoryName, new GitLineHandlerListener[]{progressListener});
        if (result.success()) {
            return true;
        }
        VcsNotifier.getInstance((Project)project).notifyError(GctBundle.message("clonefromgcp.failed", new Object[0]), result.getErrorOutputAsHtmlString() + "<br>" + result.getOutputAsJoinedString().replaceAll(URL_REGEX, "<a href=\"$0\">$0</a>"), (NotificationListener)new NotificationListener.UrlOpeningListener(true));
        return false;
    }
}

