/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.idea.debugger;

import com.google.gct.idea.debugger.CloudDebugConfigType;
import com.google.gct.idea.debugger.CloudDebugProcessState;
import com.google.gct.idea.debugger.CloudDebugRunConfiguration;
import com.google.gct.idea.debugger.actions.ToggleSnapshotLocationAction;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.HashMap;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="CloudDebugProcessStateSerializer", storages={@Storage(file="$WORKSPACE_FILE$")})
public class CloudDebugProcessStateSerializer
implements PersistentStateComponent<ProjectState> {
    private final Project myProject;
    private final Map<String, CloudDebugProcessState> myStateMap = new HashMap();

    private CloudDebugProcessStateSerializer(@NotNull Project project) {
        this.myProject = project;
        if (CloudDebugConfigType.isFeatureEnabled()) {
            EditorFactory.getInstance().addEditorFactoryListener(new EditorFactoryListener(){
                private final Map<Editor, TargetLineMouseAdapter> myMouseAdapterMap = new HashMap();

                public void editorCreated(@NotNull EditorFactoryEvent event) {
                    if (event.getEditor().getProject() == CloudDebugProcessStateSerializer.this.myProject && event.getEditor().getGutter() instanceof Component) {
                        Component gutterComponent = (Component)event.getEditor().getGutter();
                        TargetLineMouseAdapter adapter = new TargetLineMouseAdapter(event.getEditor());
                        assert (!this.myMouseAdapterMap.containsKey(event.getEditor()));
                        this.myMouseAdapterMap.put(event.getEditor(), adapter);
                        gutterComponent.addMouseListener(adapter);
                    }
                }

                public void editorReleased(@NotNull EditorFactoryEvent event) {
                    TargetLineMouseAdapter adapter = this.myMouseAdapterMap.get(event.getEditor());
                    if (adapter != null && event.getEditor().getGutter() instanceof Component) {
                        Component gutterComponent = (Component)event.getEditor().getGutter();
                        gutterComponent.removeMouseListener(adapter);
                        this.myMouseAdapterMap.remove(event.getEditor());
                    }
                }
            }, (Disposable)this.myProject);
        }
    }

    public static CloudDebugProcessStateSerializer getInstance(@NotNull Project project) {
        return (CloudDebugProcessStateSerializer)ServiceManager.getService((Project)project, CloudDebugProcessStateSerializer.class);
    }

    @Nullable
    public ProjectState getState() {
        ProjectState projectState = new ProjectState();
        if (CloudDebugConfigType.isFeatureEnabled()) {
            RunManager manager = RunManager.getInstance((Project)this.myProject);
            for (RunnerAndConfigurationSettings config : manager.getAllSettings()) {
                CloudDebugProcessState state;
                CloudDebugRunConfiguration cloudConfig;
                if (config.getConfiguration() == null || !(config.getConfiguration() instanceof CloudDebugRunConfiguration) || !(cloudConfig = (CloudDebugRunConfiguration)config.getConfiguration()).isShowNotifications() || (state = cloudConfig.getProcessState()) == null) continue;
                projectState.CONFIG_STATES.add(new RunConfigState(cloudConfig.getName(), state));
            }
        }
        return projectState;
    }

    public CloudDebugProcessState getState(@NotNull String runConfig, @NotNull String projectName) {
        CloudDebugProcessState state = this.myStateMap.get(runConfig);
        if (state != null && state.getProjectName() != null && state.getProjectName().equals(projectName)) {
            state.setProject(this.myProject);
            return state;
        }
        return null;
    }

    public void loadState(ProjectState state) {
        if (CloudDebugConfigType.isFeatureEnabled() && state.CONFIG_STATES != null) {
            for (RunConfigState configState : state.CONFIG_STATES) {
                this.myStateMap.put(configState.CONFIG_NAME, configState.PROCESS_STATE);
            }
        }
    }

    public static class RunConfigState {
        public String CONFIG_NAME;
        public CloudDebugProcessState PROCESS_STATE;

        public RunConfigState() {
        }

        public RunConfigState(String configName, CloudDebugProcessState state) {
            this.CONFIG_NAME = configName;
            this.PROCESS_STATE = state;
        }
    }

    public static class ProjectState {
        public List<RunConfigState> CONFIG_STATES = new ArrayList<RunConfigState>();
    }

    static class TargetLineMouseAdapter
    extends MouseAdapter {
        private final Editor myEditor;

        public TargetLineMouseAdapter(Editor editor) {
            this.myEditor = editor;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.myEditor.putUserData(ToggleSnapshotLocationAction.POPUP_LINE, (Object)new Integer(EditorUtil.yPositionToLogicalLine((Editor)this.myEditor, (Point)e.getPoint())));
            } else {
                this.myEditor.putUserData(ToggleSnapshotLocationAction.POPUP_LINE, null);
            }
        }
    }
}

