/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.idea.debugger;

import com.google.api.client.repackaged.com.google.common.base.Strings;
import com.google.api.services.debugger.model.Breakpoint;
import com.google.api.services.debugger.model.SourceLocation;
import java.util.Comparator;

public class BreakpointComparer
implements Comparator<Breakpoint> {
    private static final BreakpointComparer DEFAULT_INSTANCE = new BreakpointComparer();

    private BreakpointComparer() {
    }

    public static BreakpointComparer getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    @Override
    public int compare(Breakpoint o1, Breakpoint o2) {
        long s2Seconds;
        if (o2.getFinalTime() == null && o1.getFinalTime() != null) {
            return 1;
        }
        if (o2.getFinalTime() != null && o1.getFinalTime() == null) {
            return -1;
        }
        if (o2.getFinalTime() == null && o1.getFinalTime() == null) {
            SourceLocation s1 = o1.getLocation();
            SourceLocation s2 = o2.getLocation();
            boolean s1Valid = BreakpointComparer.isSourceLocationValid(s1);
            boolean s2Valid = BreakpointComparer.isSourceLocationValid(s2);
            if (!s1Valid && !s2Valid) {
                return 0;
            }
            if (s1Valid && !s2Valid) {
                return -1;
            }
            if (!s1Valid && s2Valid) {
                return 1;
            }
            if (s1.getPath().equals(s2.getPath())) {
                long s2Line;
                long s1Line = BreakpointComparer.toLongValue(s1.getLine().longValue());
                if (s1Line > (s2Line = BreakpointComparer.toLongValue(s2.getLine().longValue()))) {
                    return 1;
                }
                if (s1Line < s2Line) {
                    return -1;
                }
                return 0;
            }
            return s1.getPath().compareTo(s2.getPath());
        }
        long s1Seconds = BreakpointComparer.toLongValue(o1.getFinalTime().getSeconds());
        if (s1Seconds == (s2Seconds = BreakpointComparer.toLongValue(o2.getFinalTime().getSeconds()))) {
            int s2Nanos;
            int s1Nanos = BreakpointComparer.toIntValue(o1.getFinalTime().getNanos());
            if (s1Nanos == (s2Nanos = BreakpointComparer.toIntValue(o2.getFinalTime().getNanos()))) {
                return 0;
            }
            return s1Nanos < s2Nanos ? 1 : -1;
        }
        return s1Seconds < s2Seconds ? 1 : -1;
    }

    private static boolean isSourceLocationValid(SourceLocation sourceLocation) {
        if (sourceLocation == null) {
            return false;
        }
        if (Strings.isNullOrEmpty((String)sourceLocation.getPath())) {
            return false;
        }
        return sourceLocation.getLine() != null;
    }

    private static int toIntValue(Integer integer) {
        return integer != null ? integer : 0;
    }

    private static long toLongValue(Long longValue) {
        return longValue != null ? longValue : 0L;
    }
}

