/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge.bars;

import android.content.res.ColorStateList;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.layoutlib.bridge.Bridge;
import com.android.layoutlib.bridge.android.BridgeContext;
import com.android.layoutlib.bridge.android.BridgeXmlBlockParser;
import com.android.layoutlib.bridge.bars.Config;
import com.android.layoutlib.bridge.impl.ResourceHelper;
import com.android.layoutlib.bridge.resources.IconLoader;
import com.android.layoutlib.bridge.resources.SysUiResources;
import com.android.resources.Density;
import com.android.resources.LayoutDirection;
import com.android.resources.ResourceType;
import java.io.InputStream;

abstract class CustomBar
extends LinearLayout {
    private final int mSimulatedPlatformVersion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CustomBar(BridgeContext context, int orientation, String layoutName, int simulatedPlatformVersion) {
        super(context);
        this.mSimulatedPlatformVersion = simulatedPlatformVersion;
        this.setOrientation(orientation);
        if (orientation == 0) {
            this.setGravity(16);
        } else {
            this.setGravity(1);
        }
        LayoutInflater inflater = LayoutInflater.from(this.mContext);
        BridgeXmlBlockParser bridgeParser = this.loadXml(layoutName);
        try {
            inflater.inflate(bridgeParser, (ViewGroup)this, true);
        }
        finally {
            bridgeParser.ensurePopped();
        }
    }

    protected abstract TextView getStyleableTextView();

    protected BridgeXmlBlockParser loadXml(String layoutName) {
        return SysUiResources.loadXml((BridgeContext)this.mContext, this.mSimulatedPlatformVersion, layoutName);
    }

    protected ImageView loadIcon(ImageView imageView, String iconName, Density density) {
        return SysUiResources.loadIcon(this.mContext, this.mSimulatedPlatformVersion, imageView, iconName, density, false);
    }

    protected ImageView loadIcon(int index, String iconName, Density density, boolean isRtl) {
        View child = this.getChildAt(index);
        if (child instanceof ImageView) {
            ImageView imageView = (ImageView)child;
            return SysUiResources.loadIcon(this.mContext, this.mSimulatedPlatformVersion, imageView, iconName, density, isRtl);
        }
        return null;
    }

    protected ImageView loadIcon(ImageView imageView, String iconName, Density density, boolean isRtl) {
        Object dir = isRtl ? LayoutDirection.RTL : null;
        IconLoader iconLoader = new IconLoader(iconName, density, this.mSimulatedPlatformVersion, (LayoutDirection)dir);
        InputStream stream = iconLoader.getIcon();
        if (stream != null) {
            density = iconLoader.getDensity();
            String path = iconLoader.getPath();
            Bitmap bitmap = Bridge.getCachedBitmap(path, Boolean.TRUE);
            if (bitmap == null) {
                BitmapFactory.Options options = new BitmapFactory.Options();
                options.inDensity = density.getDpiValue();
                bitmap = BitmapFactory.decodeStream(stream, null, options);
                Bridge.setCachedBitmap(path, bitmap, Boolean.TRUE);
            }
            if (bitmap != null) {
                BitmapDrawable drawable2 = new BitmapDrawable(this.getContext().getResources(), bitmap);
                imageView.setImageDrawable(drawable2);
            }
        }
        return imageView;
    }

    protected TextView setText(int index, String string2) {
        View child = this.getChildAt(index);
        if (child instanceof TextView) {
            TextView textView = (TextView)child;
            textView.setText(string2);
            return textView;
        }
        return null;
    }

    protected void setStyle(String themeEntryName) {
        TextView textView;
        Drawable d;
        BridgeContext bridgeContext = this.getContext();
        RenderResources res = bridgeContext.getRenderResources();
        ResourceValue value = res.findItemInTheme(BridgeContext.createFrameworkAttrReference(themeEntryName));
        if (!((value = res.resolveResValue(value)) instanceof StyleResourceValue)) {
            return;
        }
        StyleResourceValue style2 = (StyleResourceValue)value;
        ResourceValue backgroundValue = res.findItemInStyle(style2, BridgeContext.createFrameworkAttrReference("background"));
        if ((backgroundValue = res.resolveResValue(backgroundValue)) != null && (d = ResourceHelper.getDrawable(backgroundValue, bridgeContext)) != null) {
            this.setBackground(d);
        }
        if ((textView = this.getStyleableTextView()) != null) {
            ResourceValue textStyleValue = res.findItemInStyle(style2, BridgeContext.createFrameworkAttrReference("titleTextStyle"));
            if ((textStyleValue = res.resolveResValue(textStyleValue)) instanceof StyleResourceValue) {
                ColorStateList stateList;
                StyleResourceValue textStyle = (StyleResourceValue)textStyleValue;
                ResourceValue textSize = res.findItemInStyle(textStyle, BridgeContext.createFrameworkAttrReference("textSize"));
                if ((textSize = res.resolveResValue(textSize)) != null) {
                    TypedValue out = new TypedValue();
                    if (ResourceHelper.parseFloatAttribute("textSize", textSize.getValue(), out, true)) {
                        textView.setTextSize(0, out.getDimension(bridgeContext.getResources().getDisplayMetrics()));
                    }
                }
                ResourceValue textColor = res.findItemInStyle(textStyle, BridgeContext.createFrameworkAttrReference("textColor"));
                if ((textColor = res.resolveResValue(textColor)) != null && (stateList = ResourceHelper.getColorStateList(textColor, bridgeContext, null)) != null) {
                    textView.setTextColor(stateList);
                }
            }
        }
    }

    @Override
    public BridgeContext getContext() {
        return (BridgeContext)this.mContext;
    }

    protected int getBarColor(String colorAttrName, String translucentAttrName) {
        if (!Config.isGreaterOrEqual(this.mSimulatedPlatformVersion, 21)) {
            return 0;
        }
        RenderResources renderResources = this.getContext().getRenderResources();
        boolean translucent = ResourceHelper.getBooleanThemeFrameworkAttrValue(renderResources, translucentAttrName, false);
        if (translucent) {
            return 0x66000000;
        }
        boolean transparent = ResourceHelper.getBooleanThemeFrameworkAttrValue(renderResources, "windowDrawsSystemBarBackgrounds", false);
        if (transparent) {
            return CustomBar.getColor(renderResources, colorAttrName);
        }
        return 0;
    }

    private static int getColor(RenderResources renderResources, String attr2) {
        ResourceType type;
        ResourceValue resource = renderResources.findItemInTheme(BridgeContext.createFrameworkAttrReference(attr2));
        if ((resource = renderResources.resolveResValue(resource)) != null && ((type = resource.getResourceType()) == null || type == ResourceType.COLOR)) {
            try {
                return ResourceHelper.getColor(resource.getValue());
            }
            catch (NumberFormatException e) {
                Bridge.getLog().warning("resources.format", "Theme attribute @android:" + attr2 + " does not reference a color, instead is '" + resource.getValue() + "'.", null, (Object)resource);
            }
        }
        return 0;
    }
}

