/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.net.LocalServerSocket;
import android.net.LocalSocket;
import android.os.SystemClock;
import android.os.Trace;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.system.StructPollfd;
import android.util.Log;
import android.util.Slog;
import com.android.internal.lang.System_Delegate;
import com.android.internal.os.Zygote;
import com.android.internal.os.ZygoteConnection;
import dalvik.system.ZygoteHooks;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.FileDescriptor;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.function.ToIntFunction;

class ZygoteServer {
    public static final String TAG = "ZygoteServer";
    private static final int USAP_POOL_SIZE_MAX_LIMIT = 100;
    private static final int USAP_POOL_SIZE_MIN_LIMIT = 1;
    private static final String USAP_POOL_SIZE_MAX_DEFAULT = "10";
    private static final String USAP_POOL_SIZE_MIN_DEFAULT = "1";
    private static final String USAP_POOL_REFILL_DELAY_MS_DEFAULT = "3000";
    private static final int INVALID_TIMESTAMP = -1;
    private final boolean mUsapPoolSupported;
    private boolean mUsapPoolEnabled = false;
    private LocalServerSocket mZygoteSocket;
    private final LocalServerSocket mUsapPoolSocket;
    private final FileDescriptor mUsapPoolEventFD;
    private boolean mCloseSocketFd;
    private boolean mIsForkChild;
    private int mUsapPoolSizeMax = 0;
    private int mUsapPoolSizeMin = 0;
    private int mUsapPoolRefillThreshold = 0;
    private int mUsapPoolRefillDelayMs = -1;
    private UsapPoolRefillAction mUsapPoolRefillAction;
    private long mUsapPoolRefillTriggerTimestamp;
    private boolean mIsFirstPropertyCheck = true;
    private long mLastPropCheckTimestamp = 0L;

    ZygoteServer() {
        this.mUsapPoolEventFD = null;
        this.mZygoteSocket = null;
        this.mUsapPoolSocket = null;
        this.mUsapPoolSupported = false;
    }

    ZygoteServer(boolean isPrimaryZygote) {
        this.mUsapPoolEventFD = Zygote.getUsapPoolEventFD();
        if (isPrimaryZygote) {
            this.mZygoteSocket = Zygote.createManagedSocketFromInitSocket("zygote");
            this.mUsapPoolSocket = Zygote.createManagedSocketFromInitSocket("usap_pool_primary");
        } else {
            this.mZygoteSocket = Zygote.createManagedSocketFromInitSocket("zygote_secondary");
            this.mUsapPoolSocket = Zygote.createManagedSocketFromInitSocket("usap_pool_secondary");
        }
        this.mUsapPoolSupported = true;
        this.fetchUsapPoolPolicyProps();
    }

    void setForkChild() {
        this.mIsForkChild = true;
    }

    public boolean isUsapPoolEnabled() {
        return this.mUsapPoolEnabled;
    }

    void registerServerSocketAtAbstractName(String socketName) {
        if (this.mZygoteSocket == null) {
            try {
                this.mZygoteSocket = new LocalServerSocket(socketName);
                this.mCloseSocketFd = false;
            }
            catch (IOException ex) {
                throw new RuntimeException("Error binding to abstract socket '" + socketName + "'", ex);
            }
        }
    }

    private ZygoteConnection acceptCommandPeer(String abiList) {
        try {
            return this.createNewConnection(this.mZygoteSocket.accept(), abiList);
        }
        catch (IOException ex) {
            throw new RuntimeException("IOException during accept()", ex);
        }
    }

    protected ZygoteConnection createNewConnection(LocalSocket socket, String abiList) throws IOException {
        return new ZygoteConnection(socket, abiList);
    }

    void closeServerSocket() {
        try {
            if (this.mZygoteSocket != null) {
                FileDescriptor fd = this.mZygoteSocket.getFileDescriptor();
                this.mZygoteSocket.close();
                if (fd != null && this.mCloseSocketFd) {
                    Os.close(fd);
                }
            }
        }
        catch (IOException ex) {
            Log.e(TAG, "Zygote:  error closing sockets", ex);
        }
        catch (ErrnoException ex) {
            Log.e(TAG, "Zygote:  error closing descriptor", ex);
        }
        this.mZygoteSocket = null;
    }

    FileDescriptor getZygoteSocketFileDescriptor() {
        return this.mZygoteSocket.getFileDescriptor();
    }

    private void fetchUsapPoolPolicyProps() {
        if (this.mUsapPoolSupported) {
            String usapPoolRefillDelayMsPropString;
            String usapPoolRefillThresholdPropString;
            String usapPoolSizeMinPropString;
            String usapPoolSizeMaxPropString = Zygote.getConfigurationProperty("usap_pool_size_max", USAP_POOL_SIZE_MAX_DEFAULT);
            if (!usapPoolSizeMaxPropString.isEmpty()) {
                this.mUsapPoolSizeMax = Integer.min(Integer.parseInt(usapPoolSizeMaxPropString), 100);
            }
            if (!(usapPoolSizeMinPropString = Zygote.getConfigurationProperty("usap_pool_size_min", USAP_POOL_SIZE_MIN_DEFAULT)).isEmpty()) {
                this.mUsapPoolSizeMin = Integer.max(Integer.parseInt(usapPoolSizeMinPropString), 1);
            }
            if (!(usapPoolRefillThresholdPropString = Zygote.getConfigurationProperty("usap_refill_threshold", Integer.toString(this.mUsapPoolSizeMax / 2))).isEmpty()) {
                this.mUsapPoolRefillThreshold = Integer.min(Integer.parseInt(usapPoolRefillThresholdPropString), this.mUsapPoolSizeMax);
            }
            if (!(usapPoolRefillDelayMsPropString = Zygote.getConfigurationProperty("usap_pool_refill_delay_ms", USAP_POOL_REFILL_DELAY_MS_DEFAULT)).isEmpty()) {
                this.mUsapPoolRefillDelayMs = Integer.parseInt(usapPoolRefillDelayMsPropString);
            }
            if (this.mUsapPoolSizeMin >= this.mUsapPoolSizeMax) {
                Log.w(TAG, "The max size of the USAP pool must be greater than the minimum size.  Restoring default values.");
                this.mUsapPoolSizeMax = Integer.parseInt(USAP_POOL_SIZE_MAX_DEFAULT);
                this.mUsapPoolSizeMin = Integer.parseInt(USAP_POOL_SIZE_MIN_DEFAULT);
                this.mUsapPoolRefillThreshold = this.mUsapPoolSizeMax / 2;
            }
        }
    }

    private void fetchUsapPoolPolicyPropsWithMinInterval() {
        long currentTimestamp = SystemClock.elapsedRealtime();
        if (this.mIsFirstPropertyCheck || currentTimestamp - this.mLastPropCheckTimestamp >= 60000L) {
            this.mIsFirstPropertyCheck = false;
            this.mLastPropCheckTimestamp = currentTimestamp;
            this.fetchUsapPoolPolicyProps();
        }
    }

    private void fetchUsapPoolPolicyPropsIfUnfetched() {
        if (this.mIsFirstPropertyCheck) {
            this.mIsFirstPropertyCheck = false;
            this.fetchUsapPoolPolicyProps();
        }
    }

    Runnable fillUsapPool(int[] sessionSocketRawFDs, boolean isPriorityRefill) {
        int numUsapsToSpawn;
        Trace.traceBegin(64L, "Zygote:FillUsapPool");
        this.fetchUsapPoolPolicyPropsIfUnfetched();
        int usapPoolCount = Zygote.getUsapPoolCount();
        if (isPriorityRefill) {
            numUsapsToSpawn = this.mUsapPoolSizeMin - usapPoolCount;
            Log.i("zygote", "Priority USAP Pool refill. New USAPs: " + numUsapsToSpawn);
        } else {
            numUsapsToSpawn = this.mUsapPoolSizeMax - usapPoolCount;
            Log.i("zygote", "Delayed USAP Pool refill. New USAPs: " + numUsapsToSpawn);
        }
        ZygoteHooks.preFork();
        while (--numUsapsToSpawn >= 0) {
            Runnable caller = Zygote.forkUsap(this.mUsapPoolSocket, sessionSocketRawFDs, isPriorityRefill);
            if (caller == null) continue;
            return caller;
        }
        ZygoteHooks.postForkCommon();
        this.resetUsapRefillState();
        Trace.traceEnd(64L);
        return null;
    }

    Runnable setUsapPoolStatus(boolean newStatus, LocalSocket sessionSocket) {
        if (!this.mUsapPoolSupported) {
            Log.w(TAG, "Attempting to enable a USAP pool for a Zygote that doesn't support it.");
            return null;
        }
        if (this.mUsapPoolEnabled == newStatus) {
            return null;
        }
        Log.i(TAG, "USAP Pool status change: " + (newStatus ? "ENABLED" : "DISABLED"));
        this.mUsapPoolEnabled = newStatus;
        if (newStatus) {
            return this.fillUsapPool(new int[]{sessionSocket.getFileDescriptor().getInt$()}, false);
        }
        Zygote.emptyUsapPool();
        return null;
    }

    void resetUsapRefillState() {
        this.mUsapPoolRefillAction = UsapPoolRefillAction.NONE;
        this.mUsapPoolRefillTriggerTimestamp = -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    Runnable runSelectLoop(String abiList) {
        ArrayList<FileDescriptor> socketFDs = new ArrayList<FileDescriptor>();
        ArrayList<ZygoteConnection> peers = new ArrayList<ZygoteConnection>();
        socketFDs.add(this.mZygoteSocket.getFileDescriptor());
        peers.add(null);
        this.mUsapPoolRefillTriggerTimestamp = -1L;
        while (true) {
            boolean isPriorityRefill;
            Runnable command;
            int pollReturnValue;
            StructPollfd[] pollFDs;
            this.fetchUsapPoolPolicyPropsWithMinInterval();
            this.mUsapPoolRefillAction = UsapPoolRefillAction.NONE;
            int[] usapPipeFDs = null;
            if (this.mUsapPoolEnabled) {
                usapPipeFDs = Zygote.getUsapPipeFDs();
                pollFDs = new StructPollfd[socketFDs.size() + 1 + usapPipeFDs.length];
            } else {
                pollFDs = new StructPollfd[socketFDs.size()];
            }
            int pollIndex = 0;
            for (FileDescriptor fileDescriptor : socketFDs) {
                pollFDs[pollIndex] = new StructPollfd();
                pollFDs[pollIndex].fd = fileDescriptor;
                pollFDs[pollIndex].events = (short)OsConstants.POLLIN;
                ++pollIndex;
            }
            int usapPoolEventFDIndex = pollIndex;
            if (this.mUsapPoolEnabled) {
                pollFDs[pollIndex] = new StructPollfd();
                pollFDs[pollIndex].fd = this.mUsapPoolEventFD;
                pollFDs[pollIndex].events = (short)OsConstants.POLLIN;
                ++pollIndex;
                assert (usapPipeFDs != null);
                for (int usapPipeFD : usapPipeFDs) {
                    FileDescriptor managedFd = new FileDescriptor();
                    managedFd.setInt$(usapPipeFD);
                    pollFDs[pollIndex] = new StructPollfd();
                    pollFDs[pollIndex].fd = managedFd;
                    pollFDs[pollIndex].events = (short)OsConstants.POLLIN;
                    ++pollIndex;
                }
            }
            if (this.mUsapPoolRefillTriggerTimestamp == -1L) {
                int n = -1;
            } else {
                long elapsedTimeMs = System_Delegate.currentTimeMillis() - this.mUsapPoolRefillTriggerTimestamp;
                if (elapsedTimeMs >= (long)this.mUsapPoolRefillDelayMs) {
                    int n = -1;
                } else if (elapsedTimeMs <= 0L) {
                    int n = this.mUsapPoolRefillDelayMs;
                } else {
                    int n = (int)((long)this.mUsapPoolRefillDelayMs - elapsedTimeMs);
                }
            }
            try {
                void var8_9;
                pollReturnValue = Os.poll(pollFDs, (int)var8_9);
            }
            catch (ErrnoException ex) {
                throw new RuntimeException("poll failed", ex);
            }
            if (pollReturnValue == 0) {
                this.mUsapPoolRefillTriggerTimestamp = -1L;
                this.mUsapPoolRefillAction = UsapPoolRefillAction.DELAYED;
            } else {
                boolean usapPoolFDRead = false;
                while (--pollIndex >= 0) {
                    long messagePayload;
                    block40: {
                        if ((pollFDs[pollIndex].revents & OsConstants.POLLIN) == 0) continue;
                        if (pollIndex == 0) {
                            ZygoteConnection newPeer = this.acceptCommandPeer(abiList);
                            peers.add(newPeer);
                            socketFDs.add(newPeer.getFileDescriptor());
                            continue;
                        }
                        if (pollIndex < usapPoolEventFDIndex) {
                            try {
                                ZygoteConnection connection = (ZygoteConnection)peers.get(pollIndex);
                                command = connection.processOneCommand(this);
                                if (this.mIsForkChild) {
                                    if (command == null) {
                                        throw new IllegalStateException("command == null");
                                    }
                                    Runnable runnable = command;
                                    return runnable;
                                }
                                if (command != null) {
                                    throw new IllegalStateException("command != null");
                                }
                                if (!connection.isClosedByPeer()) continue;
                                connection.closeSocket();
                                peers.remove(pollIndex);
                                socketFDs.remove(pollIndex);
                                continue;
                            }
                            catch (Exception e) {
                                if (!this.mIsForkChild) {
                                    Slog.e(TAG, "Exception executing zygote command: ", e);
                                    ZygoteConnection conn = (ZygoteConnection)peers.remove(pollIndex);
                                    conn.closeSocket();
                                    socketFDs.remove(pollIndex);
                                    continue;
                                }
                                Log.e(TAG, "Caught post-fork exception in child process.", e);
                                throw e;
                            }
                            finally {
                                this.mIsForkChild = false;
                                continue;
                            }
                        }
                        try {
                            byte[] buffer = new byte[8];
                            int readBytes = Os.read(pollFDs[pollIndex].fd, buffer, 0, buffer.length);
                            if (readBytes == 8) {
                                DataInputStream inputStream = new DataInputStream(new ByteArrayInputStream(buffer));
                                messagePayload = inputStream.readLong();
                                break block40;
                            }
                            Log.e(TAG, "Incomplete read from USAP management FD of size " + readBytes);
                        }
                        catch (Exception ex) {
                            if (pollIndex == usapPoolEventFDIndex) {
                                Log.e(TAG, "Failed to read from USAP pool event FD: " + ex.getMessage());
                                continue;
                            }
                            Log.e(TAG, "Failed to read from USAP reporting pipe: " + ex.getMessage());
                        }
                        continue;
                    }
                    if (pollIndex > usapPoolEventFDIndex) {
                        Zygote.removeUsapTableEntry((int)messagePayload);
                    }
                    usapPoolFDRead = true;
                }
                if (usapPoolFDRead) {
                    int usapPoolCount = Zygote.getUsapPoolCount();
                    if (usapPoolCount < this.mUsapPoolSizeMin) {
                        this.mUsapPoolRefillAction = UsapPoolRefillAction.IMMEDIATE;
                    } else if (this.mUsapPoolSizeMax - usapPoolCount >= this.mUsapPoolRefillThreshold) {
                        this.mUsapPoolRefillTriggerTimestamp = System_Delegate.currentTimeMillis();
                    }
                }
            }
            if (this.mUsapPoolRefillAction == UsapPoolRefillAction.NONE) continue;
            int[] sessionSocketRawFDs = socketFDs.subList(1, socketFDs.size()).stream().mapToInt((ToIntFunction<FileDescriptor>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)I, getInt$(), (Ljava/io/FileDescriptor;)I)()).toArray();
            command = this.fillUsapPool(sessionSocketRawFDs, isPriorityRefill = this.mUsapPoolRefillAction == UsapPoolRefillAction.IMMEDIATE);
            if (command != null) {
                return command;
            }
            if (!isPriorityRefill) continue;
            this.mUsapPoolRefillTriggerTimestamp = System_Delegate.currentTimeMillis();
        }
    }

    private static enum UsapPoolRefillAction {
        DELAYED,
        IMMEDIATE,
        NONE;

    }
}

