/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.BatteryStats;
import com.android.internal.os.BatterySipper;
import com.android.internal.os.PowerCalculator;
import com.android.internal.os.PowerProfile;

public class FlashlightPowerCalculator
extends PowerCalculator {
    private final double mFlashlightPowerOnAvg;

    public FlashlightPowerCalculator(PowerProfile profile) {
        this.mFlashlightPowerOnAvg = profile.getAveragePower("camera.flashlight");
    }

    @Override
    public void calculateApp(BatterySipper app, BatteryStats.Uid u, long rawRealtimeUs, long rawUptimeUs, int statsType) {
        BatteryStats.Timer timer = u.getFlashlightTurnedOnTimer();
        if (timer != null) {
            long totalTime;
            app.flashlightTimeMs = totalTime = timer.getTotalTimeLocked(rawRealtimeUs, statsType) / 1000L;
            app.flashlightPowerMah = (double)totalTime * this.mFlashlightPowerOnAvg / 3600000.0;
        } else {
            app.flashlightTimeMs = 0L;
            app.flashlightPowerMah = 0.0;
        }
    }
}

