/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.content.Context;
import android.content.res.Resources;
import android.os.UserHandle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ListView;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.app.AbstractMultiProfilePagerAdapter;
import com.android.internal.app.ResolverListAdapter;

@VisibleForTesting
public class ResolverMultiProfilePagerAdapter
extends AbstractMultiProfilePagerAdapter {
    private final ResolverProfileDescriptor[] mItems;
    private final boolean mShouldShowNoCrossProfileIntentsEmptyState;
    private boolean mUseLayoutWithDefault;

    ResolverMultiProfilePagerAdapter(Context context, ResolverListAdapter adapter, UserHandle personalProfileUserHandle, UserHandle workProfileUserHandle) {
        super(context, 0, personalProfileUserHandle, workProfileUserHandle);
        this.mItems = new ResolverProfileDescriptor[]{this.createProfileDescriptor(adapter)};
        this.mShouldShowNoCrossProfileIntentsEmptyState = true;
    }

    ResolverMultiProfilePagerAdapter(Context context, ResolverListAdapter personalAdapter, ResolverListAdapter workAdapter, @AbstractMultiProfilePagerAdapter.Profile int defaultProfile, UserHandle personalProfileUserHandle, UserHandle workProfileUserHandle, boolean shouldShowNoCrossProfileIntentsEmptyState) {
        super(context, defaultProfile, personalProfileUserHandle, workProfileUserHandle);
        this.mItems = new ResolverProfileDescriptor[]{this.createProfileDescriptor(personalAdapter), this.createProfileDescriptor(workAdapter)};
        this.mShouldShowNoCrossProfileIntentsEmptyState = shouldShowNoCrossProfileIntentsEmptyState;
    }

    @Override
    void updateAfterConfigChange() {
        super.updateAfterConfigChange();
        for (ResolverProfileDescriptor descriptor : this.mItems) {
            Object emptyStateCont = descriptor.rootView.findViewById(16909350);
            Resources resources = this.getContext().getResources();
            ((View)emptyStateCont).setPadding(((View)emptyStateCont).getPaddingLeft(), resources.getDimensionPixelSize(17105439), ((View)emptyStateCont).getPaddingRight(), resources.getDimensionPixelSize(17105438));
        }
    }

    private ResolverProfileDescriptor createProfileDescriptor(ResolverListAdapter adapter) {
        LayoutInflater inflater = LayoutInflater.from(this.getContext());
        ViewGroup rootView = (ViewGroup)inflater.inflate(17367275, null, false);
        return new ResolverProfileDescriptor(rootView, adapter);
    }

    ListView getListViewForIndex(int index) {
        return this.getItem((int)index).listView;
    }

    @Override
    ResolverProfileDescriptor getItem(int pageIndex) {
        return this.mItems[pageIndex];
    }

    @Override
    int getItemCount() {
        return this.mItems.length;
    }

    @Override
    void setupListAdapter(int pageIndex) {
        ListView listView = this.getItem((int)pageIndex).listView;
        listView.setAdapter(this.getItem(pageIndex).resolverListAdapter);
    }

    @Override
    @VisibleForTesting
    public ResolverListAdapter getAdapterForIndex(int pageIndex) {
        return this.mItems[pageIndex].resolverListAdapter;
    }

    @Override
    public ViewGroup instantiateItem(ViewGroup container, int position) {
        this.setupListAdapter(position);
        return super.instantiateItem(container, position);
    }

    @Override
    ResolverListAdapter getListAdapterForUserHandle(UserHandle userHandle) {
        if (this.getActiveListAdapter().getUserHandle().equals(userHandle)) {
            return this.getActiveListAdapter();
        }
        if (this.getInactiveListAdapter() != null && this.getInactiveListAdapter().getUserHandle().equals(userHandle)) {
            return this.getInactiveListAdapter();
        }
        return null;
    }

    @Override
    @VisibleForTesting
    public ResolverListAdapter getActiveListAdapter() {
        return this.getAdapterForIndex(this.getCurrentPage());
    }

    @Override
    @VisibleForTesting
    public ResolverListAdapter getInactiveListAdapter() {
        if (this.getCount() == 1) {
            return null;
        }
        return this.getAdapterForIndex(1 - this.getCurrentPage());
    }

    @Override
    public ResolverListAdapter getPersonalListAdapter() {
        return this.getAdapterForIndex(0);
    }

    @Override
    public ResolverListAdapter getWorkListAdapter() {
        return this.getAdapterForIndex(1);
    }

    @Override
    ResolverListAdapter getCurrentRootAdapter() {
        return this.getActiveListAdapter();
    }

    @Override
    ListView getActiveAdapterView() {
        return this.getListViewForIndex(this.getCurrentPage());
    }

    @Override
    ViewGroup getInactiveAdapterView() {
        if (this.getCount() == 1) {
            return null;
        }
        return this.getListViewForIndex(1 - this.getCurrentPage());
    }

    @Override
    String getMetricsCategory() {
        return "intent_resolver";
    }

    @Override
    boolean allowShowNoCrossProfileIntentsEmptyState() {
        return this.mShouldShowNoCrossProfileIntentsEmptyState;
    }

    @Override
    protected void showWorkProfileOffEmptyState(ResolverListAdapter activeListAdapter, View.OnClickListener listener) {
        this.showEmptyState(activeListAdapter, 17302875, 17041169, 0, listener);
    }

    @Override
    protected void showNoPersonalToWorkIntentsEmptyState(ResolverListAdapter activeListAdapter) {
        this.showEmptyState(activeListAdapter, 17302823, 17041153, 17041154);
    }

    @Override
    protected void showNoWorkToPersonalIntentsEmptyState(ResolverListAdapter activeListAdapter) {
        this.showEmptyState(activeListAdapter, 17302823, 17041151, 17041152);
    }

    @Override
    protected void showNoPersonalAppsAvailableEmptyState(ResolverListAdapter listAdapter) {
        this.showEmptyState(listAdapter, 17302753, 17041162, 0);
    }

    @Override
    protected void showNoWorkAppsAvailableEmptyState(ResolverListAdapter listAdapter) {
        this.showEmptyState(listAdapter, 17302753, 17041164, 0);
    }

    void setUseLayoutWithDefault(boolean useLayoutWithDefault) {
        this.mUseLayoutWithDefault = useLayoutWithDefault;
    }

    @Override
    protected void setupContainerPadding(View container) {
        int bottom = this.mUseLayoutWithDefault ? container.getPaddingBottom() : 0;
        container.setPadding(container.getPaddingLeft(), container.getPaddingTop(), container.getPaddingRight(), bottom);
    }

    class ResolverProfileDescriptor
    extends AbstractMultiProfilePagerAdapter.ProfileDescriptor {
        private ResolverListAdapter resolverListAdapter;
        final ListView listView;

        ResolverProfileDescriptor(ViewGroup rootView, ResolverListAdapter adapter) {
            super(rootView);
            this.resolverListAdapter = adapter;
            this.listView = (ListView)rootView.findViewById(16909355);
        }
    }
}

