/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.app.RemoteAction;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.PointF;
import android.graphics.RectF;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.LocaleList;
import android.text.Layout;
import android.text.Selection;
import android.text.Spannable;
import android.text.TextUtils;
import android.text.util.Linkify;
import android.util.EventLog;
import android.util.Log;
import android.view.ActionMode;
import android.view.textclassifier.ExtrasUtils;
import android.view.textclassifier.SelectionEvent;
import android.view.textclassifier.TextClassification;
import android.view.textclassifier.TextClassificationConstants;
import android.view.textclassifier.TextClassificationContext;
import android.view.textclassifier.TextClassificationManager;
import android.view.textclassifier.TextClassifier;
import android.view.textclassifier.TextClassifierEvent;
import android.view.textclassifier.TextSelection;
import android.widget.Editor;
import android.widget.SmartSelectSprite;
import android.widget.TextView;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.Preconditions;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;

@VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
public class SelectionActionModeHelper {
    private static final String LOG_TAG = "SelectActionModeHelper";
    private final Editor mEditor;
    private final TextView mTextView;
    private final TextClassificationHelper mTextClassificationHelper;
    private TextClassification mTextClassification;
    private AsyncTask mTextClassificationAsyncTask;
    private final SelectionTracker mSelectionTracker;
    private final SmartSelectSprite mSmartSelectSprite;

    SelectionActionModeHelper(Editor editor) {
        this.mEditor = Objects.requireNonNull(editor);
        this.mTextView = this.mEditor.getTextView();
        this.mTextClassificationHelper = new TextClassificationHelper(this.mTextView.getContext(), this.mTextView::getTextClassificationSession, SelectionActionModeHelper.getText(this.mTextView), 0, 1, this.mTextView.getTextLocales());
        this.mSelectionTracker = new SelectionTracker(this.mTextView);
        this.mSmartSelectSprite = this.getTextClassificationSettings().isSmartSelectionAnimationEnabled() ? new SmartSelectSprite(this.mTextView.getContext(), editor.getTextView().mHighlightColor, this.mTextView::invalidate) : null;
    }

    private static int[] sortSelctionIndices(int selectionStart, int selectionEnd) {
        if (selectionStart < selectionEnd) {
            return new int[]{selectionStart, selectionEnd};
        }
        return new int[]{selectionEnd, selectionStart};
    }

    private static int[] sortSelctionIndicesFromTextView(TextView textView) {
        int selectionStart = textView.getSelectionStart();
        int selectionEnd = textView.getSelectionEnd();
        return SelectionActionModeHelper.sortSelctionIndices(selectionStart, selectionEnd);
    }

    public void startSelectionActionModeAsync(boolean adjustSelection) {
        adjustSelection &= this.getTextClassificationSettings().isSmartSelectionEnabled();
        int[] sortedSelectionIndices = SelectionActionModeHelper.sortSelctionIndicesFromTextView(this.mTextView);
        this.mSelectionTracker.onOriginalSelection(SelectionActionModeHelper.getText(this.mTextView), sortedSelectionIndices[0], sortedSelectionIndices[1], false);
        this.cancelAsyncTask();
        if (this.skipTextClassification()) {
            this.startSelectionActionMode(null);
        } else {
            this.resetTextClassificationHelper();
            this.mTextClassificationAsyncTask = new TextClassificationAsyncTask(this.mTextView, this.mTextClassificationHelper.getTimeoutDuration(), adjustSelection ? this.mTextClassificationHelper::suggestSelection : this.mTextClassificationHelper::classifyText, this.mSmartSelectSprite != null ? this::startSelectionActionModeWithSmartSelectAnimation : this::startSelectionActionMode, this.mTextClassificationHelper::getOriginalSelection).execute(new Void[0]);
        }
    }

    public void startLinkActionModeAsync(int start, int end) {
        int[] indexResult = SelectionActionModeHelper.sortSelctionIndices(start, end);
        this.mSelectionTracker.onOriginalSelection(SelectionActionModeHelper.getText(this.mTextView), indexResult[0], indexResult[1], true);
        this.cancelAsyncTask();
        if (this.skipTextClassification()) {
            this.startLinkActionMode(null);
        } else {
            this.resetTextClassificationHelper(indexResult[0], indexResult[1]);
            this.mTextClassificationAsyncTask = new TextClassificationAsyncTask(this.mTextView, this.mTextClassificationHelper.getTimeoutDuration(), this.mTextClassificationHelper::classifyText, this::startLinkActionMode, this.mTextClassificationHelper::getOriginalSelection).execute(new Void[0]);
        }
    }

    public void invalidateActionModeAsync() {
        this.cancelAsyncTask();
        if (this.skipTextClassification()) {
            this.invalidateActionMode(null);
        } else {
            this.resetTextClassificationHelper();
            this.mTextClassificationAsyncTask = new TextClassificationAsyncTask(this.mTextView, this.mTextClassificationHelper.getTimeoutDuration(), this.mTextClassificationHelper::classifyText, this::invalidateActionMode, this.mTextClassificationHelper::getOriginalSelection).execute(new Void[0]);
        }
    }

    public void onSelectionAction(int menuItemId, String actionLabel) {
        int[] sortedSelectionIndices = SelectionActionModeHelper.sortSelctionIndicesFromTextView(this.mTextView);
        this.mSelectionTracker.onSelectionAction(sortedSelectionIndices[0], sortedSelectionIndices[1], SelectionActionModeHelper.getActionType(menuItemId), actionLabel, this.mTextClassification);
    }

    public void onSelectionDrag() {
        int[] sortedSelectionIndices = SelectionActionModeHelper.sortSelctionIndicesFromTextView(this.mTextView);
        this.mSelectionTracker.onSelectionAction(sortedSelectionIndices[0], sortedSelectionIndices[1], 106, null, this.mTextClassification);
    }

    public void onTextChanged(int start, int end) {
        int[] sortedSelectionIndices = SelectionActionModeHelper.sortSelctionIndices(start, end);
        this.mSelectionTracker.onTextChanged(sortedSelectionIndices[0], sortedSelectionIndices[1], this.mTextClassification);
    }

    public boolean resetSelection(int textIndex) {
        if (this.mSelectionTracker.resetSelection(textIndex, this.mEditor)) {
            this.invalidateActionModeAsync();
            return true;
        }
        return false;
    }

    public TextClassification getTextClassification() {
        return this.mTextClassification;
    }

    public void onDestroyActionMode() {
        this.cancelSmartSelectAnimation();
        this.mSelectionTracker.onSelectionDestroyed();
        this.cancelAsyncTask();
    }

    public void onDraw(Canvas canvas) {
        if (this.isDrawingHighlight() && this.mSmartSelectSprite != null) {
            this.mSmartSelectSprite.draw(canvas);
        }
    }

    public boolean isDrawingHighlight() {
        return this.mSmartSelectSprite != null && this.mSmartSelectSprite.isAnimationActive();
    }

    private TextClassificationConstants getTextClassificationSettings() {
        return TextClassificationManager.getSettings(this.mTextView.getContext());
    }

    private void cancelAsyncTask() {
        if (this.mTextClassificationAsyncTask != null) {
            this.mTextClassificationAsyncTask.cancel(true);
            this.mTextClassificationAsyncTask = null;
        }
        this.mTextClassification = null;
    }

    private boolean skipTextClassification() {
        boolean noOpTextClassifier = this.mTextView.usesNoOpTextClassifier();
        boolean noSelection = this.mTextView.getSelectionEnd() == this.mTextView.getSelectionStart();
        boolean password = this.mTextView.hasPasswordTransformationMethod() || TextView.isPasswordInputType(this.mTextView.getInputType());
        return noOpTextClassifier || noSelection || password;
    }

    private void startLinkActionMode(SelectionResult result) {
        this.startActionMode(2, result);
    }

    private void startSelectionActionMode(SelectionResult result) {
        this.startActionMode(0, result);
    }

    private void startActionMode(@Editor.TextActionMode int actionMode, SelectionResult result) {
        CharSequence text = SelectionActionModeHelper.getText(this.mTextView);
        if (result != null && text instanceof Spannable && (this.mTextView.isTextSelectable() || this.mTextView.isTextEditable())) {
            if (!this.getTextClassificationSettings().isModelDarkLaunchEnabled()) {
                Selection.setSelection((Spannable)text, result.mStart, result.mEnd);
                this.mTextView.invalidate();
            }
            this.mTextClassification = result.mClassification;
        } else {
            this.mTextClassification = result != null && actionMode == 2 ? result.mClassification : null;
        }
        if (this.mEditor.startActionModeInternal(actionMode)) {
            Editor.SelectionModifierCursorController controller = this.mEditor.getSelectionController();
            if (controller != null && (this.mTextView.isTextSelectable() || this.mTextView.isTextEditable())) {
                controller.show();
            }
            if (result != null) {
                switch (actionMode) {
                    case 0: {
                        this.mSelectionTracker.onSmartSelection(result);
                        break;
                    }
                    case 2: {
                        this.mSelectionTracker.onLinkSelected(result);
                        break;
                    }
                }
            }
        }
        this.mEditor.setRestartActionModeOnNextRefresh(false);
        this.mTextClassificationAsyncTask = null;
    }

    private void startSelectionActionModeWithSmartSelectAnimation(SelectionResult result) {
        boolean didSelectionChange;
        Layout layout2 = this.mTextView.getLayout();
        Runnable onAnimationEndCallback = () -> {
            SelectionResult startSelectionResult = result != null && result.mStart >= 0 && result.mEnd <= SelectionActionModeHelper.getText(this.mTextView).length() && result.mStart <= result.mEnd ? result : null;
            this.startSelectionActionMode(startSelectionResult);
        };
        int[] sortedSelectionIndices = SelectionActionModeHelper.sortSelctionIndicesFromTextView(this.mTextView);
        boolean bl = didSelectionChange = result != null && (sortedSelectionIndices[0] != result.mStart || sortedSelectionIndices[1] != result.mEnd);
        if (!didSelectionChange) {
            onAnimationEndCallback.run();
            return;
        }
        List<SmartSelectSprite.RectangleWithTextSelectionLayout> selectionRectangles = this.convertSelectionToRectangles(layout2, result.mStart, result.mEnd);
        PointF touchPoint = new PointF(this.mEditor.getLastUpPositionX(), this.mEditor.getLastUpPositionY());
        PointF animationStartPoint = SelectionActionModeHelper.movePointInsideNearestRectangle(touchPoint, selectionRectangles, SmartSelectSprite.RectangleWithTextSelectionLayout::getRectangle);
        this.mSmartSelectSprite.startAnimation(animationStartPoint, selectionRectangles, onAnimationEndCallback);
    }

    private List<SmartSelectSprite.RectangleWithTextSelectionLayout> convertSelectionToRectangles(Layout layout2, int start, int end) {
        ArrayList<SmartSelectSprite.RectangleWithTextSelectionLayout> result = new ArrayList<SmartSelectSprite.RectangleWithTextSelectionLayout>();
        Layout.SelectionRectangleConsumer consumer = (left, top, right, bottom, textSelectionLayout) -> SelectionActionModeHelper.mergeRectangleIntoList(result, new RectF(left, top, right, bottom), SmartSelectSprite.RectangleWithTextSelectionLayout::getRectangle, r -> new SmartSelectSprite.RectangleWithTextSelectionLayout((RectF)r, textSelectionLayout));
        layout2.getSelection(start, end, consumer);
        result.sort(Comparator.comparing(SmartSelectSprite.RectangleWithTextSelectionLayout::getRectangle, SmartSelectSprite.RECTANGLE_COMPARATOR));
        return result;
    }

    @VisibleForTesting
    public static <T> void mergeRectangleIntoList(List<T> list, RectF candidate, Function<T, RectF> extractor, Function<RectF, T> packer) {
        int index;
        if (candidate.isEmpty()) {
            return;
        }
        int elementCount = list.size();
        for (index = 0; index < elementCount; ++index) {
            boolean canMerge;
            RectF existingRectangle = extractor.apply(list.get(index));
            if (existingRectangle.contains(candidate)) {
                return;
            }
            if (candidate.contains(existingRectangle)) {
                existingRectangle.setEmpty();
                continue;
            }
            boolean rectanglesContinueEachOther = candidate.left == existingRectangle.right || candidate.right == existingRectangle.left;
            boolean bl = canMerge = candidate.top == existingRectangle.top && candidate.bottom == existingRectangle.bottom && (RectF.intersects(candidate, existingRectangle) || rectanglesContinueEachOther);
            if (!canMerge) continue;
            candidate.union(existingRectangle);
            existingRectangle.setEmpty();
        }
        for (index = elementCount - 1; index >= 0; --index) {
            RectF rectangle = extractor.apply(list.get(index));
            if (!rectangle.isEmpty()) continue;
            list.remove(index);
        }
        list.add(packer.apply(candidate));
    }

    @VisibleForTesting
    public static <T> PointF movePointInsideNearestRectangle(PointF point, List<T> list, Function<T, RectF> extractor) {
        float bestX = -1.0f;
        float bestY = -1.0f;
        double bestDistance = Double.MAX_VALUE;
        int elementCount = list.size();
        for (int index = 0; index < elementCount; ++index) {
            RectF rectangle = extractor.apply(list.get(index));
            float candidateY = rectangle.centerY();
            float candidateX = point.x > rectangle.right ? rectangle.right : (point.x < rectangle.left ? rectangle.left : point.x);
            double candidateDistance = Math.pow(point.x - candidateX, 2.0) + Math.pow(point.y - candidateY, 2.0);
            if (!(candidateDistance < bestDistance)) continue;
            bestX = candidateX;
            bestY = candidateY;
            bestDistance = candidateDistance;
        }
        return new PointF(bestX, bestY);
    }

    private void invalidateActionMode(SelectionResult result) {
        this.cancelSmartSelectAnimation();
        this.mTextClassification = result != null ? result.mClassification : null;
        ActionMode actionMode = this.mEditor.getTextActionMode();
        if (actionMode != null) {
            actionMode.invalidate();
        }
        int[] sortedSelectionIndices = SelectionActionModeHelper.sortSelctionIndicesFromTextView(this.mTextView);
        this.mSelectionTracker.onSelectionUpdated(sortedSelectionIndices[0], sortedSelectionIndices[1], this.mTextClassification);
        this.mTextClassificationAsyncTask = null;
    }

    private void resetTextClassificationHelper(int selectionStart, int selectionEnd) {
        if (selectionStart < 0 || selectionEnd < 0) {
            int[] sortedSelectionIndices = SelectionActionModeHelper.sortSelctionIndicesFromTextView(this.mTextView);
            selectionStart = sortedSelectionIndices[0];
            selectionEnd = sortedSelectionIndices[1];
        }
        this.mTextClassificationHelper.init(this.mTextView::getTextClassificationSession, SelectionActionModeHelper.getText(this.mTextView), selectionStart, selectionEnd, this.mTextView.getTextLocales());
    }

    private void resetTextClassificationHelper() {
        this.resetTextClassificationHelper(-1, -1);
    }

    private void cancelSmartSelectAnimation() {
        if (this.mSmartSelectSprite != null) {
            this.mSmartSelectSprite.cancelAnimation();
        }
    }

    private static int getActionType(int menuItemId) {
        switch (menuItemId) {
            case 16908319: {
                return 200;
            }
            case 0x1020020: {
                return 103;
            }
            case 0x1020021: {
                return 101;
            }
            case 0x1020022: 
            case 16908337: {
                return 102;
            }
            case 16908341: {
                return 104;
            }
            case 16908353: {
                return 105;
            }
        }
        return 108;
    }

    private static CharSequence getText(TextView textView) {
        CharSequence text = textView.getText();
        if (text != null) {
            return text;
        }
        return "";
    }

    private static class SelectionResult {
        private final int mStart;
        private final int mEnd;
        private final TextClassification mClassification;
        private final TextSelection mSelection;

        SelectionResult(int start, int end, TextClassification classification, TextSelection selection) {
            int[] sortedIndices = SelectionActionModeHelper.sortSelctionIndices(start, end);
            this.mStart = sortedIndices[0];
            this.mEnd = sortedIndices[1];
            this.mClassification = classification;
            this.mSelection = selection;
        }
    }

    private static class TextClassificationHelper {
        private static final int TRIM_DELTA = 120;
        private final Context mContext;
        private Supplier<TextClassifier> mTextClassifier;
        private String mText;
        private int mSelectionStart;
        private int mSelectionEnd;
        private LocaleList mDefaultLocales;
        private CharSequence mTrimmedText;
        private int mTrimStart;
        private int mRelativeStart;
        private int mRelativeEnd;
        private CharSequence mLastClassificationText;
        private int mLastClassificationSelectionStart;
        private int mLastClassificationSelectionEnd;
        private LocaleList mLastClassificationLocales;
        private SelectionResult mLastClassificationResult;
        private boolean mHot;

        TextClassificationHelper(Context context, Supplier<TextClassifier> textClassifier, CharSequence text, int selectionStart, int selectionEnd, LocaleList locales) {
            this.init(textClassifier, text, selectionStart, selectionEnd, locales);
            this.mContext = Objects.requireNonNull(context);
        }

        public void init(Supplier<TextClassifier> textClassifier, CharSequence text, int selectionStart, int selectionEnd, LocaleList locales) {
            this.mTextClassifier = Objects.requireNonNull(textClassifier);
            this.mText = Objects.requireNonNull(text).toString();
            this.mLastClassificationText = null;
            Preconditions.checkArgument(selectionEnd > selectionStart);
            this.mSelectionStart = selectionStart;
            this.mSelectionEnd = selectionEnd;
            this.mDefaultLocales = locales;
        }

        public SelectionResult classifyText() {
            this.mHot = true;
            return this.performClassification(null);
        }

        public SelectionResult suggestSelection() {
            TextSelection selection;
            this.mHot = true;
            this.trimText();
            if (this.mContext.getApplicationInfo().targetSdkVersion >= 28) {
                TextSelection.Request request = new TextSelection.Request.Builder(this.mTrimmedText, this.mRelativeStart, this.mRelativeEnd).setDefaultLocales(this.mDefaultLocales).setDarkLaunchAllowed(true).build();
                selection = this.mTextClassifier.get().suggestSelection(request);
            } else {
                selection = this.mTextClassifier.get().suggestSelection(this.mTrimmedText, this.mRelativeStart, this.mRelativeEnd, this.mDefaultLocales);
            }
            if (!this.isDarkLaunchEnabled()) {
                this.mSelectionStart = Math.max(0, selection.getSelectionStartIndex() + this.mTrimStart);
                this.mSelectionEnd = Math.min(this.mText.length(), selection.getSelectionEndIndex() + this.mTrimStart);
            }
            return this.performClassification(selection);
        }

        public SelectionResult getOriginalSelection() {
            return new SelectionResult(this.mSelectionStart, this.mSelectionEnd, null, null);
        }

        public int getTimeoutDuration() {
            if (this.mHot) {
                return 200;
            }
            return 500;
        }

        private boolean isDarkLaunchEnabled() {
            return TextClassificationManager.getSettings(this.mContext).isModelDarkLaunchEnabled();
        }

        private SelectionResult performClassification(TextSelection selection) {
            if (!Objects.equals(this.mText, this.mLastClassificationText) || this.mSelectionStart != this.mLastClassificationSelectionStart || this.mSelectionEnd != this.mLastClassificationSelectionEnd || !Objects.equals(this.mDefaultLocales, this.mLastClassificationLocales)) {
                TextClassification classification;
                this.mLastClassificationText = this.mText;
                this.mLastClassificationSelectionStart = this.mSelectionStart;
                this.mLastClassificationSelectionEnd = this.mSelectionEnd;
                this.mLastClassificationLocales = this.mDefaultLocales;
                this.trimText();
                if (Linkify.containsUnsupportedCharacters(this.mText)) {
                    EventLog.writeEvent(1397638484, "116321860", -1, "");
                    classification = TextClassification.EMPTY;
                } else if (this.mContext.getApplicationInfo().targetSdkVersion >= 28) {
                    TextClassification.Request request = new TextClassification.Request.Builder(this.mTrimmedText, this.mRelativeStart, this.mRelativeEnd).setDefaultLocales(this.mDefaultLocales).build();
                    classification = this.mTextClassifier.get().classifyText(request);
                } else {
                    classification = this.mTextClassifier.get().classifyText(this.mTrimmedText, this.mRelativeStart, this.mRelativeEnd, this.mDefaultLocales);
                }
                this.mLastClassificationResult = new SelectionResult(this.mSelectionStart, this.mSelectionEnd, classification, selection);
            }
            return this.mLastClassificationResult;
        }

        private void trimText() {
            this.mTrimStart = Math.max(0, this.mSelectionStart - 120);
            int referenceEnd = Math.min(this.mText.length(), this.mSelectionEnd + 120);
            this.mTrimmedText = this.mText.subSequence(this.mTrimStart, referenceEnd);
            this.mRelativeStart = this.mSelectionStart - this.mTrimStart;
            this.mRelativeEnd = this.mSelectionEnd - this.mTrimStart;
        }
    }

    private static class TextClassificationAsyncTask
    extends AsyncTask<Void, Void, SelectionResult> {
        private final int mTimeOutDuration;
        private final Supplier<SelectionResult> mSelectionResultSupplier;
        private final Consumer<SelectionResult> mSelectionResultCallback;
        private final Supplier<SelectionResult> mTimeOutResultSupplier;
        private final TextView mTextView;
        private final String mOriginalText;

        TextClassificationAsyncTask(TextView textView, int timeOut, Supplier<SelectionResult> selectionResultSupplier, Consumer<SelectionResult> selectionResultCallback, Supplier<SelectionResult> timeOutResultSupplier) {
            super(textView != null ? textView.getHandler() : null);
            this.mTextView = Objects.requireNonNull(textView);
            this.mTimeOutDuration = timeOut;
            this.mSelectionResultSupplier = Objects.requireNonNull(selectionResultSupplier);
            this.mSelectionResultCallback = Objects.requireNonNull(selectionResultCallback);
            this.mTimeOutResultSupplier = Objects.requireNonNull(timeOutResultSupplier);
            this.mOriginalText = SelectionActionModeHelper.getText(this.mTextView).toString();
        }

        protected SelectionResult doInBackground(Void ... params) {
            Runnable onTimeOut = this::onTimeOut;
            this.mTextView.postDelayed(onTimeOut, this.mTimeOutDuration);
            SelectionResult result = this.mSelectionResultSupplier.get();
            this.mTextView.removeCallbacks(onTimeOut);
            return result;
        }

        @Override
        protected void onPostExecute(SelectionResult result) {
            result = TextUtils.equals(this.mOriginalText, SelectionActionModeHelper.getText(this.mTextView)) ? result : null;
            this.mSelectionResultCallback.accept(result);
        }

        private void onTimeOut() {
            Log.d(SelectionActionModeHelper.LOG_TAG, "Timeout in TextClassificationAsyncTask");
            if (this.getStatus() == AsyncTask.Status.RUNNING) {
                this.onPostExecute(this.mTimeOutResultSupplier.get());
            }
            this.cancel(true);
        }
    }

    private static class SelectionMetricsLogger {
        private static final String LOG_TAG = "SelectionMetricsLogger";
        private static final Pattern PATTERN_WHITESPACE = Pattern.compile("\\s+");
        private final boolean mEditTextLogger;
        private final BreakIterator mTokenIterator;
        private TextClassifier mClassificationSession;
        private TextClassificationContext mClassificationContext;
        private TextClassifierEvent mTranslateViewEvent;
        private TextClassifierEvent mTranslateClickEvent;
        private int mStartIndex;
        private String mText;

        SelectionMetricsLogger(TextView textView) {
            Objects.requireNonNull(textView);
            this.mEditTextLogger = textView.isTextEditable();
            this.mTokenIterator = BreakIterator.getWordInstance(textView.getTextLocale());
        }

        public void logSelectionStarted(TextClassifier classificationSession, TextClassificationContext classificationContext, CharSequence text, int index, int invocationMethod) {
            try {
                Objects.requireNonNull(text);
                Preconditions.checkArgumentInRange(index, 0, text.length(), "index");
                if (this.mText == null || !this.mText.contentEquals(text)) {
                    this.mText = text.toString();
                }
                this.mTokenIterator.setText(this.mText);
                this.mStartIndex = index;
                this.mClassificationSession = classificationSession;
                this.mClassificationContext = classificationContext;
                if (this.hasActiveClassificationSession()) {
                    this.mClassificationSession.onSelectionEvent(SelectionEvent.createSelectionStartedEvent(invocationMethod, 0));
                }
            }
            catch (Exception e) {
                Log.e(LOG_TAG, "" + e.getMessage(), e);
            }
        }

        public void logSelectionModified(int start, int end, TextClassification classification, TextSelection selection) {
            try {
                if (this.hasActiveClassificationSession()) {
                    Preconditions.checkArgumentInRange(start, 0, this.mText.length(), "start");
                    Preconditions.checkArgumentInRange(end, start, this.mText.length(), "end");
                    int[] wordIndices = this.getWordDelta(start, end);
                    if (selection != null) {
                        this.mClassificationSession.onSelectionEvent(SelectionEvent.createSelectionModifiedEvent(wordIndices[0], wordIndices[1], selection));
                    } else if (classification != null) {
                        this.mClassificationSession.onSelectionEvent(SelectionEvent.createSelectionModifiedEvent(wordIndices[0], wordIndices[1], classification));
                    } else {
                        this.mClassificationSession.onSelectionEvent(SelectionEvent.createSelectionModifiedEvent(wordIndices[0], wordIndices[1]));
                    }
                    this.maybeGenerateTranslateViewEvent(classification);
                }
            }
            catch (Exception e) {
                Log.e(LOG_TAG, "" + e.getMessage(), e);
            }
        }

        public void logSelectionAction(int start, int end, int action, String actionLabel, TextClassification classification) {
            try {
                if (this.hasActiveClassificationSession()) {
                    Preconditions.checkArgumentInRange(start, 0, this.mText.length(), "start");
                    Preconditions.checkArgumentInRange(end, start, this.mText.length(), "end");
                    int[] wordIndices = this.getWordDelta(start, end);
                    if (classification != null) {
                        this.mClassificationSession.onSelectionEvent(SelectionEvent.createSelectionActionEvent(wordIndices[0], wordIndices[1], action, classification));
                    } else {
                        this.mClassificationSession.onSelectionEvent(SelectionEvent.createSelectionActionEvent(wordIndices[0], wordIndices[1], action));
                    }
                    this.maybeGenerateTranslateClickEvent(classification, actionLabel);
                    if (SelectionEvent.isTerminal(action)) {
                        this.endTextClassificationSession();
                    }
                }
            }
            catch (Exception e) {
                Log.e(LOG_TAG, "" + e.getMessage(), e);
            }
        }

        public boolean isEditTextLogger() {
            return this.mEditTextLogger;
        }

        public void endTextClassificationSession() {
            if (this.hasActiveClassificationSession()) {
                this.maybeReportTranslateEvents();
                this.mClassificationSession.destroy();
            }
        }

        private boolean hasActiveClassificationSession() {
            return this.mClassificationSession != null && !this.mClassificationSession.isDestroyed();
        }

        private int[] getWordDelta(int start, int end) {
            int[] wordIndices = new int[2];
            if (start == this.mStartIndex) {
                wordIndices[0] = 0;
            } else if (start < this.mStartIndex) {
                wordIndices[0] = -this.countWordsForward(start);
            } else {
                wordIndices[0] = this.countWordsBackward(start);
                if (!this.mTokenIterator.isBoundary(start) && !this.isWhitespace(this.mTokenIterator.preceding(start), this.mTokenIterator.following(start))) {
                    wordIndices[0] = wordIndices[0] - 1;
                }
            }
            wordIndices[1] = end == this.mStartIndex ? 0 : (end < this.mStartIndex ? -this.countWordsForward(end) : this.countWordsBackward(end));
            return wordIndices;
        }

        private int countWordsBackward(int from) {
            Preconditions.checkArgument(from >= this.mStartIndex);
            int wordCount = 0;
            int offset = from;
            while (offset > this.mStartIndex) {
                int start = this.mTokenIterator.preceding(offset);
                if (!this.isWhitespace(start, offset)) {
                    ++wordCount;
                }
                offset = start;
            }
            return wordCount;
        }

        private int countWordsForward(int from) {
            Preconditions.checkArgument(from <= this.mStartIndex);
            int wordCount = 0;
            int offset = from;
            while (offset < this.mStartIndex) {
                int end = this.mTokenIterator.following(offset);
                if (!this.isWhitespace(offset, end)) {
                    ++wordCount;
                }
                offset = end;
            }
            return wordCount;
        }

        private boolean isWhitespace(int start, int end) {
            return PATTERN_WHITESPACE.matcher(this.mText.substring(start, end)).matches();
        }

        private void maybeGenerateTranslateViewEvent(TextClassification classification) {
            if (classification != null) {
                TextClassifierEvent event = SelectionMetricsLogger.generateTranslateEvent(6, classification, this.mClassificationContext, null);
                this.mTranslateViewEvent = event != null ? event : this.mTranslateViewEvent;
            }
        }

        private void maybeGenerateTranslateClickEvent(TextClassification classification, String actionLabel) {
            if (classification != null) {
                this.mTranslateClickEvent = SelectionMetricsLogger.generateTranslateEvent(13, classification, this.mClassificationContext, actionLabel);
            }
        }

        private void maybeReportTranslateEvents() {
            if (this.mTranslateViewEvent != null) {
                this.mClassificationSession.onTextClassifierEvent(this.mTranslateViewEvent);
                this.mTranslateViewEvent = null;
            }
            if (this.mTranslateClickEvent != null) {
                this.mClassificationSession.onTextClassifierEvent(this.mTranslateClickEvent);
                this.mTranslateClickEvent = null;
            }
        }

        private static TextClassifierEvent generateTranslateEvent(int eventType, TextClassification classification, TextClassificationContext classificationContext, String actionLabel) {
            RemoteAction translateAction = ExtrasUtils.findTranslateAction(classification);
            if (translateAction == null) {
                return null;
            }
            if (eventType == 13 && !translateAction.getTitle().toString().equals(actionLabel)) {
                return null;
            }
            Bundle foreignLanguageExtra = ExtrasUtils.getForeignLanguageExtra(classification);
            String language = ExtrasUtils.getEntityType(foreignLanguageExtra);
            float score = ExtrasUtils.getScore(foreignLanguageExtra);
            String model = ExtrasUtils.getModelName(foreignLanguageExtra);
            return ((TextClassifierEvent.LanguageDetectionEvent.Builder)((TextClassifierEvent.LanguageDetectionEvent.Builder)((TextClassifierEvent.LanguageDetectionEvent.Builder)((TextClassifierEvent.LanguageDetectionEvent.Builder)((TextClassifierEvent.LanguageDetectionEvent.Builder)new TextClassifierEvent.LanguageDetectionEvent.Builder(eventType).setEventContext(classificationContext)).setResultId(classification.getId())).setScores(score)).setActionIndices(classification.getActions().indexOf(translateAction))).setModelName(model)).build();
        }
    }

    private static class SelectionTracker {
        private final TextView mTextView;
        private SelectionMetricsLogger mLogger;
        private int mOriginalStart;
        private int mOriginalEnd;
        private int mSelectionStart;
        private int mSelectionEnd;
        private boolean mAllowReset;
        private final LogAbandonRunnable mDelayedLogAbandon = new LogAbandonRunnable();

        SelectionTracker(TextView textView) {
            this.mTextView = Objects.requireNonNull(textView);
            this.mLogger = new SelectionMetricsLogger(textView);
        }

        public void onOriginalSelection(CharSequence text, int selectionStart, int selectionEnd, boolean isLink) {
            this.mDelayedLogAbandon.flush();
            this.mOriginalStart = this.mSelectionStart = selectionStart;
            this.mOriginalEnd = this.mSelectionEnd = selectionEnd;
            this.mAllowReset = false;
            this.maybeInvalidateLogger();
            this.mLogger.logSelectionStarted(this.mTextView.getTextClassificationSession(), this.mTextView.getTextClassificationContext(), text, selectionStart, isLink ? 2 : 1);
        }

        public void onSmartSelection(SelectionResult result) {
            this.onClassifiedSelection(result);
            this.mLogger.logSelectionModified(result.mStart, result.mEnd, result.mClassification, result.mSelection);
        }

        public void onLinkSelected(SelectionResult result) {
            this.onClassifiedSelection(result);
        }

        private void onClassifiedSelection(SelectionResult result) {
            if (this.isSelectionStarted()) {
                this.mSelectionStart = result.mStart;
                this.mSelectionEnd = result.mEnd;
                this.mAllowReset = this.mSelectionStart != this.mOriginalStart || this.mSelectionEnd != this.mOriginalEnd;
            }
        }

        public void onSelectionUpdated(int selectionStart, int selectionEnd, TextClassification classification) {
            if (this.isSelectionStarted()) {
                this.mSelectionStart = selectionStart;
                this.mSelectionEnd = selectionEnd;
                this.mAllowReset = false;
                this.mLogger.logSelectionModified(selectionStart, selectionEnd, classification, null);
            }
        }

        public void onSelectionDestroyed() {
            this.mAllowReset = false;
            this.mDelayedLogAbandon.schedule(100);
        }

        public void onSelectionAction(int selectionStart, int selectionEnd, int action, String actionLabel, TextClassification classification) {
            if (this.isSelectionStarted()) {
                this.mAllowReset = false;
                this.mLogger.logSelectionAction(selectionStart, selectionEnd, action, actionLabel, classification);
            }
        }

        public boolean resetSelection(int textIndex, Editor editor) {
            TextView textView = editor.getTextView();
            if (this.isSelectionStarted() && this.mAllowReset && textIndex >= this.mSelectionStart && textIndex <= this.mSelectionEnd && SelectionActionModeHelper.getText(textView) instanceof Spannable) {
                this.mAllowReset = false;
                boolean selected = editor.selectCurrentWord();
                if (selected) {
                    int[] sortedSelectionIndices = SelectionActionModeHelper.sortSelctionIndicesFromTextView(textView);
                    this.mSelectionStart = sortedSelectionIndices[0];
                    this.mSelectionEnd = sortedSelectionIndices[1];
                    this.mLogger.logSelectionAction(sortedSelectionIndices[0], sortedSelectionIndices[1], 201, null, null);
                }
                return selected;
            }
            return false;
        }

        public void onTextChanged(int start, int end, TextClassification classification) {
            if (this.isSelectionStarted() && start == this.mSelectionStart && end == this.mSelectionEnd) {
                this.onSelectionAction(start, end, 100, null, classification);
            }
        }

        private void maybeInvalidateLogger() {
            if (this.mLogger.isEditTextLogger() != this.mTextView.isTextEditable()) {
                this.mLogger = new SelectionMetricsLogger(this.mTextView);
            }
        }

        private boolean isSelectionStarted() {
            return this.mSelectionStart >= 0 && this.mSelectionEnd >= 0 && this.mSelectionStart != this.mSelectionEnd;
        }

        private class LogAbandonRunnable
        implements Runnable {
            private boolean mIsPending;

            private LogAbandonRunnable() {
            }

            void schedule(int delayMillis) {
                if (this.mIsPending) {
                    Log.e(SelectionActionModeHelper.LOG_TAG, "Force flushing abandon due to new scheduling request");
                    this.flush();
                }
                this.mIsPending = true;
                SelectionTracker.this.mTextView.postDelayed(this, delayMillis);
            }

            void flush() {
                SelectionTracker.this.mTextView.removeCallbacks(this);
                this.run();
            }

            @Override
            public void run() {
                if (this.mIsPending) {
                    SelectionTracker.this.mLogger.logSelectionAction(SelectionTracker.this.mSelectionStart, SelectionTracker.this.mSelectionEnd, 107, null, null);
                    SelectionTracker.this.mSelectionStart = (SelectionTracker.this.mSelectionEnd = -1);
                    SelectionTracker.this.mLogger.endTextClassificationSession();
                    this.mIsPending = false;
                }
            }
        }
    }
}

