/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.ClipData;
import android.content.res.Configuration;
import android.graphics.PixelFormat;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.Region;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import android.util.MergedConfiguration;
import android.view.DisplayCutout;
import android.view.IWindow;
import android.view.IWindowId;
import android.view.IWindowSession;
import android.view.InputChannel;
import android.view.InsetsSourceControl;
import android.view.InsetsState;
import android.view.SurfaceControl;
import android.view.SurfaceSession;
import android.view.View;
import android.view.ViewRootImpl;
import android.view.WindowManager;
import android.view.WindowManagerGlobal;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;

public class WindowlessWindowManager
implements IWindowSession {
    private static final String TAG = "WindowlessWindowManager";
    final HashMap<IBinder, State> mStateForWindow = new HashMap();
    final HashMap<IBinder, ResizeCompleteCallback> mResizeCompletionForWindow = new HashMap();
    private final SurfaceSession mSurfaceSession = new SurfaceSession();
    private final SurfaceControl mRootSurface;
    private final Configuration mConfiguration;
    private final IWindowSession mRealWm;
    private final IBinder mHostInputToken;
    private int mForceHeight = -1;
    private int mForceWidth = -1;

    public WindowlessWindowManager(Configuration c, SurfaceControl rootSurface, IBinder hostInputToken) {
        this.mRootSurface = rootSurface;
        this.mConfiguration = new Configuration(c);
        this.mRealWm = WindowManagerGlobal.getWindowSession();
        this.mHostInputToken = hostInputToken;
    }

    protected void setConfiguration(Configuration configuration) {
        this.mConfiguration.setTo(configuration);
    }

    void setCompletionCallback(IBinder window, ResizeCompleteCallback callback) {
        if (this.mResizeCompletionForWindow.get(window) != null) {
            Log.w(TAG, "Unsupported overlapping resizes");
        }
        this.mResizeCompletionForWindow.put(window, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setTouchRegion(IBinder window, Region region) {
        WindowlessWindowManager windowlessWindowManager = this;
        synchronized (windowlessWindowManager) {
            State state = this.mStateForWindow.get(window);
            if (state == null) {
                return;
            }
            if (Objects.equals(region, state.mInputRegion)) {
                return;
            }
            Region region2 = state.mInputRegion = region != null ? new Region(region) : null;
            if (state.mInputChannelToken != null) {
                try {
                    this.mRealWm.updateInputChannel(state.mInputChannelToken, state.mDisplayId, state.mSurfaceControl, state.mParams.flags, state.mInputRegion);
                }
                catch (RemoteException e) {
                    Log.e(TAG, "Failed to update surface input channel: ", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int addToDisplay(IWindow window, int seq, WindowManager.LayoutParams attrs, int viewVisibility, int displayId, Rect outFrame, Rect outContentInsets, Rect outStableInsets, DisplayCutout.ParcelableWrapper outDisplayCutout, InputChannel outInputChannel, InsetsState outInsetsState, InsetsSourceControl[] outActiveControls) {
        SurfaceControl.Builder b = new SurfaceControl.Builder(this.mSurfaceSession).setParent(this.mRootSurface).setFormat(attrs.format).setBufferSize(this.getSurfaceWidth(attrs), this.getSurfaceHeight(attrs)).setName(attrs.getTitle().toString()).setCallsite("WindowlessWindowManager.addToDisplay");
        SurfaceControl sc = b.build();
        if ((attrs.inputFeatures & 2) == 0) {
            try {
                this.mRealWm.grantInputChannel(displayId, sc, window, this.mHostInputToken, attrs.flags, attrs.type, outInputChannel);
            }
            catch (RemoteException e) {
                Log.e(TAG, "Failed to grant input to surface: ", e);
            }
        }
        State state = new State(sc, attrs, displayId, outInputChannel != null ? outInputChannel.getToken() : null);
        WindowlessWindowManager windowlessWindowManager = this;
        synchronized (windowlessWindowManager) {
            this.mStateForWindow.put(window.asBinder(), state);
        }
        return 2;
    }

    @Override
    public int addToDisplayAsUser(IWindow window, int seq, WindowManager.LayoutParams attrs, int viewVisibility, int displayId, int userId, Rect outFrame, Rect outContentInsets, Rect outStableInsets, DisplayCutout.ParcelableWrapper outDisplayCutout, InputChannel outInputChannel, InsetsState outInsetsState, InsetsSourceControl[] outActiveControls) {
        return this.addToDisplay(window, seq, attrs, viewVisibility, displayId, outFrame, outContentInsets, outStableInsets, outDisplayCutout, outInputChannel, outInsetsState, outActiveControls);
    }

    @Override
    public int addToDisplayWithoutInputChannel(IWindow window, int seq, WindowManager.LayoutParams attrs, int viewVisibility, int layerStackId, Rect outContentInsets, Rect outStableInsets, InsetsState insetsState) {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(IWindow window) throws RemoteException {
        State state;
        this.mRealWm.remove(window);
        WindowlessWindowManager windowlessWindowManager = this;
        synchronized (windowlessWindowManager) {
            state = this.mStateForWindow.remove(window.asBinder());
        }
        if (state == null) {
            throw new IllegalArgumentException("Invalid window token (never added or removed already)");
        }
        try (SurfaceControl.Transaction t = new SurfaceControl.Transaction();){
            t.remove(state.mSurfaceControl).apply();
        }
    }

    private boolean isOpaque(WindowManager.LayoutParams attrs) {
        if (attrs.surfaceInsets != null && attrs.surfaceInsets.left != 0 || attrs.surfaceInsets.top != 0 || attrs.surfaceInsets.right != 0 || attrs.surfaceInsets.bottom != 0) {
            return false;
        }
        return !PixelFormat.formatHasAlpha(attrs.format);
    }

    protected SurfaceControl getSurfaceControl(View rootView) {
        ViewRootImpl root = rootView.getViewRootImpl();
        if (root == null) {
            return null;
        }
        State s = this.mStateForWindow.get(root.mWindow.asBinder());
        if (s == null) {
            return null;
        }
        return s.mSurfaceControl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int relayout(IWindow window, int seq, WindowManager.LayoutParams inAttrs, int requestedWidth, int requestedHeight, int viewFlags, int flags, long frameNumber, Rect outFrame, Rect outContentInsets, Rect outVisibleInsets, Rect outStableInsets, Rect outBackdropFrame, DisplayCutout.ParcelableWrapper cutout, MergedConfiguration mergedConfiguration, SurfaceControl outSurfaceControl, InsetsState outInsetsState, InsetsSourceControl[] outActiveControls, Point outSurfaceSize, SurfaceControl outBLASTSurfaceControl) {
        State state;
        WindowlessWindowManager windowlessWindowManager = this;
        synchronized (windowlessWindowManager) {
            state = this.mStateForWindow.get(window.asBinder());
        }
        if (state == null) {
            throw new IllegalArgumentException("Invalid window token (never added or removed already)");
        }
        SurfaceControl sc = state.mSurfaceControl;
        SurfaceControl.Transaction t = new SurfaceControl.Transaction();
        int attrChanges = 0;
        if (inAttrs != null) {
            attrChanges = state.mParams.copyFrom(inAttrs);
        }
        WindowManager.LayoutParams attrs = state.mParams;
        if (viewFlags == 0) {
            t.setBufferSize(sc, this.getSurfaceWidth(attrs), this.getSurfaceHeight(attrs)).setOpaque(sc, this.isOpaque(attrs)).show(sc).apply();
            outSurfaceControl.copyFrom(sc, "WindowlessWindowManager.relayout");
        } else {
            t.hide(sc).apply();
            outSurfaceControl.release();
        }
        outFrame.set(0, 0, attrs.width, attrs.height);
        mergedConfiguration.setConfiguration(this.mConfiguration, this.mConfiguration);
        if ((attrChanges & 4) != 0 && state.mInputChannelToken != null) {
            try {
                this.mRealWm.updateInputChannel(state.mInputChannelToken, state.mDisplayId, sc, attrs.flags, state.mInputRegion);
            }
            catch (RemoteException e) {
                Log.e(TAG, "Failed to update surface input channel: ", e);
            }
        }
        return 0;
    }

    @Override
    public void prepareToReplaceWindows(IBinder appToken, boolean childrenOnly) {
    }

    @Override
    public boolean outOfMemory(IWindow window) {
        return false;
    }

    @Override
    public void setTransparentRegion(IWindow window, Region region) {
    }

    @Override
    public void setInsets(IWindow window, int touchableInsets, Rect contentInsets, Rect visibleInsets, Region touchableRegion) {
    }

    @Override
    public void getDisplayFrame(IWindow window, Rect outDisplayFrame) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finishDrawing(IWindow window, SurfaceControl.Transaction postDrawTransaction) {
        WindowlessWindowManager windowlessWindowManager = this;
        synchronized (windowlessWindowManager) {
            ResizeCompleteCallback c = this.mResizeCompletionForWindow.get(window.asBinder());
            if (c == null) {
                postDrawTransaction.apply();
                return;
            }
            c.finished(postDrawTransaction);
            this.mResizeCompletionForWindow.remove(window.asBinder());
        }
    }

    @Override
    public void setInTouchMode(boolean showFocus) {
    }

    @Override
    public boolean getInTouchMode() {
        return false;
    }

    @Override
    public boolean performHapticFeedback(int effectId, boolean always) {
        return false;
    }

    @Override
    public IBinder performDrag(IWindow window, int flags, SurfaceControl surface, int touchSource, float touchX, float touchY, float thumbCenterX, float thumbCenterY, ClipData data) {
        return null;
    }

    @Override
    public void reportDropResult(IWindow window, boolean consumed) {
    }

    @Override
    public void cancelDragAndDrop(IBinder dragToken, boolean skipAnimation) {
    }

    @Override
    public void dragRecipientEntered(IWindow window) {
    }

    @Override
    public void dragRecipientExited(IWindow window) {
    }

    @Override
    public void setWallpaperPosition(IBinder windowToken, float x, float y, float xstep, float ystep) {
    }

    @Override
    public void setWallpaperZoomOut(IBinder windowToken, float zoom) {
    }

    @Override
    public void setShouldZoomOutWallpaper(IBinder windowToken, boolean shouldZoom) {
    }

    @Override
    public void wallpaperOffsetsComplete(IBinder window) {
    }

    @Override
    public void setWallpaperDisplayOffset(IBinder windowToken, int x, int y) {
    }

    @Override
    public Bundle sendWallpaperCommand(IBinder window, String action, int x, int y, int z, Bundle extras, boolean sync) {
        return null;
    }

    @Override
    public void wallpaperCommandComplete(IBinder window, Bundle result) {
    }

    @Override
    public void onRectangleOnScreenRequested(IBinder token, Rect rectangle) {
    }

    @Override
    public IWindowId getWindowId(IBinder window) {
        return null;
    }

    @Override
    public void pokeDrawLock(IBinder window) {
    }

    @Override
    public boolean startMovingTask(IWindow window, float startX, float startY) {
        return false;
    }

    @Override
    public void finishMovingTask(IWindow window) {
    }

    @Override
    public void updatePointerIcon(IWindow window) {
    }

    @Override
    public void reparentDisplayContent(IWindow window, SurfaceControl sc, int displayId) {
    }

    @Override
    public void updateDisplayContentLocation(IWindow window, int x, int y, int displayId) {
    }

    @Override
    public void updateTapExcludeRegion(IWindow window, Region region) {
    }

    @Override
    public void insetsModified(IWindow window, InsetsState state) {
    }

    @Override
    public void reportSystemGestureExclusionChanged(IWindow window, List<Rect> exclusionRects) {
    }

    @Override
    public void grantInputChannel(int displayId, SurfaceControl surface, IWindow window, IBinder hostInputToken, int flags, int type, InputChannel outInputChannel) {
    }

    @Override
    public void updateInputChannel(IBinder channelToken, int displayId, SurfaceControl surface, int flags, Region region) {
    }

    @Override
    public IBinder asBinder() {
        return null;
    }

    private int getSurfaceWidth(WindowManager.LayoutParams attrs) {
        Rect surfaceInsets = attrs.surfaceInsets;
        return surfaceInsets != null ? attrs.width + surfaceInsets.left + surfaceInsets.right : attrs.width;
    }

    private int getSurfaceHeight(WindowManager.LayoutParams attrs) {
        Rect surfaceInsets = attrs.surfaceInsets;
        return surfaceInsets != null ? attrs.height + surfaceInsets.top + surfaceInsets.bottom : attrs.height;
    }

    public static interface ResizeCompleteCallback {
        public void finished(SurfaceControl.Transaction var1);
    }

    private class State {
        SurfaceControl mSurfaceControl;
        WindowManager.LayoutParams mParams = new WindowManager.LayoutParams();
        int mDisplayId;
        IBinder mInputChannelToken;
        Region mInputRegion;

        State(SurfaceControl sc, WindowManager.LayoutParams p, int displayId, IBinder inputChannelToken) {
            this.mSurfaceControl = sc;
            this.mParams.copyFrom(p);
            this.mDisplayId = displayId;
            this.mInputChannelToken = inputChannelToken;
        }
    }
}

